/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.inventory.container;

import cofh.core.init.CoreContainers;
import cofh.core.inventory.container.ContainerCoFH;
import cofh.core.network.packet.client.ContainerGuiPacket;
import cofh.core.network.packet.server.ContainerConfigPacket;
import cofh.core.util.filter.BaseFluidFilter;
import cofh.core.util.filter.IFilterOptions;
import cofh.core.util.filter.IFilterableItem;
import cofh.core.util.filter.IFilterableTile;
import cofh.core.util.helpers.FilterHelper;
import cofh.lib.inventory.container.slot.SlotFalseCopy;
import cofh.lib.inventory.container.slot.SlotLocked;
import cofh.lib.inventory.wrapper.InvWrapperFluids;
import cofh.lib.util.helpers.MathHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;

public class FluidFilterContainer
extends ContainerCoFH
implements IFilterOptions {
    protected BlockEntity tile;
    protected IFilterableTile filterableTile;
    protected ItemStack filterStack;
    protected IFilterableItem filterableItem;
    public SlotLocked lockedSlot;
    protected BaseFluidFilter filter;
    protected InvWrapperFluids filterInventory;
    public final boolean held;

    public FluidFilterContainer(int windowId, Level world, Inventory inventory, Player player, boolean held, BlockPos pos) {
        super((MenuType)CoreContainers.FLUID_FILTER_CONTAINER.get(), windowId, inventory, player);
        this.held = held;
        if (held) {
            this.filterStack = FilterHelper.hasFilter(player.m_21205_()) ? player.m_21205_() : player.m_21206_();
            this.filterableItem = (IFilterableItem)this.filterStack.m_41720_();
            this.filter = (BaseFluidFilter)this.filterableItem.getFilter(this.filterStack);
        } else {
            this.tile = world.m_7702_(pos);
            this.filterableTile = (IFilterableTile)this.tile;
            this.filter = (BaseFluidFilter)this.filterableTile.getFilter();
        }
        this.allowSwap = false;
        int slots = this.filter.size();
        this.filterInventory = new InvWrapperFluids(this, this.filter.getFluids(), slots){

            @Override
            public void m_6596_() {
                FluidFilterContainer.this.filter.setFluids(FluidFilterContainer.this.filterInventory.getStacks());
            }
        };
        int rows = MathHelper.clamp(slots / 3, 1, 3);
        int rowSize = slots / rows;
        int xOffset = 62 - 9 * rowSize;
        int yOffset = 44 - 9 * rows;
        for (int i = 0; i < this.filter.size(); ++i) {
            this.m_38897_(new SlotFalseCopy(this.filterInventory, i, xOffset + i % rowSize * 18, yOffset + i / rowSize * 18));
        }
        this.bindPlayerInventory(inventory);
    }

    @Override
    protected void bindPlayerInventory(Inventory inventory) {
        if (this.held) {
            int i;
            int xOffset = this.getPlayerInventoryHorizontalOffset();
            int yOffset = this.getPlayerInventoryVerticalOffset();
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
                }
            }
            for (i = 0; i < 9; ++i) {
                if (i == inventory.f_35977_) {
                    this.lockedSlot = new SlotLocked((Container)inventory, i, xOffset + i * 18, yOffset + 58);
                    this.m_38897_(this.lockedSlot);
                    continue;
                }
                this.m_38897_(new Slot((Container)inventory, i, xOffset + i * 18, yOffset + 58));
            }
        } else {
            super.bindPlayerInventory(inventory);
        }
    }

    public IFilterableTile getFilterableTile() {
        return this.filterableTile;
    }

    public int getFilterSize() {
        return this.filter.size();
    }

    public List<FluidStack> getFilterStacks() {
        return this.filterInventory.getStacks();
    }

    @Override
    protected int getMergeableSlotCount() {
        return this.filterInventory.m_6643_();
    }

    public boolean m_6875_(Player player) {
        if (this.held) {
            return this.lockedSlot.m_7993_() == this.filterStack;
        }
        if (!FilterHelper.hasFilter(this.filterableTile)) {
            return false;
        }
        return this.tile != null && !this.tile.m_58901_() && this.tile.m_58899_().m_203193_((Position)player.m_20182_()) <= 64.0;
    }

    public void m_38946_() {
        super.m_38946_();
        ContainerGuiPacket.sendToClient(this, this.player);
    }

    public void m_6877_(Player playerIn) {
        this.filter.setFluids(this.filterInventory.getStacks());
        if (this.held) {
            this.filter.write(this.filterStack.m_41784_());
            this.filterableItem.onFilterChanged(this.filterStack);
        } else {
            this.filterableTile.onFilterChanged();
        }
        super.m_6877_(playerIn);
    }

    @Override
    public FriendlyByteBuf getConfigPacket(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.getAllowList());
        buffer.writeBoolean(this.getCheckNBT());
        return buffer;
    }

    @Override
    public void handleConfigPacket(FriendlyByteBuf buffer) {
        this.filter.setAllowList(buffer.readBoolean());
        this.filter.setCheckNBT(buffer.readBoolean());
    }

    @Override
    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        int size = this.filter.getFluids().size();
        buffer.writeByte(size);
        for (int i = 0; i < size; ++i) {
            buffer.writeFluidStack(this.getFilterStacks().get(i));
        }
        return buffer;
    }

    @Override
    public void handleGuiPacket(FriendlyByteBuf buffer) {
        int size = buffer.readByte();
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>(size);
        for (int i = 0; i < size; ++i) {
            fluidStacks.add(buffer.readFluidStack());
        }
        this.filterInventory.readFromSource(fluidStacks);
    }

    @Override
    public boolean getAllowList() {
        return this.filter.getAllowList();
    }

    @Override
    public boolean setAllowList(boolean allowList) {
        boolean ret = this.filter.setAllowList(allowList);
        ContainerConfigPacket.sendToServer(this);
        return ret;
    }

    @Override
    public boolean getCheckNBT() {
        return this.filter.getCheckNBT();
    }

    @Override
    public boolean setCheckNBT(boolean checkNBT) {
        boolean ret = this.filter.setCheckNBT(checkNBT);
        ContainerConfigPacket.sendToServer(this);
        return ret;
    }
}

