/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.munitions.config.MunitionProperties;
import rbasamoyai.createbigcannons.network.RootPacket;

public class MunitionPropertiesHandler {
    public static Map<EntityType<?>, MunitionProperties> PROJECTILES = new HashMap();
    private static final MunitionProperties DEFAULT = new MunitionProperties(0.0, 0.0, 0.0, true, false, false, -0.05, 0.99, null);

    public static MunitionProperties getProperties(EntityType<?> type) {
        return PROJECTILES.getOrDefault(type, DEFAULT);
    }

    public static MunitionProperties getProperties(Entity entity) {
        return MunitionPropertiesHandler.getProperties(entity.m_6095_());
    }

    public static void writeBuf(FriendlyByteBuf buf) {
        buf.m_130130_(PROJECTILES.size());
        for (Map.Entry<EntityType<?>, MunitionProperties> entry : PROJECTILES.entrySet()) {
            buf.m_130070_(Registry.f_122826_.m_7981_(entry.getKey()).toString());
            entry.getValue().writeBuf(buf);
        }
    }

    public static void readBuf(FriendlyByteBuf buf) {
        PROJECTILES.clear();
        int sz = buf.m_130242_();
        for (int i = 0; i < sz; ++i) {
            PROJECTILES.put((EntityType)Registry.f_122826_.m_7745_(new ResourceLocation(buf.m_130277_())), MunitionProperties.readBuf(buf));
        }
    }

    public static void syncTo(ServerPlayer player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundMunitionPropertiesPacket(), player);
    }

    public record ClientboundMunitionPropertiesPacket(@Nullable FriendlyByteBuf buf) implements RootPacket
    {
        public ClientboundMunitionPropertiesPacket() {
            this(null);
        }

        public static ClientboundMunitionPropertiesPacket copyOf(FriendlyByteBuf buf) {
            return new ClientboundMunitionPropertiesPacket(new FriendlyByteBuf(buf.copy()));
        }

        @Override
        public void rootEncode(FriendlyByteBuf buf) {
            MunitionPropertiesHandler.writeBuf(buf);
        }

        @Override
        public void handle(Executor exec, PacketListener listener, @Nullable ServerPlayer sender) {
            if (this.buf != null) {
                MunitionPropertiesHandler.readBuf(this.buf);
            }
        }
    }

    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();

        protected ReloadListener() {
            super(GSON, "munition_properties");
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
            PROJECTILES.clear();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) continue;
                try {
                    ResourceLocation entityLoc = entry.getKey();
                    EntityType type = (EntityType)Registry.f_122826_.m_6612_(entityLoc).orElseThrow(() -> new JsonSyntaxException("Unknown entity type '" + entityLoc + "'"));
                    MunitionProperties properties = MunitionProperties.fromJson(element.getAsJsonObject(), entityLoc.toString());
                    PROJECTILES.put(type, properties);
                }
                catch (Exception exception) {}
            }
        }
    }
}

