/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.config.CBCCfgMunitions;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.index.CBCEntityTypes;
import rbasamoyai.createbigcannons.multiloader.IndexPlatform;
import rbasamoyai.createbigcannons.munitions.big_cannon.FuzedBigCannonProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.EndFluidStack;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlob;
import rbasamoyai.createbigcannons.munitions.big_cannon.shrapnel.Shrapnel;

public class FluidShellProjectile
extends FuzedBigCannonProjectile {
    private EndFluidStack fluidStack;

    public FluidShellProjectile(EntityType<? extends FluidShellProjectile> type, Level level) {
        super((EntityType<? extends FuzedBigCannonProjectile>)type, level);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Fluid", (Tag)this.fluidStack.writeTag(new CompoundTag()));
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.fluidStack = EndFluidStack.readTag(tag.m_128469_("Fluid"));
    }

    public void setFluidStack(EndFluidStack fstack) {
        this.fluidStack = fstack;
    }

    @Override
    protected void detonate() {
        Vec3 oldDelta = this.m_20184_();
        this.f_19853_.m_46511_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, ((CBCCfgMunitions.GriefState)((Object)CBCConfigs.SERVER.munitions.damageRestriction.get())).explosiveInteraction());
        this.m_20256_(oldDelta);
        if (!this.fluidStack.isEmpty()) {
            int mbPerBlob = (Integer)CBCConfigs.SERVER.munitions.mbPerFluidBlob.get();
            byte blobSize = (byte)((double)mbPerBlob / (double)((Integer)CBCConfigs.SERVER.munitions.mbPerAoeRadius.get()).intValue());
            int convertCount = IndexPlatform.convertFluid(mbPerBlob);
            int count = (int)Math.ceil((double)this.fluidStack.amount() / (double)convertCount);
            float spread = CBCConfigs.SERVER.munitions.fluidBlobSpread.getF();
            List<FluidBlob> list = Shrapnel.spawnShrapnelBurst(this.f_19853_, (EntityType)CBCEntityTypes.FLUID_BLOB.get(), this.m_20182_(), this.m_20184_(), count, spread, 0.0f);
            for (FluidBlob blob : list) {
                EndFluidStack copy = this.fluidStack.copy(convertCount);
                blob.setFluidStack(copy);
                blob.setBlobSize(blobSize);
            }
        }
        this.m_146870_();
    }

    @Override
    public BlockState getRenderedBlockState() {
        return (BlockState)CBCBlocks.FLUID_SHELL.getDefaultState().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH);
    }
}

