/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.EndFluidStack;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlob;

public class FluidBlobEffectRegistry {
    private static final Map<Fluid, OnHit> ON_HIT = new HashMap<Fluid, OnHit>();
    private static final Map<Fluid, OnHitBlock> ON_HIT_BLOCK = new HashMap<Fluid, OnHitBlock>();
    private static final Map<Fluid, OnHitEntity> ON_HIT_ENTITY = new HashMap<Fluid, OnHitEntity>();

    public static void registerAllHit(Fluid fluid, OnHit cons) {
        ON_HIT.put(fluid, cons);
    }

    private static OnHit getHitEffect(Fluid fluid) {
        for (Map.Entry<Fluid, OnHit> entry : ON_HIT.entrySet()) {
            if (!entry.getKey().m_6212_(fluid)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void effectOnAllHit(FluidBlob projectile, HitResult result) {
        EndFluidStack fstack = projectile.getFluidStack();
        OnHit cons = FluidBlobEffectRegistry.getHitEffect(fstack.fluid());
        if (cons != null) {
            cons.hit(fstack, projectile, projectile.m_9236_(), result);
        }
    }

    public static void registerHitBlock(Fluid fluid, OnHitBlock cons) {
        ON_HIT_BLOCK.put(fluid, cons);
    }

    private static OnHitBlock getHitBlockEffect(Fluid fluid) {
        for (Map.Entry<Fluid, OnHitBlock> entry : ON_HIT_BLOCK.entrySet()) {
            if (!entry.getKey().m_6212_(fluid)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void effectOnHitBlock(FluidBlob projectile, BlockHitResult result) {
        EndFluidStack fstack = projectile.getFluidStack();
        OnHitBlock cons = FluidBlobEffectRegistry.getHitBlockEffect(fstack.fluid());
        if (cons != null) {
            cons.hit(fstack, projectile, projectile.m_9236_(), result);
        }
    }

    public static void registerHitEntity(Fluid fluid, OnHitEntity cons) {
        ON_HIT_ENTITY.put(fluid, cons);
    }

    private static OnHitEntity getHitEntityEffect(Fluid fluid) {
        for (Map.Entry<Fluid, OnHitEntity> entry : ON_HIT_ENTITY.entrySet()) {
            if (!entry.getKey().m_6212_(fluid)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void effectOnHitEntity(FluidBlob projectile, EntityHitResult result) {
        EndFluidStack fstack = projectile.getFluidStack();
        OnHitEntity cons = FluidBlobEffectRegistry.getHitEntityEffect(fstack.fluid());
        if (cons != null) {
            cons.hit(fstack, projectile, projectile.m_9236_(), result);
        }
    }

    public static interface OnHit {
        public void hit(EndFluidStack var1, FluidBlob var2, Level var3, HitResult var4);
    }

    public static interface OnHitBlock {
        public void hit(EndFluidStack var1, FluidBlob var2, Level var3, BlockHitResult var4);
    }

    public static interface OnHitEntity {
        public void hit(EndFluidStack var1, FluidBlob var2, Level var3, EntityHitResult var4);
    }
}

