/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.manualloading;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.foundation.utility.NBTProcessors;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import rbasamoyai.createbigcannons.base.CBCTooltip;
import rbasamoyai.createbigcannons.cannon_control.contraption.MountedBigCannonContraption;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.cannon_end.BigCannonEnd;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.manualloading.HandloadingTool;
import rbasamoyai.createbigcannons.munitions.big_cannon.BigCannonMunitionBlock;

public class WormItem
extends Item
implements HandloadingTool {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public WormItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 2.5, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -3.0, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(slot);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player instanceof DeployerFakePlayer && !((Boolean)CBCConfigs.SERVER.cannons.deployersCanUseLoadingTools.get()).booleanValue()) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction reachDirection = context.m_43719_().m_122424_();
        for (int i = 0; i < (Integer)CBCConfigs.SERVER.cannons.wormReach.get(); ++i) {
            IBigCannonBlockEntity cbe1;
            BlockPos pos1 = pos.m_5484_(reachDirection, i);
            BlockState state1 = level.m_8055_(pos1);
            BlockEntity be = level.m_7702_(pos1);
            if (!WormItem.isValidLoadBlock(state1, level, pos1, reachDirection) || !(be instanceof IBigCannonBlockEntity)) {
                return InteractionResult.FAIL;
            }
            IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)be;
            StructureTemplate.StructureBlockInfo info = ((BigCannonBehavior)((Object)cbe.cannonBehavior())).block();
            if (info.f_74676_.m_60795_()) continue;
            BlockPos pos2 = pos1.m_121945_(context.m_43719_());
            BlockEntity be1 = level.m_7702_(pos2);
            if (be1 instanceof IBigCannonBlockEntity && (cbe1 = (IBigCannonBlockEntity)be1).canLoadBlock(info)) {
                if (!level.f_46443_) {
                    ((BigCannonBehavior)((Object)cbe1.cannonBehavior())).loadBlock(info);
                    be1.m_6596_();
                }
            } else if (level.m_8055_(pos2).m_60795_()) {
                if (!level.f_46443_) {
                    level.m_7731_(pos2, info.f_74676_, 67);
                    BlockEntity be2 = level.m_7702_(pos2);
                    CompoundTag tag = info.f_74677_;
                    if (be2 != null) {
                        tag = NBTProcessors.process((BlockEntity)be2, (CompoundTag)tag, (boolean)false);
                    }
                    if (be2 != null && tag != null) {
                        tag.m_128405_("x", pos2.m_123341_());
                        tag.m_128405_("y", pos2.m_123342_());
                        tag.m_128405_("z", pos2.m_123343_());
                        be2.m_142466_(tag);
                    }
                }
            } else {
                return InteractionResult.FAIL;
            }
            if (!level.f_46443_) {
                ((BigCannonBehavior)((Object)cbe.cannonBehavior())).removeBlock();
                be.m_6596_();
            }
            level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_36399_(CBCConfigs.SERVER.cannons.loadingToolHungerConsumption.getF());
            player.m_36335_().m_41524_((Item)this, ((Integer)CBCConfigs.SERVER.cannons.loadingToolCooldown.get()).intValue());
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6225_(context);
    }

    @Override
    public void onUseOnCannon(Player player, Level level, BlockPos startPos, Direction face, MountedBigCannonContraption contraption) {
        if (player instanceof DeployerFakePlayer && !((Boolean)CBCConfigs.SERVER.cannons.deployersCanUseLoadingTools.get()).booleanValue()) {
            return;
        }
        Direction reachDirection = face.m_122424_();
        HashSet<BlockPos> changes = new HashSet<BlockPos>(2);
        for (int i = 0; i < (Integer)CBCConfigs.SERVER.cannons.wormReach.get(); ++i) {
            IBigCannonBlockEntity cbe1;
            BlockPos pos1 = startPos.m_5484_(reachDirection, i);
            StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos1);
            if (info == null || !WormItem.isValidLoadBlock(info.f_74676_, contraption, pos1, reachDirection)) {
                return;
            }
            BlockEntity be = (BlockEntity)contraption.presentBlockEntities.get(pos1);
            if (!(be instanceof IBigCannonBlockEntity)) {
                return;
            }
            IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)be;
            StructureTemplate.StructureBlockInfo info1 = ((BigCannonBehavior)((Object)cbe.cannonBehavior())).block();
            if (info1.f_74676_.m_60795_()) continue;
            BlockPos pos2 = pos1.m_121945_(face);
            BlockEntity be1 = (BlockEntity)contraption.presentBlockEntities.get(pos2);
            if (be1 instanceof IBigCannonBlockEntity && ((BigCannonBehavior)((Object)(cbe1 = (IBigCannonBlockEntity)be1).cannonBehavior())).canLoadBlock(info1)) {
                if (!level.f_46443_) {
                    ((BigCannonBehavior)((Object)cbe1.cannonBehavior())).loadBlock(info1);
                    changes.add(pos2);
                }
            } else if (i == 0) {
                if (!level.f_46443_) {
                    ItemEntity item;
                    ItemStack stack;
                    Block block = info1.f_74676_.m_60734_();
                    if (block instanceof BigCannonMunitionBlock) {
                        BigCannonMunitionBlock munition = (BigCannonMunitionBlock)block;
                        v0 = munition.getExtractedItem(info1);
                    } else {
                        v0 = stack = ItemStack.f_41583_;
                    }
                    if (!player.m_36356_(stack) && !player.m_7500_() && (item = player.m_36176_(stack, false)) != null) {
                        item.m_32061_();
                        item.m_32047_(player.m_20148_());
                    }
                }
            } else {
                return;
            }
            if (!level.f_46443_) {
                ((BigCannonBehavior)((Object)cbe.cannonBehavior())).removeBlock();
                changes.add(pos1);
                BigCannonBlock.writeAndSyncMultipleBlockData(changes, contraption.entity, contraption);
            }
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12639_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_36399_(CBCConfigs.SERVER.cannons.loadingToolHungerConsumption.getF());
            player.m_36335_().m_41524_((Item)this, ((Integer)CBCConfigs.SERVER.cannons.loadingToolCooldown.get()).intValue());
            return;
        }
    }

    public static boolean isValidLoadBlock(BlockState state, Level level, BlockPos pos, Direction dir) {
        BigCannonBlock cBlock;
        Block block = state.m_60734_();
        return block instanceof BigCannonBlock && (cBlock = (BigCannonBlock)block).getOpeningType(level, state, pos) == BigCannonEnd.OPEN && cBlock.getFacing(state).m_122434_() == dir.m_122434_();
    }

    public static boolean isValidLoadBlock(BlockState state, MountedBigCannonContraption contraption, BlockPos pos, Direction dir) {
        Block block = state.m_60734_();
        if (block instanceof BigCannonMunitionBlock) {
            BigCannonMunitionBlock munition = (BigCannonMunitionBlock)block;
            return munition.canBeLoaded(state, dir.m_122434_());
        }
        block = state.m_60734_();
        if (block instanceof BigCannonBlock) {
            BigCannonBlock cBlock = (BigCannonBlock)block;
            return cBlock.getOpeningType(contraption, state, pos) == BigCannonEnd.OPEN && cBlock.getFacing(state).m_122434_() == dir.m_122434_();
        }
        return false;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CBCTooltip.appendWormText(stack, level, tooltip, flag);
    }

    public static int getReach() {
        return (Integer)CBCConfigs.SERVER.cannons.ramRodReach.get();
    }

    public static boolean deployersCanUse() {
        return (Boolean)CBCConfigs.SERVER.cannons.deployersCanUseLoadingTools.get();
    }
}

