/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.forge.crafting;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import rbasamoyai.createbigcannons.crafting.casting.AbstractCannonCastBlockEntity;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastingRecipe;
import rbasamoyai.createbigcannons.index.CBCBlocks;

public class CannonCastBlockEntity
extends AbstractCannonCastBlockEntity {
    protected FluidTank fluid;
    protected LazyOptional<IFluidHandler> fluidOptional = null;
    protected FluidStack leakage = FluidStack.EMPTY;

    public CannonCastBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluid = new SmartFluidTank(1, this::onFluidStackChanged);
        this.fluidOptional = LazyOptional.of(() -> this.fluid);
        this.refreshCap();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && side == Direction.UP) {
            if (this.fluidOptional == null) {
                this.fluidOptional = LazyOptional.of(this::createHandlerForCap);
            }
            return this.fluidOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.fluidOptional != null) {
            this.fluidOptional.invalidate();
        }
    }

    @Override
    public void refreshCap() {
        if (this.fluidOptional == null) {
            this.fluidOptional = LazyOptional.of(this::createHandlerForCap);
        } else {
            LazyOptional<IFluidHandler> oldOp = this.fluidOptional;
            this.fluidOptional = LazyOptional.of(this::createHandlerForCap);
            oldOp.invalidate();
        }
    }

    private IFluidHandler createHandlerForCap() {
        return this.isController() ? this.fluid : (this.getController() == null ? this.fluid : ((CannonCastBlockEntity)this.getControllerBE()).createHandlerForCap());
    }

    @Override
    protected void updateFluids(CompoundTag tag) {
        this.fluid.setCapacity(this.calculateCapacityFromStructure());
        this.fluid.readFromNBT(tag.m_128469_("FluidContent"));
        this.leakage = tag.m_128441_("Leakage") ? FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("Leakage")) : FluidStack.EMPTY;
    }

    @Override
    protected void updateFluidClient() {
        this.fluid.setCapacity(this.calculateCapacityFromStructure());
    }

    @Override
    protected void writeFluidToTag(CompoundTag tag) {
        tag.m_128365_("FluidContent", (Tag)this.fluid.writeToNBT(new CompoundTag()));
        if (!this.leakage.isEmpty()) {
            tag.m_128365_("Leakage", (Tag)this.leakage.writeToNBT(new CompoundTag()));
        }
    }

    protected void onFluidStackChanged(FluidStack stack) {
        if (!this.m_58898_()) {
            return;
        }
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < 3; ++xOffset) {
                for (int zOffset = 0; zOffset < 3; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    AbstractCannonCastBlockEntity castAt = (AbstractCannonCastBlockEntity)ConnectivityHandler.partAt((BlockEntityType)this.m_58903_(), (BlockGetter)this.f_58857_, (BlockPos)pos);
                    if (castAt == null) continue;
                    this.f_58857_.m_46717_(pos, castAt.m_58900_().m_60734_());
                }
            }
        }
        if (!this.f_58857_.f_46443_) {
            this.notifyUpdate();
        }
        if (this.isVirtual()) {
            if (this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
            }
            this.fluidLevel.chase((double)this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    @Override
    protected void leakContents() {
        FluidStack fstack = this.fluid.drain(20, IFluidHandler.FluidAction.EXECUTE);
        if (!fstack.isEmpty()) {
            if (this.leakage.isEmpty()) {
                this.leakage = fstack;
            } else {
                this.leakage.setAmount(this.leakage.getAmount() + fstack.getAmount());
            }
        }
        if (this.leakage.getAmount() >= 1250) {
            Fluid leakFluid = this.leakage.getFluid();
            this.f_58857_.m_7731_(this.f_58858_.m_7495_(), leakFluid.m_76145_().m_76188_(), 11);
            this.leakage.setAmount(this.leakage.getAmount() - 1000);
        }
    }

    @Override
    protected boolean canStartCasting() {
        return this.fluid.getFluidAmount() >= this.fluid.getCapacity() && !this.fluid.isEmpty();
    }

    @Override
    protected void addStructureCapacityToController(AbstractCannonCastBlockEntity controller) {
        if (controller instanceof CannonCastBlockEntity) {
            CannonCastBlockEntity cController = (CannonCastBlockEntity)controller;
            cController.fluid.setCapacity(cController.fluid.getCapacity() + this.castShape.fluidSize());
        }
    }

    @Override
    protected void reInitTank() {
        this.fluid = new SmartFluidTank(this.castShape.fluidSize(), this::onFluidStackChanged);
    }

    @Override
    protected void mergeControllerAndOtherFluids(AbstractCannonCastBlockEntity controller, AbstractCannonCastBlockEntity otherCast) {
        if (controller instanceof CannonCastBlockEntity) {
            CannonCastBlockEntity cController = (CannonCastBlockEntity)controller;
            if (otherCast instanceof CannonCastBlockEntity) {
                CannonCastBlockEntity cOther = (CannonCastBlockEntity)otherCast;
                cController.fluid.setCapacity(cController.fluid.getCapacity() + this.castShape.fluidSize());
                cController.fluid.fill(cOther.fluid.drain(cOther.fluid.getCapacity(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                cOther.fluid = new FluidTank(1);
            }
        }
    }

    @Override
    protected void onDestroyCenterCast() {
        CannonCastBlockEntity controller = (CannonCastBlockEntity)this.getControllerBE();
        if (controller == null) {
            return;
        }
        int thisIndex = this.f_58858_.m_123342_() - controller.f_58858_.m_123342_();
        --controller.height;
        int capacityUpTo = controller.structure.subList(0, Mth.m_14045_((int)thisIndex, (int)0, (int)controller.structure.size())).stream().map(CannonCastShape::fluidSize).reduce(Integer::sum).orElse(0);
        int leakAmount = Mth.m_14045_((int)(controller.fluid.getFluidAmount() - capacityUpTo), (int)0, (int)this.castShape.fluidSize());
        FluidStack addLeak = controller.fluid.drain(leakAmount, IFluidHandler.FluidAction.EXECUTE);
        controller.fluid.setCapacity(Math.max(1, controller.fluid.getCapacity() - this.castShape.fluidSize()));
        FluidStack remaining = controller.fluid.getFluid();
        if (controller == this && this.height > 0) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
            if (blockEntity instanceof CannonCastBlockEntity) {
                CannonCastBlockEntity otherCast = (CannonCastBlockEntity)blockEntity;
                otherCast.controllerPos = null;
                otherCast.height = this.height;
                otherCast.structure = CannonCastBlockEntity.getStructureFromPoint(this.f_58857_, this.f_58858_.m_7494_(), this.height);
                otherCast.fluid = new SmartFluidTank(otherCast.calculateCapacityFromStructure(), otherCast::onFluidStackChanged);
                otherCast.fluid.fill(remaining, IFluidHandler.FluidAction.EXECUTE);
                otherCast.updatePotentialCastsAbove();
                otherCast.notifyUpdate();
            }
        } else {
            int oldHeight = controller.height;
            controller.height = thisIndex;
            controller.structure = controller.structure.subList(0, Mth.m_14045_((int)thisIndex, (int)0, (int)controller.structure.size()));
            controller.fluid = new SmartFluidTank(controller.calculateCapacityFromStructure(), controller::onFluidStackChanged);
            int firstRemaining = remaining.getAmount() - controller.fluid.fill(remaining, IFluidHandler.FluidAction.EXECUTE);
            if (!remaining.isEmpty()) {
                remaining.setAmount(firstRemaining);
            }
            controller.updateRecipes = true;
            controller.notifyUpdate();
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
            if (blockEntity instanceof CannonCastBlockEntity) {
                CannonCastBlockEntity otherCast = (CannonCastBlockEntity)blockEntity;
                otherCast.controllerPos = null;
                otherCast.height = oldHeight - controller.height;
                otherCast.structure = CannonCastBlockEntity.getStructureFromPoint(this.f_58857_, this.f_58858_.m_7494_(), otherCast.height);
                otherCast.fluid = new SmartFluidTank(otherCast.calculateCapacityFromStructure(), otherCast::onFluidStackChanged);
                otherCast.fluid.fill(remaining, IFluidHandler.FluidAction.EXECUTE);
                otherCast.updatePotentialCastsAbove();
                otherCast.updateRecipes = true;
                otherCast.notifyUpdate();
            }
        }
        if (this.castShape.isLarge()) {
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.f_58858_.m_7918_(-1, 0, -1), (BlockPos)this.f_58858_.m_7918_(1, 0, 1))) {
                if (!CBCBlocks.CANNON_CAST.has(this.f_58857_.m_8055_(pos))) continue;
                this.f_58857_.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            }
        }
        if (!addLeak.isEmpty() && addLeak.getAmount() >= 1000) {
            this.f_58857_.m_7731_(this.f_58858_, addLeak.getFluid().m_76145_().m_76188_(), 11);
        }
    }

    @Override
    public float getFillState() {
        return this.fluid.getCapacity() == 0 ? 0.0f : (float)this.fluid.getFluidAmount() / (float)this.fluid.getCapacity();
    }

    @Override
    protected boolean testWithFluid(CannonCastingRecipe recipe) {
        CannonCastBlockEntity cController = (CannonCastBlockEntity)this.getControllerBE();
        if (cController == null || cController.fluid.getFluid().isEmpty()) {
            return false;
        }
        return recipe.ingredient().test(cController.fluid.getFluid());
    }

    @Override
    public boolean tryEmptyItemIntoBE(Level worldIn, Player player, InteractionHand handIn, ItemStack heldItem, Direction side) {
        if (!GenericItemEmptying.canItemBeEmptied((Level)worldIn, (ItemStack)heldItem)) {
            return false;
        }
        if (worldIn.f_46443_) {
            return true;
        }
        Pair emptyingResult = GenericItemEmptying.emptyItem((Level)worldIn, (ItemStack)heldItem, (boolean)true);
        FluidStack fluidStack = (FluidStack)emptyingResult.getFirst();
        if (fluidStack.getAmount() != this.fluid.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE)) {
            return false;
        }
        ItemStack copyOfHeld = heldItem.m_41777_();
        emptyingResult = GenericItemEmptying.emptyItem((Level)worldIn, (ItemStack)copyOfHeld, (boolean)false);
        this.fluid.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        if (!player.m_7500_()) {
            if (copyOfHeld.m_41619_()) {
                player.m_21008_(handIn, (ItemStack)emptyingResult.getSecond());
            } else {
                player.m_21008_(handIn, copyOfHeld);
                player.m_150109_().m_150079_((ItemStack)emptyingResult.getSecond());
            }
        }
        return true;
    }

    @Override
    public boolean tryFillItemFromBE(Level level, Player player, InteractionHand handIn, ItemStack heldItem, Direction side) {
        if (!GenericItemFilling.canItemBeFilled((Level)level, (ItemStack)heldItem)) {
            return false;
        }
        if (level.f_46443_) {
            return true;
        }
        FluidStack fluid = this.fluid.getFluid();
        if (fluid.isEmpty()) {
            return false;
        }
        int requiredAmountForItem = GenericItemFilling.getRequiredAmountForItem((Level)level, (ItemStack)heldItem, (FluidStack)fluid.copy());
        if (requiredAmountForItem == -1 || requiredAmountForItem > fluid.getAmount()) {
            return false;
        }
        if (player.m_7500_()) {
            heldItem = heldItem.m_41777_();
        }
        ItemStack out = GenericItemFilling.fillItem((Level)level, (int)requiredAmountForItem, (ItemStack)heldItem, (FluidStack)fluid.copy());
        FluidStack copy = fluid.copy();
        copy.setAmount(requiredAmountForItem);
        this.fluid.drain(copy, IFluidHandler.FluidAction.EXECUTE);
        if (!player.m_7500_()) {
            player.m_150109_().m_150079_(out);
        }
        this.notifyUpdate();
        return true;
    }
}

