/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.datagen.values;

import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public abstract class CBCDataProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final String modid;
    protected final String folder;
    private final DataGenerator gen;

    protected CBCDataProvider(String modid, DataGenerator gen, String folder) {
        this.modid = modid;
        this.gen = gen;
        this.folder = folder;
    }

    public final void m_213708_(CachedOutput cache) throws IOException {
        LinkedHashMap dataToWrite = new LinkedHashMap();
        this.generateData(dataToWrite::put);
        for (Map.Entry entry : dataToWrite.entrySet()) {
            ResourceLocation loc = (ResourceLocation)entry.getKey();
            Path path = this.gen.m_123916_().resolve("data/" + loc.m_135827_() + "/" + this.folder + "/" + loc.m_135815_() + ".json");
            String s = GSON.toJson((JsonElement)entry.getValue());
            if (!Files.exists(path.toAbsolutePath(), new LinkOption[0])) {
                Files.createFile(path.toAbsolutePath(), new FileAttribute[0]);
            }
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(s);
            }
            cache.m_213871_(path, s.getBytes(StandardCharsets.UTF_8), Hashing.sha1().hashBytes(s.getBytes(StandardCharsets.UTF_8)));
        }
    }

    protected abstract void generateData(BiConsumer<ResourceLocation, JsonObject> var1);
}

