/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.builtup;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionCollider;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuildingContraption;
import rbasamoyai.createbigcannons.crafting.builtup.LayeredBigCannonBlockEntity;
import rbasamoyai.createbigcannons.index.CBCBlocks;

public class CannonBuilderCollider {
    public static boolean collideBlocks(AbstractContraptionEntity contraptionEntity) {
        Contraption contraption = contraptionEntity.getContraption();
        if (!(contraption instanceof CannonBuildingContraption)) {
            return ContraptionCollider.collideBlocks((AbstractContraptionEntity)contraptionEntity);
        }
        CannonBuildingContraption contraption2 = (CannonBuildingContraption)contraption;
        Level level = contraptionEntity.m_20193_();
        Vec3 motion = contraptionEntity.m_20184_();
        AABB bounds = contraptionEntity.m_20191_();
        Vec3 position = contraptionEntity.m_20182_();
        BlockPos gridPos = new BlockPos(position);
        if (contraption2 == null) {
            return false;
        }
        if (bounds == null) {
            return false;
        }
        if (motion.equals((Object)Vec3.f_82478_)) {
            return false;
        }
        Direction movementDirection = Direction.m_122366_((double)motion.f_82479_, (double)motion.f_82480_, (double)motion.f_82481_);
        if (movementDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            gridPos = gridPos.m_121945_(movementDirection);
        }
        if (CannonBuilderCollider.isCollidingWithWorld(level, contraption2, gridPos, movementDirection)) {
            return true;
        }
        for (ControlledContraptionEntity otherContraptionEntity : level.m_6443_(ControlledContraptionEntity.class, bounds.m_82400_(1.0), e -> !e.equals((Object)contraptionEntity))) {
            if (!otherContraptionEntity.supportsTerrainCollision()) continue;
            Vec3 otherMotion = otherContraptionEntity.m_20184_();
            TranslatingContraption otherContraption = (TranslatingContraption)otherContraptionEntity.getContraption();
            AABB otherBounds = otherContraptionEntity.m_20191_();
            Vec3 otherPosition = otherContraptionEntity.m_20182_();
            if (otherContraption == null) {
                return false;
            }
            if (otherBounds == null) {
                return false;
            }
            if (!bounds.m_82383_(motion).m_82381_(otherBounds.m_82383_(otherMotion))) continue;
            for (BlockPos colliderPos : contraption2.getOrCreateColliders(level, movementDirection)) {
                colliderPos = colliderPos.m_121955_((Vec3i)gridPos).m_121996_((Vec3i)new BlockPos(otherPosition));
                if (!otherContraption.getBlocks().containsKey(colliderPos)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCollidingWithWorld(Level level, CannonBuildingContraption contraption, BlockPos anchor, Direction movementDirection) {
        for (BlockPos pos : contraption.getOrCreateColliders(level, movementDirection)) {
            BlockPos colliderPos = pos.m_121955_((Vec3i)anchor);
            if (!level.m_46749_(colliderPos)) {
                return true;
            }
            BlockState collidedState = level.m_8055_(colliderPos);
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos);
            boolean emptyCollider = collidedState.m_60812_((BlockGetter)level, pos).m_83281_();
            BlockEntity be = level.m_7702_(colliderPos);
            if (contraption.isActivated && be instanceof LayeredBigCannonBlockEntity) {
                LayeredBigCannonBlockEntity layered = (LayeredBigCannonBlockEntity)be;
                if (CBCBlocks.CANNON_BUILDER_HEAD.has(blockInfo.f_74676_)) {
                    if (contraption.entity == null && contraption.getBlocks().keySet().contains(colliderPos.m_121996_((Vec3i)contraption.anchor))) continue;
                    return true;
                }
                BlockEntity be1 = (BlockEntity)contraption.presentBlockEntities.get(pos);
                if (be1 instanceof LayeredBigCannonBlockEntity) {
                    LayeredBigCannonBlockEntity layered1 = (LayeredBigCannonBlockEntity)be1;
                    if (contraption.entity == null && contraption.getBlocks().keySet().contains(pos) || !layered.isCollidingWith(blockInfo, layered1, movementDirection)) continue;
                    return true;
                }
            }
            if (collidedState.m_60767_().m_76336_() || emptyCollider || contraption.isActivated && contraption.entity == null && contraption.getBlocks().keySet().contains(pos)) continue;
            return true;
        }
        return false;
    }
}

