/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.big_cannons.breeches;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.RootPacket;

public class BigCannonBreechStrengthHandler {
    private static final Map<Block, Integer> BREECH_STRENGTHS = new HashMap<Block, Integer>();

    public static int getStrength(Block block, int defaultStrength) {
        return BREECH_STRENGTHS.getOrDefault(block, defaultStrength);
    }

    public static void writeBuf(FriendlyByteBuf buf) {
        buf.m_130130_(BREECH_STRENGTHS.size());
        for (Map.Entry<Block, Integer> entry : BREECH_STRENGTHS.entrySet()) {
            buf.m_130070_(Registry.f_122824_.m_7981_((Object)entry.getKey()).toString()).m_130130_(entry.getValue().intValue());
        }
    }

    public static void readBuf(FriendlyByteBuf buf) {
        BREECH_STRENGTHS.clear();
        int sz = buf.m_130242_();
        for (int i = 0; i < sz; ++i) {
            BREECH_STRENGTHS.put((Block)Registry.f_122824_.m_7745_(new ResourceLocation(buf.m_130277_())), buf.m_130242_());
        }
    }

    public static void syncTo(ServerPlayer player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundBigCannonBreechStrengthPacket(), player);
    }

    public record ClientboundBigCannonBreechStrengthPacket(@Nullable FriendlyByteBuf buf) implements RootPacket
    {
        public ClientboundBigCannonBreechStrengthPacket() {
            this(null);
        }

        public static ClientboundBigCannonBreechStrengthPacket copyOf(FriendlyByteBuf buf) {
            return new ClientboundBigCannonBreechStrengthPacket(new FriendlyByteBuf(buf.copy()));
        }

        @Override
        public void rootEncode(FriendlyByteBuf buf) {
            BigCannonBreechStrengthHandler.writeBuf(buf);
        }

        @Override
        public void handle(Executor exec, PacketListener listener, @Nullable ServerPlayer sender) {
            if (this.buf != null) {
                BigCannonBreechStrengthHandler.readBuf(this.buf);
            }
        }
    }

    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();

        ReloadListener() {
            super(GSON, "big_cannon_breech_strength");
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
            BREECH_STRENGTHS.clear();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                try {
                    Block block = (Block)Registry.f_122824_.m_6612_(entry.getKey()).orElseThrow(() -> new JsonSyntaxException("Could not find big cannon breech block '" + entry.getKey() + "'"));
                    int strength = Math.max(0, GsonHelper.m_13927_((JsonObject)el.getAsJsonObject(), (String)"breech_strength"));
                    BREECH_STRENGTHS.put(block, strength);
                }
                catch (Exception exception) {}
            }
        }
    }
}

