/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.autocannon.material;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;

public record AutocannonMaterialProperties(int maxBarrelLength, float weight, float baseSpread, float spreadReductionPerBarrel, float baseSpeed, float speedIncreasePerBarrel, int maxSpeedIncreases, int projectileLifetime, float baseRecoil) {
    public static AutocannonMaterialProperties fromJson(JsonObject obj) {
        int maxBarrelLength = Math.max(1, GsonHelper.m_13927_((JsonObject)obj, (String)"maximum_barrel_length"));
        float weight = Math.max(0.0f, GsonHelper.m_13820_((JsonObject)obj, (String)"weight", (float)2.0f));
        float baseSpread = Math.max(0.01f, GsonHelper.m_13820_((JsonObject)obj, (String)"base_spread", (float)3.0f));
        float spreadReductionPerBarrel = Math.max(0.0f, GsonHelper.m_13820_((JsonObject)obj, (String)"spread_reduction_per_barrel", (float)0.5f));
        float baseSpeed = Math.max(0.1f, GsonHelper.m_13820_((JsonObject)obj, (String)"base_speed", (float)1.0f));
        float speedIncreasePerBarrel = Math.max(0.0f, GsonHelper.m_13820_((JsonObject)obj, (String)"speed_increase_per_barrel", (float)0.5f));
        int maxSpeedIncreases = Math.max(0, GsonHelper.m_13824_((JsonObject)obj, (String)"max_speed_increases", (int)2));
        int projectileLifetime = Math.max(1, GsonHelper.m_13927_((JsonObject)obj, (String)"projectile_lifetime"));
        float baseRecoil = Math.max(0.0f, GsonHelper.m_13820_((JsonObject)obj, (String)"base_recoil", (float)1.0f));
        return new AutocannonMaterialProperties(maxBarrelLength, weight, baseSpread, spreadReductionPerBarrel, baseSpeed, speedIncreasePerBarrel, maxSpeedIncreases, projectileLifetime, baseRecoil);
    }

    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("maximum_barrel_length", (Number)this.maxBarrelLength);
        obj.addProperty("weight", (Number)Float.valueOf(this.weight));
        obj.addProperty("base_spread", (Number)Float.valueOf(this.baseSpread));
        obj.addProperty("spread_reduction_per_barrel", (Number)Float.valueOf(this.spreadReductionPerBarrel));
        obj.addProperty("base_speed", (Number)Float.valueOf(this.baseSpeed));
        obj.addProperty("speed_increase_per_barrel", (Number)Float.valueOf(this.speedIncreasePerBarrel));
        obj.addProperty("max_speed_increases", (Number)this.maxSpeedIncreases);
        obj.addProperty("projectile_lifetime", (Number)this.projectileLifetime);
        obj.addProperty("base_recoil", (Number)Float.valueOf(this.baseRecoil));
        return obj;
    }

    public void writeBuf(FriendlyByteBuf buf) {
        buf.m_130130_(this.maxBarrelLength);
        buf.writeFloat(this.weight).writeFloat(this.baseSpread).writeFloat(this.spreadReductionPerBarrel).writeFloat(this.baseSpeed).writeFloat(this.speedIncreasePerBarrel);
        buf.m_130130_(this.maxSpeedIncreases).m_130130_(this.projectileLifetime).writeFloat(this.baseRecoil);
    }

    public static AutocannonMaterialProperties fromBuf(FriendlyByteBuf buf) {
        int maxBarrelLength = buf.m_130242_();
        float weight = buf.readFloat();
        float baseSpread = buf.readFloat();
        float spreadReductionPerBarrel = buf.readFloat();
        float baseSpeed = buf.readFloat();
        float speedIncreasePerBarrel = buf.readFloat();
        int maxSpeedIncreases = buf.m_130242_();
        int projectileLifetime = buf.m_130242_();
        float baseRecoil = buf.readFloat();
        return new AutocannonMaterialProperties(maxBarrelLength, weight, baseSpread, spreadReductionPerBarrel, baseSpeed, speedIncreasePerBarrel, maxSpeedIncreases, projectileLifetime, baseRecoil);
    }
}

