/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.autocannon.breech;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.breech.AbstractAutocannonBreechBlockEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.breech.AutocannonBreechBlock;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;
import rbasamoyai.createbigcannons.munitions.autocannon.ammo_container.AutocannonAmmoContainerItem;

public class AutocannonBreechInstance
extends BlockEntityInstance<AbstractAutocannonBreechBlockEntity>
implements DynamicInstance {
    private OrientedData ejector;
    private OrientedData seat;
    private OrientedData ammoContainer;
    private Direction facing;
    private boolean isFilled = false;

    public AutocannonBreechInstance(MaterialManager manager, AbstractAutocannonBreechBlockEntity blockEntity) {
        super(manager, (BlockEntity)blockEntity);
    }

    public void init() {
        Quaternion q1;
        super.init();
        this.facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        Quaternion q = Vector3f.f_122225_.m_122240_(this.facing.m_122434_().m_122478_() ? 180.0f : 0.0f);
        this.ejector = (OrientedData)this.materialManager.defaultCutout().material(Materials.ORIENTED).getModel(this.getPartialModelForState(), this.blockState, this.facing).createInstance();
        this.ejector.setRotation(q);
        this.seat = (OrientedData)this.materialManager.defaultCutout().material(Materials.ORIENTED).getModel(CBCBlockPartials.autocannonSeatFor(((AbstractAutocannonBreechBlockEntity)this.blockEntity).getSeatColor()), this.blockState, this.facing).createInstance();
        this.seat.setRotation(q).setPosition(this.getInstancePosition());
        this.ammoContainer = (OrientedData)this.materialManager.defaultCutout().material(Materials.ORIENTED).getModel(this.getAmmoContainerModel(), this.blockState, this.facing).createInstance();
        boolean flag = this.facing.m_122434_().m_122478_();
        if (flag) {
            q1 = Vector3f.f_122227_.m_122240_(180.0f);
            q1.m_80148_(Vector3f.f_122225_.m_122240_(180.0f));
        } else {
            q1 = Vector3f.f_122225_.m_122240_(180.0f);
        }
        Direction offset = flag ? this.facing.m_175364_(Direction.Axis.Z) : this.facing.m_175362_(Direction.Axis.Y);
        Vector3f normal = this.facing == Direction.UP ? offset.m_122424_().m_122432_() : offset.m_122432_();
        normal.m_122261_(0.625f);
        this.ammoContainer.setRotation(q1).setPosition(this.getInstancePosition()).nudge(normal.m_122239_(), normal.m_122260_(), normal.m_122269_());
        this.isFilled = this.isFilled();
        this.updateTransforms();
    }

    public void beginFrame() {
        this.updateTransforms();
    }

    private void updateTransforms() {
        if (((Boolean)this.blockState.m_61143_((Property)AutocannonBreechBlock.HANDLE)).booleanValue()) {
            this.ejector.setColor((byte)-1, (byte)-1, (byte)-1, (byte)0);
            this.seat.setColor((byte)-1, (byte)-1, (byte)-1, (byte)(((AbstractAutocannonBreechBlockEntity)this.blockEntity).getSeatColor() == null ? 0 : 255));
        } else {
            this.seat.setColor((byte)-1, (byte)-1, (byte)-1, (byte)0);
            float offset = ((AbstractAutocannonBreechBlockEntity)this.blockEntity).getAnimateOffset(AnimationTickHolder.getPartialTicks()) * 0.5f;
            Vector3f normal = this.facing.m_122424_().m_122432_();
            normal.m_122261_(offset);
            this.ejector.setPosition(this.getInstancePosition()).nudge(normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).setColor((byte)-1, (byte)-1, (byte)-1, (byte)-1);
        }
        ItemStack container = ((AbstractAutocannonBreechBlockEntity)this.blockEntity).getMagazine();
        this.ammoContainer.setColor((byte)-1, (byte)-1, (byte)-1, (byte)(container.m_41720_() instanceof AutocannonAmmoContainerItem ? 255 : 0));
        if (this.isFilled != this.isFilled()) {
            this.remove();
            this.init();
            this.updateLight();
        }
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.ejector});
        this.relight(this.pos, new FlatLit[]{this.seat});
        this.relight(this.pos, new FlatLit[]{this.ammoContainer});
    }

    protected void remove() {
        this.ejector.delete();
        this.seat.delete();
        this.ammoContainer.delete();
    }

    private PartialModel getPartialModelForState() {
        PartialModel partialModel;
        Block block = this.blockState.m_60734_();
        if (block instanceof AutocannonBlock) {
            AutocannonBlock cBlock = (AutocannonBlock)block;
            partialModel = CBCBlockPartials.autocannonEjectorFor(cBlock.getAutocannonMaterial());
        } else {
            partialModel = CBCBlockPartials.CAST_IRON_AUTOCANNON_EJECTOR;
        }
        return partialModel;
    }

    private PartialModel getAmmoContainerModel() {
        ItemStack container = ((AbstractAutocannonBreechBlockEntity)this.blockEntity).getMagazine();
        return container.m_41720_() instanceof AutocannonAmmoContainerItem && AutocannonAmmoContainerItem.getTotalAmmoCount(container) > 0 ? CBCBlockPartials.AUTOCANNON_AMMO_CONTAINER_FILLED : CBCBlockPartials.AUTOCANNON_AMMO_CONTAINER_EMPTY;
    }

    private boolean isFilled() {
        return AutocannonAmmoContainerItem.getTotalAmmoCount(((AbstractAutocannonBreechBlockEntity)this.blockEntity).getMagazine()) > 0;
    }
}

