/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class CannonBehavior
extends BlockEntityBehaviour {
    protected final Set<Direction> connectedTowards = EnumSet.noneOf(Direction.class);
    protected Direction currentFacing;

    protected CannonBehavior(SmartBlockEntity te) {
        super(te);
    }

    public void tick() {
        super.tick();
        BlockState state = this.blockEntity.m_58900_();
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            Direction previousFacing = this.currentFacing;
            this.currentFacing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            if (previousFacing != null && previousFacing != this.currentFacing) {
                Direction.Axis rotationAxis = CannonBehavior.getRotationAxis(previousFacing, this.currentFacing);
                Rotation rotation = CannonBehavior.getRotationBetween(previousFacing, this.currentFacing, rotationAxis);
                this.onRotate(rotationAxis, rotation);
            }
        }
    }

    protected void onRotate(Direction.Axis rotationAxis, Rotation rotation) {
        EnumSet<Direction> copyFrom = EnumSet.noneOf(Direction.class);
        this.connectedTowards.forEach(d -> {
            Direction dc = d;
            for (int i = 0; i < rotation.ordinal(); ++i) {
                dc = dc.m_175362_(rotationAxis);
            }
            copyFrom.add(dc);
        });
        this.connectedTowards.clear();
        this.connectedTowards.addAll(copyFrom);
        this.blockEntity.m_6596_();
    }

    public boolean isConnectedTo(Direction face) {
        return this.connectedTowards.contains(face);
    }

    public void setConnectedFace(Direction face, boolean isConnected) {
        if (isConnected) {
            if (this.connectedTowards.add(face)) {
                this.blockEntity.m_6596_();
            }
        } else if (this.connectedTowards.remove(face)) {
            this.blockEntity.m_6596_();
        }
    }

    protected static Direction.Axis getRotationAxis(Direction prev, Direction current) {
        EnumSet<Direction.Axis> axes = EnumSet.allOf(Direction.Axis.class);
        axes.remove(prev.m_122434_());
        axes.remove(current.m_122434_());
        return (Direction.Axis)axes.stream().findFirst().orElseThrow(() -> new IllegalStateException("Failed to find the rotation axes of two different axes"));
    }

    protected static Rotation getRotationBetween(Direction prev, Direction current, Direction.Axis axis) {
        if (prev == current) {
            return Rotation.NONE;
        }
        if (prev == current.m_122424_()) {
            return Rotation.CLOCKWISE_180;
        }
        return prev.m_175362_(axis) == current ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
    }

    public boolean isSafeNBT() {
        return true;
    }

    public void write(CompoundTag nbt, boolean spawnPacket) {
        if (this.currentFacing != null) {
            nbt.m_128359_("Facing", this.currentFacing.m_7912_());
        }
        ListTag connectionTag = new ListTag();
        this.connectedTowards.stream().map(Direction::m_7912_).map(StringTag::m_129297_).forEach(arg_0 -> connectionTag.add(arg_0));
        nbt.m_128365_("Connections", (Tag)connectionTag);
        super.write(nbt, spawnPacket);
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        this.currentFacing = nbt.m_128441_("Facing") ? Direction.m_122402_((String)nbt.m_128461_("Facing")) : null;
        this.connectedTowards.clear();
        ListTag connectionTag = nbt.m_128437_("Connections", 8);
        connectionTag.stream().map(Tag::m_7916_).map(Direction::m_122402_).filter(Objects::nonNull).forEach(this.connectedTowards::add);
        super.read(nbt, clientPacket);
    }
}

