/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannonloading;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.Pair;
import rbasamoyai.createbigcannons.base.PoleContraption;
import rbasamoyai.createbigcannons.cannonloading.CannonLoaderBlock;
import rbasamoyai.createbigcannons.cannonloading.CannonLoaderBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.index.CBCContraptionTypes;
import rbasamoyai.createbigcannons.munitions.big_cannon.ProjectileBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCannonPropellantBlock;

public class CannonLoadingContraption
extends PoleContraption {
    protected LoadingHead loadingHead = LoadingHead.NOTHING;
    private static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final BooleanProperty MOVING = CannonLoaderBlock.MOVING;

    public CannonLoadingContraption() {
    }

    public CannonLoadingContraption(Direction direction, boolean retract) {
        super(direction, retract);
    }

    @Override
    protected boolean collectExtensions(Level level, BlockPos pos, Direction direction) throws AssemblyException {
        if (!CBCBlocks.CANNON_LOADER.has(level.m_8055_(pos))) {
            return false;
        }
        ArrayList<StructureTemplate.StructureBlockInfo> poles = new ArrayList<StructureTemplate.StructureBlockInfo>();
        BlockPos start = pos;
        BlockState nextBlock = level.m_8055_(start.m_121945_(direction));
        int extensionsInFront = 0;
        Direction.Axis blockAxis = direction.m_122434_();
        this.loadingHead = LoadingHead.NOTHING;
        PistonExtensionPoleBlock.PlacementHelper matcher = PistonExtensionPoleBlock.PlacementHelper.get();
        while (matcher.matchesAxis(nextBlock, blockAxis) || this.isValidLoaderHead(nextBlock) && ((Direction)nextBlock.m_61143_((Property)FACING)).m_122434_() == blockAxis || this.isValidCannonBlock((LevelAccessor)level, nextBlock, start.m_121945_(direction)) && this.matchesCannonAxis(nextBlock, blockAxis)) {
            if (this.isValidCannonBlock((LevelAccessor)level, nextBlock, start = start.m_121945_(direction))) {
                StructureTemplate.StructureBlockInfo containedBlock = ((BigCannonBehavior)((Object)((IBigCannonBlockEntity)level.m_7702_(start)).cannonBehavior())).block();
                nextBlock = containedBlock.f_74676_;
                if (matcher.matchesAxis(nextBlock, blockAxis)) {
                    poles.add(new StructureTemplate.StructureBlockInfo(start, (BlockState)nextBlock.m_61124_((Property)FACING, (Comparable)direction), null));
                } else {
                    if (this.isValidLoaderHead(nextBlock)) {
                        poles.add(new StructureTemplate.StructureBlockInfo(start, (BlockState)nextBlock.m_61124_((Property)FACING, (Comparable)direction), null));
                        if (CBCBlocks.RAM_HEAD.has(nextBlock)) {
                            this.loadingHead = LoadingHead.RAM_HEAD;
                            break;
                        }
                        this.loadingHead = LoadingHead.WORM_HEAD;
                        break;
                    }
                    if (nextBlock.m_60795_()) {
                        break;
                    }
                }
            } else {
                poles.add(new StructureTemplate.StructureBlockInfo(start, (BlockState)nextBlock.m_61124_((Property)FACING, (Comparable)direction), null));
                if (this.isValidLoaderHead(nextBlock)) {
                    if (CBCBlocks.RAM_HEAD.has(nextBlock)) {
                        this.loadingHead = LoadingHead.RAM_HEAD;
                        break;
                    }
                    this.loadingHead = LoadingHead.WORM_HEAD;
                    break;
                }
            }
            nextBlock = level.m_8055_(start.m_121945_(direction));
            if (++extensionsInFront <= CannonLoaderBlock.maxAllowedLoaderLength()) continue;
            throw AssemblyException.tooManyPistonPoles();
        }
        poles.add(new StructureTemplate.StructureBlockInfo(pos, (BlockState)AllBlocks.PISTON_EXTENSION_POLE.getDefaultState().m_61124_((Property)FACING, (Comparable)direction), null));
        BlockPos end = pos;
        int extensionsInBack = 0;
        Direction opposite = direction.m_122424_();
        nextBlock = level.m_8055_(end.m_121945_(opposite));
        while (matcher.matchesAxis(nextBlock, blockAxis)) {
            end = end.m_121945_(opposite);
            poles.add(new StructureTemplate.StructureBlockInfo(end, (BlockState)nextBlock.m_61124_((Property)FACING, (Comparable)direction), null));
            nextBlock = level.m_8055_(end.m_121945_(opposite));
            if (extensionsInFront + ++extensionsInBack <= CannonLoaderBlock.maxAllowedLoaderLength()) continue;
            throw AssemblyException.tooManyPistonPoles();
        }
        this.extensionLength = extensionsInFront + extensionsInBack;
        if (this.extensionLength == 0) {
            throw AssemblyException.noPistonPoles();
        }
        this.anchor = pos.m_5484_(direction, this.initialExtensionProgress + 2);
        this.initialExtensionProgress = extensionsInFront;
        this.pistonContraptionHitbox = new AABB(BlockPos.f_121853_.m_5484_(direction, this.loadingHead == LoadingHead.NOTHING ? -2 : -1), BlockPos.f_121853_.m_5484_(direction, -this.extensionLength - 2)).m_82363_(1.0, 1.0, 1.0);
        this.bounds = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (StructureTemplate.StructureBlockInfo pole : poles) {
            BlockPos relPos = pole.f_74675_.m_5484_(direction, -extensionsInFront);
            BlockPos localPos = relPos.m_121996_((Vec3i)this.anchor);
            this.getBlocks().put(localPos, new StructureTemplate.StructureBlockInfo(localPos, pole.f_74676_, null));
        }
        return true;
    }

    protected boolean moveBlock(Level level, Direction direction, Queue<BlockPos> frontier, Set<BlockPos> visited) throws AssemblyException {
        BlockPos pos = frontier.poll();
        if (pos == null) {
            return false;
        }
        visited.add(pos);
        if (level.m_151570_(pos)) {
            return true;
        }
        if (!level.m_46749_(pos)) {
            throw AssemblyException.unloadedChunk((BlockPos)pos);
        }
        if (this.isAnchoringBlockAt(pos)) {
            return true;
        }
        BlockPos ahead = pos.m_121945_(direction);
        BlockState state = level.m_8055_(ahead);
        if (this.isAnchoringBlockAt(ahead)) {
            return true;
        }
        if (!visited.contains(ahead)) {
            if (this.isValidLoadBlock(state, level, ahead)) {
                frontier.add(ahead);
            }
            if (this.isValidCannonBlock((LevelAccessor)level, state, ahead) && this.matchesCannonAxis(state, direction.m_122434_())) {
                BlockEntity blockEntity = level.m_7702_(ahead);
                if (!(blockEntity instanceof IBigCannonBlockEntity)) {
                    return true;
                }
                IBigCannonBlockEntity cannon = (IBigCannonBlockEntity)blockEntity;
                StructureTemplate.StructureBlockInfo blockInfo = ((BigCannonBehavior)((Object)cannon.cannonBehavior())).block();
                if (this.isValidLoadBlock(blockInfo.f_74676_, level, ahead)) {
                    frontier.add(ahead);
                }
            }
        }
        this.addBlock(pos, (Pair<StructureTemplate.StructureBlockInfo, BlockEntity>)this.capture(level, pos));
        if (this.blocks.size() <= (Integer)AllConfigs.server().kinetics.maxBlocksMoved.get()) {
            return true;
        }
        throw AssemblyException.structureTooLarge();
    }

    private boolean isValidLoaderHead(BlockState state) {
        return CBCBlocks.RAM_HEAD.has(state) || CBCBlocks.WORM_HEAD.has(state);
    }

    private boolean isValidCannonBlock(LevelAccessor level, BlockState state, BlockPos pos) {
        return state.m_60734_() instanceof BigCannonBlock && level.m_7702_(pos) instanceof IBigCannonBlockEntity;
    }

    private boolean matchesCannonAxis(BlockState state, Direction.Axis axis) {
        return ((BigCannonBlock)state.m_60734_()).getFacing(state).m_122434_() == axis;
    }

    protected void addBlock(BlockPos pos, Pair<StructureTemplate.StructureBlockInfo, BlockEntity> pair) {
        BlockEntity blockEntity = (BlockEntity)pair.getRight();
        if (blockEntity instanceof IBigCannonBlockEntity) {
            IBigCannonBlockEntity cannon = (IBigCannonBlockEntity)blockEntity;
            StructureTemplate.StructureBlockInfo containedInfo = ((BigCannonBehavior)((Object)cannon.cannonBehavior())).block();
            BlockEntity containedBlockEntity = null;
            if (containedInfo.f_74677_ != null) {
                containedInfo.f_74677_.m_128405_("x", pos.m_123341_());
                containedInfo.f_74677_.m_128405_("y", pos.m_123342_());
                containedInfo.f_74677_.m_128405_("z", pos.m_123343_());
                containedBlockEntity = BlockEntity.m_155241_((BlockPos)pos, (BlockState)containedInfo.f_74676_, (CompoundTag)containedInfo.f_74677_);
            }
            pair = Pair.of((Object)containedInfo, containedBlockEntity);
        }
        super.addBlock(pos.m_5484_(this.orientation, -this.initialExtensionProgress), pair);
    }

    protected boolean addToInitialFrontier(Level level, BlockPos pos, Direction forcedDirection, Queue<BlockPos> frontier) throws AssemblyException {
        frontier.clear();
        boolean retracting = forcedDirection != this.orientation;
        if (retracting != (this.loadingHead == LoadingHead.WORM_HEAD)) {
            return true;
        }
        for (int offset = 0; offset <= (Integer)AllConfigs.server().kinetics.maxChassisRange.get(); ++offset) {
            if (offset == 1 && retracting) {
                return true;
            }
            BlockPos currentPos = pos.m_5484_(this.orientation, offset + this.initialExtensionProgress);
            if (retracting && level.m_151570_(currentPos)) {
                return true;
            }
            if (!level.m_46749_(currentPos)) {
                throw AssemblyException.unloadedChunk((BlockPos)currentPos);
            }
            BlockState state = level.m_8055_(currentPos);
            if (this.isValidLoadBlock(state, level, currentPos)) {
                frontier.add(currentPos);
                continue;
            }
            if (this.isValidCannonBlock((LevelAccessor)level, state, currentPos) && this.matchesCannonAxis(state, forcedDirection.m_122434_())) {
                BlockEntity blockEntity = level.m_7702_(currentPos);
                if (!(blockEntity instanceof IBigCannonBlockEntity)) {
                    return true;
                }
                IBigCannonBlockEntity cannon = (IBigCannonBlockEntity)blockEntity;
                StructureTemplate.StructureBlockInfo blockInfo = ((BigCannonBehavior)((Object)cannon.cannonBehavior())).block();
                if (this.isValidLoadBlock(blockInfo.f_74676_, level, currentPos)) {
                    frontier.add(currentPos);
                    continue;
                }
                return true;
            }
            return true;
        }
        return true;
    }

    private boolean isValidLoadBlock(BlockState state, Level level, BlockPos pos) {
        Direction.Axis axis = this.orientation.m_122434_();
        Block block = state.m_60734_();
        if (block instanceof BigCannonPropellantBlock) {
            BigCannonPropellantBlock propellant = (BigCannonPropellantBlock)block;
            return propellant.canBeLoaded(state, axis);
        }
        if (state.m_60734_() instanceof ProjectileBlock) {
            return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == axis;
        }
        return false;
    }

    protected boolean customBlockPlacement(LevelAccessor level, BlockPos pos, BlockState state) {
        CannonLoaderBlockEntity clbe;
        BlockState loaderState;
        BlockPos levelPos;
        block7: {
            block6: {
                levelPos = this.anchor.m_5484_(this.orientation, -2);
                loaderState = level.m_8055_(levelPos);
                BlockEntity blockEntity = level.m_7702_(levelPos);
                if (!(blockEntity instanceof CannonLoaderBlockEntity)) break block6;
                clbe = (CannonLoaderBlockEntity)blockEntity;
                if (!blockEntity.m_58901_()) break block7;
            }
            return true;
        }
        if (pos.equals((Object)levelPos)) {
            level.m_7731_(levelPos, (BlockState)loaderState.m_61124_((Property)MOVING, (Comparable)Boolean.valueOf(false)), 19);
            return true;
        }
        if (clbe.movedContraption != null) {
            BlockPos entityAnchor = new BlockPos(clbe.movedContraption.getAnchorVec().m_82520_(0.5, 0.5, 0.5));
            BlockPos blockPos = pos.m_121996_((Vec3i)entityAnchor);
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)this.getBlocks().get(blockPos);
            BlockEntity blockEntity1 = level.m_7702_(pos);
            if (blockEntity1 instanceof IBigCannonBlockEntity) {
                IBigCannonBlockEntity cannon = (IBigCannonBlockEntity)blockEntity1;
                return ((BigCannonBehavior)((Object)cannon.cannonBehavior())).tryLoadingBlock(blockInfo);
            }
        }
        return false;
    }

    protected boolean customBlockRemoval(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockPos loaderPos = this.anchor.m_5484_(this.orientation, -2);
        BlockState loaderState = level.m_8055_(loaderPos);
        if (pos.equals((Object)loaderPos) && CBCBlocks.CANNON_LOADER.has(loaderState)) {
            level.m_7731_(loaderPos, (BlockState)loaderState.m_61124_((Property)MOVING, (Comparable)Boolean.valueOf(true)), 82);
            return true;
        }
        BlockEntity blockEntity = level.m_7702_(loaderPos);
        if (!(blockEntity instanceof CannonLoaderBlockEntity) || blockEntity.m_58901_()) {
            return true;
        }
        BlockEntity blockEntity1 = level.m_7702_(pos);
        if (blockEntity1 instanceof IBigCannonBlockEntity) {
            IBigCannonBlockEntity cannon = (IBigCannonBlockEntity)blockEntity1;
            ((BigCannonBehavior)((Object)cannon.cannonBehavior())).removeBlock();
            return true;
        }
        return false;
    }

    @Override
    public void readNBT(Level level, CompoundTag tag, boolean spawnData) {
        super.readNBT(level, tag, spawnData);
        this.loadingHead = LoadingHead.fromOrdinal(tag.m_128451_("LoadingHead"));
    }

    @Override
    public CompoundTag writeNBT(boolean spawnPacket) {
        CompoundTag tag = super.writeNBT(spawnPacket);
        tag.m_128405_("LoadingHead", this.loadingHead == null ? LoadingHead.NOTHING.ordinal() : this.loadingHead.ordinal());
        return tag;
    }

    public ContraptionType getType() {
        return CBCContraptionTypes.CANNON_LOADER;
    }

    public static enum LoadingHead {
        RAM_HEAD,
        WORM_HEAD,
        NOTHING;

        private static final LoadingHead[] VALUES;

        public static LoadingHead fromOrdinal(int ordinal) {
            return ordinal <= 0 && ordinal < VALUES.length ? VALUES[ordinal] : NOTHING;
        }

        static {
            VALUES = LoadingHead.values();
        }
    }
}

