/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.contraption;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CBCTags;
import rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannon_control.effects.CannonPlumeParticleData;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.BigCannonBreechStrengthHandler;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech.QuickfiringBreechBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.cannon_end.BigCannonEnd;
import rbasamoyai.createbigcannons.cannons.big_cannons.material.BigCannonMaterial;
import rbasamoyai.createbigcannons.cannons.big_cannons.material.BigCannonMaterialProperties;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCBigCannonMaterials;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.index.CBCContraptionTypes;
import rbasamoyai.createbigcannons.index.CBCSoundEvents;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.ProjectileBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCannonPropellantBlock;

public class MountedBigCannonContraption
extends AbstractMountedCannonContraption {
    private BigCannonMaterial cannonMaterial;
    public boolean hasFired = false;

    @Override
    public float maximumDepression(@Nonnull ControlPitchContraption controller) {
        BlockState state = controller.getControllerState();
        if (CBCBlocks.CANNON_MOUNT.has(state)) {
            return 30.0f;
        }
        if (CBCBlocks.CANNON_CARRIAGE.has(state)) {
            return 15.0f;
        }
        return 0.0f;
    }

    @Override
    public float maximumElevation(@Nonnull ControlPitchContraption controller) {
        BlockState state = controller.getControllerState();
        if (CBCBlocks.CANNON_MOUNT.has(state)) {
            return 60.0f;
        }
        if (CBCBlocks.CANNON_CARRIAGE.has(state)) {
            return 30.0f;
        }
        return 0.0f;
    }

    public boolean assemble(Level level, BlockPos pos) throws AssemblyException {
        if (!this.collectCannonBlocks(level, pos)) {
            return false;
        }
        this.bounds = new AABB(BlockPos.f_121853_);
        this.bounds = this.bounds.m_82400_(Math.ceil(Math.sqrt(MountedBigCannonContraption.getRadius(this.getBlocks().keySet(), (Direction.Axis)Direction.Axis.Y))));
        return !this.blocks.isEmpty();
    }

    private boolean collectCannonBlocks(Level level, BlockPos pos) throws AssemblyException {
        BlockPos negativeEndPos;
        BlockState startState = level.m_8055_(pos);
        Block block = startState.m_60734_();
        if (!(block instanceof BigCannonBlock)) {
            return false;
        }
        BigCannonBlock startCannon = (BigCannonBlock)block;
        if (!startCannon.isComplete(startState)) {
            throw MountedBigCannonContraption.hasIncompleteCannonBlocks(pos);
        }
        if (this.hasCannonLoaderInside((LevelAccessor)level, startState, pos)) {
            throw MountedBigCannonContraption.cannonLoaderInsideDuringAssembly(pos);
        }
        BigCannonMaterial material = startCannon.getCannonMaterial();
        BigCannonEnd startEnd = startCannon.getOpeningType(level, startState, pos);
        ArrayList<StructureTemplate.StructureBlockInfo> cannonBlocks = new ArrayList<StructureTemplate.StructureBlockInfo>();
        cannonBlocks.add(new StructureTemplate.StructureBlockInfo(pos, startState, this.getBlockEntityNBT(level, pos)));
        int cannonLength = 1;
        Direction cannonFacing = startCannon.getFacing(startState);
        Direction positive = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)cannonFacing.m_122434_());
        Direction negative = positive.m_122424_();
        BlockPos start = pos;
        BlockState nextState = level.m_8055_(pos.m_121945_(positive));
        BigCannonEnd positiveEnd = startEnd;
        while (this.isValidCannonBlock((LevelAccessor)level, nextState, start.m_121945_(positive)) && this.isConnectedToCannon((LevelAccessor)level, nextState, start.m_121945_(positive), positive, material)) {
            start = start.m_121945_(positive);
            if (!((BigCannonBlock)nextState.m_60734_()).isComplete(nextState)) {
                throw MountedBigCannonContraption.hasIncompleteCannonBlocks(start);
            }
            cannonBlocks.add(new StructureTemplate.StructureBlockInfo(start, nextState, this.getBlockEntityNBT(level, start)));
            ++cannonLength;
            positiveEnd = ((BigCannonBlock)nextState.m_60734_()).getOpeningType(level, nextState, start);
            if (this.hasCannonLoaderInside((LevelAccessor)level, nextState, start)) {
                throw MountedBigCannonContraption.cannonLoaderInsideDuringAssembly(start);
            }
            nextState = level.m_8055_(start.m_121945_(positive));
            if (cannonLength > MountedBigCannonContraption.getMaxCannonLength()) {
                throw MountedBigCannonContraption.cannonTooLarge();
            }
            if (positiveEnd == BigCannonEnd.OPEN) continue;
        }
        BlockPos positiveEndPos = positiveEnd == BigCannonEnd.OPEN ? start : start.m_121945_(negative);
        start = pos;
        nextState = level.m_8055_(pos.m_121945_(negative));
        BigCannonEnd negativeEnd = startEnd;
        while (this.isValidCannonBlock((LevelAccessor)level, nextState, start.m_121945_(negative)) && this.isConnectedToCannon((LevelAccessor)level, nextState, start.m_121945_(negative), negative, material)) {
            start = start.m_121945_(negative);
            if (!((BigCannonBlock)nextState.m_60734_()).isComplete(nextState)) {
                throw MountedBigCannonContraption.hasIncompleteCannonBlocks(start);
            }
            cannonBlocks.add(new StructureTemplate.StructureBlockInfo(start, nextState, this.getBlockEntityNBT(level, start)));
            ++cannonLength;
            negativeEnd = ((BigCannonBlock)nextState.m_60734_()).getOpeningType(level, nextState, start);
            if (this.hasCannonLoaderInside((LevelAccessor)level, nextState, start)) {
                throw MountedBigCannonContraption.cannonLoaderInsideDuringAssembly(start);
            }
            nextState = level.m_8055_(start.m_121945_(negative));
            if (cannonLength > MountedBigCannonContraption.getMaxCannonLength()) {
                throw MountedBigCannonContraption.cannonTooLarge();
            }
            if (negativeEnd == BigCannonEnd.OPEN) continue;
        }
        BlockPos blockPos = negativeEndPos = negativeEnd == BigCannonEnd.OPEN ? start : start.m_121945_(positive);
        if (positiveEnd == negativeEnd) {
            throw MountedBigCannonContraption.invalidCannon();
        }
        boolean openEndFlag = positiveEnd == BigCannonEnd.OPEN;
        this.initialOrientation = openEndFlag ? positive : negative;
        this.startPos = openEndFlag ? negativeEndPos : positiveEndPos;
        this.anchor = pos;
        this.startPos = this.startPos.m_121996_((Vec3i)pos);
        for (StructureTemplate.StructureBlockInfo blockInfo : cannonBlocks) {
            BlockPos localPos = blockInfo.f_74675_.m_121996_((Vec3i)pos);
            StructureTemplate.StructureBlockInfo localBlockInfo = new StructureTemplate.StructureBlockInfo(localPos, blockInfo.f_74676_, blockInfo.f_74677_);
            this.getBlocks().put(localPos, localBlockInfo);
            if (blockInfo.f_74677_ == null) continue;
            BlockEntity be = BlockEntity.m_155241_((BlockPos)localPos, (BlockState)blockInfo.f_74676_, (CompoundTag)blockInfo.f_74677_);
            this.presentBlockEntities.put(localPos, be);
        }
        this.cannonMaterial = material;
        return true;
    }

    private boolean isValidCannonBlock(LevelAccessor level, BlockState state, BlockPos pos) {
        return state.m_60734_() instanceof BigCannonBlock;
    }

    private boolean hasCannonLoaderInside(LevelAccessor level, BlockState state, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof IBigCannonBlockEntity)) {
            return false;
        }
        IBigCannonBlockEntity cannon = (IBigCannonBlockEntity)be;
        BlockState containedState = ((BigCannonBehavior)((Object)cannon.cannonBehavior())).block().f_74676_;
        return CBCBlocks.RAM_HEAD.has(containedState) || CBCBlocks.WORM_HEAD.has(containedState) || AllBlocks.PISTON_EXTENSION_POLE.has(containedState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isConnectedToCannon(LevelAccessor level, BlockState state, BlockPos pos, Direction connection, BigCannonMaterial material) {
        BigCannonBlock cBlock = (BigCannonBlock)state.m_60734_();
        if (cBlock.getCannonMaterialInLevel(level, state, pos) != material) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof IBigCannonBlockEntity)) return false;
        IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)blockEntity;
        blockEntity = level.m_7702_(pos.m_121945_(connection.m_122424_()));
        if (!(blockEntity instanceof IBigCannonBlockEntity)) return false;
        IBigCannonBlockEntity cbe1 = (IBigCannonBlockEntity)blockEntity;
        if (!((BigCannonBehavior)((Object)cbe.cannonBehavior())).isConnectedTo(connection.m_122424_())) return false;
        if (!((BigCannonBehavior)((Object)cbe1.cannonBehavior())).isConnectedTo(connection)) return false;
        return true;
    }

    @Override
    public float getWeightForStress() {
        if (this.cannonMaterial == null) {
            return this.blocks.size();
        }
        return (float)this.blocks.size() * this.cannonMaterial.properties().weight();
    }

    @Override
    public void tick(Level level, PitchOrientedContraptionEntity entity) {
        super.tick(level, entity);
        BlockPos endPos = this.startPos.m_121945_(this.initialOrientation.m_122424_());
        Object v = this.presentBlockEntities.get(endPos);
        if (v instanceof QuickfiringBreechBlockEntity) {
            QuickfiringBreechBlockEntity qfbreech = (QuickfiringBreechBlockEntity)v;
            qfbreech.tickAnimation();
        }
    }

    @Override
    public void onRedstoneUpdate(ServerLevel level, PitchOrientedContraptionEntity entity, boolean togglePower, int firePower, ControlPitchContraption controller) {
        if (!togglePower || firePower <= 0) {
            return;
        }
        this.fireShot(level, entity, controller);
    }

    @Override
    public void fireShot(ServerLevel level, PitchOrientedContraptionEntity entity, @Nullable ControlPitchContraption controller) {
        Block cannonState;
        Object v;
        QuickfiringBreechBlockEntity qfbreech;
        BlockPos endPos = this.startPos.m_121945_(this.initialOrientation.m_122424_());
        Object v2 = this.presentBlockEntities.get(endPos);
        if (v2 instanceof QuickfiringBreechBlockEntity && (qfbreech = (QuickfiringBreechBlockEntity)v2).getOpenProgress() > 0) {
            return;
        }
        StructureTemplate.StructureBlockInfo foundProjectile = null;
        float chargesUsed = 0.0f;
        float stress = 0.0f;
        float smokeScale = 0.0f;
        int barrelTravelled = 0;
        RandomSource rand = level.m_213780_();
        boolean failed = false;
        boolean canFail = (Boolean)CBCConfigs.SERVER.failure.disableAllFailure.get() == false;
        BlockPos currentPos = this.startPos.m_7949_();
        int count = 0;
        SmartBlockEntity failedEntity = null;
        float spread = 0.0f;
        float spreadSub = CBCConfigs.SERVER.cannons.barrelSpreadReduction.getF();
        boolean emptyNoProjectile = false;
        BigCannonMaterialProperties properties = this.cannonMaterial.properties();
        StructureTemplate.StructureBlockInfo breech = (StructureTemplate.StructureBlockInfo)this.blocks.get(this.startPos.m_121945_(this.initialOrientation.m_122424_()));
        int materialStrength = properties.maxSafeBaseCharges();
        int maxSafeCharges = Math.min(materialStrength, BigCannonBreechStrengthHandler.getStrength(breech.f_74676_.m_60734_(), materialStrength));
        BigCannonPropellantBlock propellant = null;
        while ((v = this.presentBlockEntities.get(currentPos)) instanceof IBigCannonBlockEntity) {
            BigCannonBlock cannon;
            Block failIgnitePos;
            IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)v;
            BigCannonBehavior behavior = (BigCannonBehavior)((Object)cbe.cannonBehavior());
            StructureTemplate.StructureBlockInfo containedBlockInfo = behavior.block();
            StructureTemplate.StructureBlockInfo cannonInfo = (StructureTemplate.StructureBlockInfo)this.blocks.get(currentPos);
            if (foundProjectile == null && containedBlockInfo.f_74676_.m_60795_()) {
                if (count == 0) {
                    return;
                }
                emptyNoProjectile = true;
                chargesUsed = Math.max(chargesUsed - 1.0f, 0.0f);
            } else {
                Block block = containedBlockInfo.f_74676_.m_60734_();
                if (block instanceof BigCannonPropellantBlock) {
                    BigCannonPropellantBlock cpropel = (BigCannonPropellantBlock)block;
                    if (propellant == null) {
                        if (!cpropel.canBeIgnited(containedBlockInfo, this.initialOrientation)) {
                            return;
                        }
                        propellant = cpropel;
                    } else if (propellant.isCompatibleWith(cpropel, containedBlockInfo, this.initialOrientation)) {
                        propellant = cpropel;
                    } else if (canFail) {
                        failed = true;
                        failedEntity = behavior.blockEntity;
                        break;
                    }
                    this.consumeBlock(behavior, currentPos, propellant::consumePropellant);
                    float power = Math.max(0.0f, propellant.getChargePower(containedBlockInfo));
                    chargesUsed += power;
                    smokeScale += power;
                    stress += propellant.getStressOnCannon(containedBlockInfo);
                    spread += propellant.getSpread(containedBlockInfo);
                    if (canFail && (!cbe.blockCanHandle(cannonInfo) && MountedBigCannonContraption.rollBarrelBurst(rand) || stress > (float)maxSafeCharges && MountedBigCannonContraption.rollOverloadBurst(rand))) {
                        failed = true;
                        failedEntity = behavior.blockEntity;
                        break;
                    }
                    if (emptyNoProjectile && canFail && MountedBigCannonContraption.rollFailToIgnite(rand)) {
                        failIgnitePos = entity.toGlobalVector(Vec3.m_82512_((Vec3i)currentPos.m_121945_(this.initialOrientation)), 1.0f);
                        level.m_6263_(null, failIgnitePos.f_82479_, failIgnitePos.f_82480_, failIgnitePos.f_82481_, cannonInfo.f_74676_.m_60827_().m_56775_(), SoundSource.BLOCKS, 5.0f, 0.0f);
                        return;
                    }
                    emptyNoProjectile = false;
                } else if (containedBlockInfo.f_74676_.m_60734_() instanceof ProjectileBlock && foundProjectile == null) {
                    if (chargesUsed == 0.0f) {
                        return;
                    }
                    foundProjectile = containedBlockInfo;
                    if (emptyNoProjectile && MountedBigCannonContraption.rollFailToIgnite(rand) && canFail) {
                        Vec3 failIgnitePos2 = entity.toGlobalVector(Vec3.m_82512_((Vec3i)currentPos.m_121945_(this.initialOrientation)), 1.0f);
                        level.m_6263_(null, failIgnitePos2.f_82479_, failIgnitePos2.f_82480_, failIgnitePos2.f_82481_, cannonInfo.f_74676_.m_60827_().m_56775_(), SoundSource.BLOCKS, 5.0f, 0.0f);
                        return;
                    }
                    this.consumeBlock(behavior, currentPos);
                    emptyNoProjectile = false;
                } else if (!containedBlockInfo.f_74676_.m_60795_() && foundProjectile != null) {
                    if (canFail) {
                        failed = true;
                        failedEntity = behavior.blockEntity;
                        break;
                    }
                    this.consumeBlock(behavior, currentPos);
                }
            }
            currentPos = currentPos.m_121945_(this.initialOrientation);
            cannonState = cannonInfo.f_74676_;
            failIgnitePos = cannonState.m_60734_();
            if (failIgnitePos instanceof BigCannonBlock && (cannon = (BigCannonBlock)failIgnitePos).getOpeningType((Level)level, (BlockState)cannonState, currentPos) == BigCannonEnd.OPEN) {
                ++count;
            }
            if (foundProjectile == null) continue;
            ++barrelTravelled;
            if (cannonInfo.f_74676_.m_204336_(CBCTags.BlockCBC.REDUCES_SPREAD)) {
                spread = Math.max(spread - spreadSub, 0.0f);
            }
            if (!(chargesUsed > 0.0f) || !((double)barrelTravelled / (double)chargesUsed > this.cannonMaterial.properties().squibRatio()) || !MountedBigCannonContraption.rollSquib(rand)) continue;
            behavior.loadBlock(foundProjectile);
            CompoundTag tag = behavior.blockEntity.m_187480_();
            tag.m_128473_("x");
            tag.m_128473_("y");
            tag.m_128473_("z");
            StructureTemplate.StructureBlockInfo squibInfo = new StructureTemplate.StructureBlockInfo(cannonInfo.f_74675_, cannonInfo.f_74676_, tag);
            this.blocks.put(cannonInfo.f_74675_, squibInfo);
            Vec3 squibPos = entity.toGlobalVector(Vec3.m_82512_((Vec3i)currentPos.m_121945_(this.initialOrientation)), 1.0f);
            level.m_6263_(null, squibPos.f_82479_, squibPos.f_82480_, squibPos.f_82481_, cannonInfo.f_74676_.m_60827_().m_56775_(), SoundSource.BLOCKS, 10.0f, 0.0f);
            return;
        }
        if (canFail && failed && failedEntity != null) {
            this.fail(currentPos, (Level)level, entity, (BlockEntity)failedEntity, (int)chargesUsed);
            return;
        }
        if (chargesUsed <= 0.0f) {
            chargesUsed = 0.5f;
        }
        Vec3 spawnPos = entity.toGlobalVector(Vec3.m_82512_((Vec3i)currentPos.m_121945_(this.initialOrientation)), 1.0f);
        Vec3 vec = spawnPos.m_82546_(entity.toGlobalVector(Vec3.m_82512_((Vec3i)BlockPos.f_121853_), 1.0f)).m_82541_();
        float recoilMagnitude = chargesUsed;
        if (foundProjectile != null && (cannonState = foundProjectile.f_74676_.m_60734_()) instanceof ProjectileBlock) {
            ProjectileBlock projectileBlock = (ProjectileBlock)cannonState;
            BlockEntity projectileBE = foundProjectile.f_74677_ == null ? null : BlockEntity.m_155241_((BlockPos)foundProjectile.f_74675_, (BlockState)foundProjectile.f_74676_, (CompoundTag)foundProjectile.f_74677_);
            AbstractCannonProjectile projectile = projectileBlock.getProjectile((Level)level, foundProjectile.f_74676_, foundProjectile.f_74675_, projectileBE);
            projectile.m_146884_(spawnPos);
            projectile.setChargePower(chargesUsed);
            projectile.m_6686_(vec.f_82479_, vec.f_82480_, vec.f_82481_, chargesUsed, spread);
            projectile.f_19860_ = projectile.m_146909_();
            projectile.f_19859_ = projectile.m_146908_();
            level.m_7967_((Entity)projectile);
            recoilMagnitude += 1.0f;
        }
        recoilMagnitude *= CBCConfigs.SERVER.cannons.bigCannonRecoilScale.getF();
        if (controller != null) {
            controller.onRecoil(vec.m_82490_((double)(-recoilMagnitude)), (AbstractContraptionEntity)entity);
        }
        this.hasFired = true;
        for (ServerPlayer player : level.m_6907_()) {
            level.m_8624_(player, (ParticleOptions)new CannonPlumeParticleData(smokeScale * 0.5f), true, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0, vec.f_82479_, vec.f_82480_, vec.f_82481_, 1.0);
        }
        CBCSoundEvents.FIRE_BIG_CANNON.playOnServer((Level)level, (Vec3i)new BlockPos(spawnPos));
    }

    private void consumeBlock(BigCannonBehavior behavior, BlockPos pos) {
        this.consumeBlock(behavior, pos, BigCannonBehavior::removeBlock);
    }

    private void consumeBlock(BigCannonBehavior behavior, BlockPos pos, Consumer<BigCannonBehavior> action) {
        action.accept(behavior);
        CompoundTag tag = behavior.blockEntity.m_187480_();
        tag.m_128473_("x");
        tag.m_128473_("y");
        tag.m_128473_("z");
        StructureTemplate.StructureBlockInfo oldInfo = (StructureTemplate.StructureBlockInfo)this.blocks.get(pos);
        if (oldInfo == null) {
            return;
        }
        StructureTemplate.StructureBlockInfo consumedInfo = new StructureTemplate.StructureBlockInfo(oldInfo.f_74675_, oldInfo.f_74676_, tag);
        this.blocks.put(oldInfo.f_74675_, consumedInfo);
    }

    private static boolean rollSquib(RandomSource random) {
        float f = CBCConfigs.SERVER.failure.squibChance.getF();
        return f != 0.0f && random.m_188501_() <= f;
    }

    private static boolean rollBarrelBurst(RandomSource random) {
        float f = CBCConfigs.SERVER.failure.barrelChargeBurstChance.getF();
        return f != 0.0f && random.m_188501_() <= f;
    }

    private static boolean rollOverloadBurst(RandomSource random) {
        float f = CBCConfigs.SERVER.failure.overloadBurstChance.getF();
        return f != 0.0f && random.m_188501_() <= f;
    }

    private static boolean rollFailToIgnite(RandomSource random) {
        float f = CBCConfigs.SERVER.failure.interruptedIgnitionChance.getF();
        return f != 0.0f && random.m_188501_() <= f;
    }

    public void fail(BlockPos localPos, Level level, PitchOrientedContraptionEntity entity, BlockEntity failed, int charges) {
        Vec3 failurePoint = entity.toGlobalVector(Vec3.m_82512_((Vec3i)failed.m_58899_()), 1.0f);
        float failScale = CBCConfigs.SERVER.failure.failureExplosionPower.getF();
        if (this.cannonMaterial.properties().failureMode() == BigCannonMaterialProperties.FailureMode.RUPTURE) {
            level.m_46511_(null, failurePoint.f_82479_, failurePoint.f_82480_, failurePoint.f_82481_, 2.0f * failScale + 1.0f, Explosion.BlockInteraction.NONE);
            int failInt = Mth.m_14167_((float)failScale);
            BlockPos startPos = localPos.m_5484_(this.initialOrientation.m_122424_(), failInt);
            for (int i = 0; i < failInt * 2 + 1; ++i) {
                BlockPos pos = startPos.m_5484_(this.initialOrientation, i);
                this.blocks.remove(pos);
                this.presentBlockEntities.remove(pos);
            }
            ControlPitchContraption controller = entity.getController();
            if (controller != null) {
                controller.disassemble();
            }
        } else {
            Iterator iter = this.blocks.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.presentBlockEntities.remove(entry.getKey());
                iter.remove();
            }
            float power = (float)charges * failScale;
            level.m_46511_(null, failurePoint.f_82479_, failurePoint.f_82480_, failurePoint.f_82481_, power, Explosion.BlockInteraction.DESTROY);
            entity.m_146870_();
        }
    }

    @Override
    public Vec3 getInteractionVec(PitchOrientedContraptionEntity poce) {
        return poce.toGlobalVector(Vec3.m_82512_((Vec3i)this.startPos.m_121945_(this.initialOrientation.m_122424_())), 1.0f);
    }

    @Override
    public CompoundTag writeNBT(boolean clientData) {
        CompoundTag tag = super.writeNBT(clientData);
        tag.m_128359_("CannonMaterial", this.cannonMaterial == null ? CBCBigCannonMaterials.CAST_IRON.name().toString() : this.cannonMaterial.name().toString());
        return tag;
    }

    @Override
    public void readNBT(Level level, CompoundTag tag, boolean clientData) {
        super.readNBT(level, tag, clientData);
        this.cannonMaterial = BigCannonMaterial.fromNameOrNull(new ResourceLocation(tag.m_128461_("CannonMaterial")));
        if (this.cannonMaterial == null) {
            this.cannonMaterial = CBCBigCannonMaterials.CAST_IRON;
        }
    }

    public ContraptionType getType() {
        return CBCContraptionTypes.MOUNTED_CANNON;
    }
}

