/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.contraption;

import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.config.CBCConfigs;

public abstract class AbstractMountedCannonContraption
extends Contraption {
    protected Direction initialOrientation = Direction.NORTH;
    protected BlockPos startPos = BlockPos.f_121853_;

    public abstract float maximumDepression(@Nonnull ControlPitchContraption var1);

    public abstract float maximumElevation(@Nonnull ControlPitchContraption var1);

    public Direction initialOrientation() {
        return this.initialOrientation;
    }

    public abstract void onRedstoneUpdate(ServerLevel var1, PitchOrientedContraptionEntity var2, boolean var3, int var4, ControlPitchContraption var5);

    public abstract void fireShot(ServerLevel var1, PitchOrientedContraptionEntity var2, @Nullable ControlPitchContraption var3);

    public abstract float getWeightForStress();

    public void tick(Level level, PitchOrientedContraptionEntity entity) {
    }

    public void animate() {
    }

    public CompoundTag writeNBT(boolean spawnPacket) {
        for (Map.Entry entry : this.presentBlockEntities.entrySet()) {
            StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)this.blocks.get(entry.getKey());
            if (info == null) continue;
            CompoundTag nbt = ((BlockEntity)entry.getValue()).m_187480_();
            nbt.m_128473_("x");
            nbt.m_128473_("y");
            nbt.m_128473_("z");
            this.blocks.put((BlockPos)entry.getKey(), new StructureTemplate.StructureBlockInfo(info.f_74675_, info.f_74676_, nbt));
        }
        CompoundTag tag = super.writeNBT(spawnPacket);
        if (this.initialOrientation != null) {
            tag.m_128359_("InitialOrientation", this.initialOrientation.m_7912_());
        }
        tag.m_128356_("LocalStartingPos", this.startPos == null ? 0L : this.startPos.m_121878_());
        return tag;
    }

    public void readNBT(Level world, CompoundTag tag, boolean spawnData) {
        super.readNBT(world, tag, spawnData);
        this.initialOrientation = tag.m_128425_("InitialOrientation", 8) ? Direction.m_122402_((String)tag.m_128461_("InitialOrientation")) : Direction.NORTH;
        this.startPos = BlockPos.m_122022_((long)tag.m_128454_("LocalStartingPos"));
        if (world.f_46443_) {
            return;
        }
        for (Map.Entry entry : this.blocks.entrySet()) {
            StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)this.blocks.get(entry.getKey());
            if (info == null || info.f_74677_ == null) continue;
            info.f_74677_.m_128405_("x", info.f_74675_.m_123341_());
            info.f_74677_.m_128405_("y", info.f_74675_.m_123342_());
            info.f_74677_.m_128405_("z", info.f_74675_.m_123343_());
            BlockEntity be = BlockEntity.m_155241_((BlockPos)info.f_74675_, (BlockState)info.f_74676_, (CompoundTag)info.f_74677_);
            if (be == null) continue;
            be.m_142339_(world);
            this.presentBlockEntities.put(info.f_74675_, be);
        }
    }

    public boolean canBeStabilized(Direction direction, BlockPos pos) {
        return true;
    }

    public boolean canBeTurnedByPassenger(Entity entity) {
        return false;
    }

    public boolean canBeTurnedByController(ControlPitchContraption control) {
        return true;
    }

    public boolean canBeFiredOnController(ControlPitchContraption control) {
        return true;
    }

    public BlockPos getSeatPos(Entity entity) {
        return null;
    }

    public abstract Vec3 getInteractionVec(PitchOrientedContraptionEntity var1);

    public BlockPos getStartPos() {
        return this.startPos;
    }

    public static int getMaxCannonLength() {
        return (Integer)CBCConfigs.SERVER.cannons.maxCannonLength.get();
    }

    public static AssemblyException cannonTooLarge() {
        return new AssemblyException((Component)Component.m_237110_((String)"exception.createbigcannons.cannon_mount.cannonTooLarge", (Object[])new Object[]{AbstractMountedCannonContraption.getMaxCannonLength()}));
    }

    public static AssemblyException invalidCannon() {
        return new AssemblyException((Component)Component.m_237115_((String)"exception.createbigcannons.cannon_mount.invalidCannon"));
    }

    public static AssemblyException cannonLoaderInsideDuringAssembly(BlockPos pos) {
        return new AssemblyException((Component)Component.m_237110_((String)"exception.createbigcannons.cannon_mount.cannonLoaderInsideDuringAssembly", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
    }

    public static AssemblyException hasIncompleteCannonBlocks(BlockPos pos) {
        return new AssemblyException((Component)Component.m_237110_((String)"exception.createbigcannons.cannon_mount.hasIncompleteCannonBlocks", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
    }
}

