/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.cannon_mount;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlock;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.MountedAutocannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.MountedBigCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.index.CBCBlocks;

public class CannonMountBlockEntity
extends KineticBlockEntity
implements IDisplayAssemblyExceptions,
ControlPitchContraption.Block {
    private static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    private AssemblyException lastException = null;
    protected PitchOrientedContraptionEntity mountedContraption;
    private boolean running;
    private float cannonYaw;
    private float cannonPitch;
    private float prevYaw;
    private float prevPitch;
    private float clientYawDiff;
    private float clientPitchDiff;
    float yawSpeed;

    public CannonMountBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        if (CBCBlocks.CANNON_MOUNT.has(state)) {
            this.cannonYaw = ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122435_();
        }
        this.setLazyTickRate(3);
    }

    @Override
    public BlockState getControllerState() {
        return this.m_58900_();
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82363_(0.0, 2.0, 0.0);
    }

    public void tick() {
        boolean flag;
        super.tick();
        if (this.mountedContraption != null && !this.mountedContraption.m_6084_()) {
            this.mountedContraption = null;
        }
        this.prevYaw = this.cannonYaw;
        this.prevPitch = this.cannonPitch;
        boolean bl = flag = this.mountedContraption != null && this.mountedContraption.canBeTurnedByController(this);
        if (this.f_58857_.f_46443_) {
            this.clientYawDiff = flag ? this.clientYawDiff * 0.5f : 0.0f;
            float f = this.clientPitchDiff = flag ? this.clientPitchDiff * 0.5f : 0.0f;
        }
        if (!this.running && !this.isVirtual()) {
            if (CBCBlocks.CANNON_MOUNT.has(this.m_58900_())) {
                this.prevYaw = this.cannonYaw = ((Direction)this.m_58900_().m_61143_((Property)HORIZONTAL_FACING)).m_122435_();
                this.cannonPitch = 0.0f;
                this.prevPitch = 0.0f;
            }
            return;
        }
        if ((this.mountedContraption == null || !this.mountedContraption.isStalled()) && flag) {
            float yawSpeed = this.getAngularSpeed(this::getYawSpeed, this.clientYawDiff);
            float pitchSpeed = this.getAngularSpeed(() -> ((CannonMountBlockEntity)this).getSpeed(), this.clientPitchDiff);
            float newYaw = this.cannonYaw + yawSpeed;
            float newPitch = this.cannonPitch + pitchSpeed;
            this.cannonYaw = newYaw % 360.0f;
            if (this.mountedContraption == null) {
                this.cannonPitch = 0.0f;
            } else {
                Direction dir = this.getContraptionDirection();
                boolean flag1 = dir.m_122421_() == Direction.AxisDirection.POSITIVE == (dir.m_122434_() == Direction.Axis.X);
                float cu = flag1 ? this.getMaxElevate() : this.getMaxDepress();
                float cd = flag1 ? -this.getMaxDepress() : -this.getMaxElevate();
                this.cannonPitch = Mth.m_14036_((float)(newPitch % 360.0f), (float)cd, (float)cu);
            }
        }
        this.applyRotation();
    }

    private float getMaxDepress() {
        return this.mountedContraption.maximumDepression();
    }

    private float getMaxElevate() {
        return this.mountedContraption.maximumElevation();
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void applyRotation() {
        if (this.mountedContraption == null) {
            return;
        }
        if (!this.mountedContraption.canBeTurnedByController(this)) {
            this.cannonPitch = this.mountedContraption.m_146909_();
            this.cannonYaw = this.mountedContraption.m_146908_();
        }
        this.mountedContraption.pitch = this.cannonPitch;
        this.mountedContraption.yaw = this.cannonYaw;
    }

    public void applyHandRotation() {
        if (this.mountedContraption == null) {
            return;
        }
        this.cannonPitch = this.mountedContraption.pitch;
        this.cannonYaw = this.mountedContraption.yaw;
        this.prevPitch = this.cannonPitch;
        this.prevYaw = this.cannonYaw;
    }

    public void onRedstoneUpdate(boolean assemblyPowered, boolean prevAssemblyPowered, boolean firePowered, boolean prevFirePowered, int firePower) {
        Level level;
        if (assemblyPowered != prevAssemblyPowered) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)CannonMountBlock.ASSEMBLY_POWERED, (Comparable)Boolean.valueOf(assemblyPowered)), 3);
            if (assemblyPowered) {
                try {
                    this.assemble();
                    this.lastException = null;
                }
                catch (AssemblyException e) {
                    this.lastException = e;
                    this.sendData();
                }
            } else {
                this.disassemble();
                this.sendData();
            }
        }
        if (firePowered != prevFirePowered) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)CannonMountBlock.FIRE_POWERED, (Comparable)Boolean.valueOf(firePowered)), 3);
        }
        if (this.running && this.mountedContraption != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            ((AbstractMountedCannonContraption)this.mountedContraption.getContraption()).onRedstoneUpdate(slevel, this.mountedContraption, firePowered != prevFirePowered, firePower, this);
        }
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.running && this.mountedContraption != null) {
            this.sendData();
        }
    }

    public float getPitchOffset(float partialTicks) {
        if (this.isVirtual()) {
            return Mth.m_14179_((float)(partialTicks + 0.5f), (float)this.prevPitch, (float)this.cannonPitch);
        }
        if (this.mountedContraption == null || this.mountedContraption.isStalled() || !this.running) {
            partialTicks = 0.0f;
        }
        float aSpeed = this.getAngularSpeed(() -> ((CannonMountBlockEntity)this).getSpeed(), this.clientPitchDiff);
        return Mth.m_14179_((float)partialTicks, (float)this.cannonPitch, (float)(this.cannonPitch + aSpeed));
    }

    public void setPitch(float pitch) {
        this.cannonPitch = pitch;
    }

    public float getYawSpeed() {
        return this.overStressed ? 0.0f : this.getTheoreticalYawSpeed();
    }

    public float getTheoreticalYawSpeed() {
        return this.yawSpeed;
    }

    public float getYawOffset(float partialTicks) {
        if (this.isVirtual()) {
            return Mth.m_14179_((float)(partialTicks + 0.5f), (float)this.prevYaw, (float)this.cannonYaw);
        }
        if (this.mountedContraption == null || this.mountedContraption.isStalled() || !this.running) {
            partialTicks = 0.0f;
        }
        float aSpeed = this.getAngularSpeed(this::getYawSpeed, this.clientYawDiff);
        return Mth.m_14179_((float)partialTicks, (float)this.cannonYaw, (float)(this.cannonYaw + aSpeed));
    }

    public void setYaw(float yaw) {
        this.cannonYaw = yaw;
    }

    public Direction getContraptionDirection() {
        return this.mountedContraption == null ? Direction.NORTH : ((AbstractMountedCannonContraption)this.mountedContraption.getContraption()).initialOrientation();
    }

    public float getAngularSpeed(Supplier<Float> sup, float clientDiff) {
        float speed = CannonMountBlockEntity.convertToAngular((float)sup.get().floatValue()) * 0.125f;
        if (sup.get().floatValue() == 0.0f) {
            speed = 0.0f;
        }
        if (this.f_58857_.f_46443_) {
            speed *= ServerSpeedProvider.get();
            speed += clientDiff / 3.0f;
        }
        return speed;
    }

    protected void assemble() throws AssemblyException {
        PitchOrientedContraptionEntity contraptionEntity;
        if (!CBCBlocks.CANNON_MOUNT.has(this.m_58900_())) {
            return;
        }
        BlockPos assemblyPos = this.f_58858_.m_6630_(2);
        if (this.f_58857_.m_151570_(assemblyPos)) {
            throw CannonMountBlockEntity.cannonBlockOutsideOfWorld(assemblyPos);
        }
        AbstractMountedCannonContraption mountedCannon = this.getContraption(assemblyPos);
        if (mountedCannon == null || !mountedCannon.assemble(this.f_58857_, assemblyPos)) {
            return;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)CannonMountBlock.HORIZONTAL_FACING);
        Direction facing1 = mountedCannon.initialOrientation();
        if (facing.m_122434_() != facing1.m_122434_() && facing1.m_122434_().m_122479_()) {
            return;
        }
        this.running = true;
        mountedCannon.removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
        this.mountedContraption = contraptionEntity = PitchOrientedContraptionEntity.create(this.f_58857_, (Contraption)mountedCannon, facing1, this);
        this.resetContraptionToOffset();
        this.f_58857_.m_7967_((Entity)contraptionEntity);
        this.sendData();
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
    }

    private AbstractMountedCannonContraption getContraption(BlockPos pos) {
        Block block = this.f_58857_.m_8055_(pos).m_60734_();
        if (block instanceof BigCannonBlock) {
            return new MountedBigCannonContraption();
        }
        if (block instanceof AutocannonBlock) {
            return new MountedAutocannonContraption();
        }
        return null;
    }

    @Override
    public void disassemble() {
        if (!this.running && this.mountedContraption == null) {
            return;
        }
        if (this.mountedContraption != null) {
            this.resetContraptionToOffset();
            this.mountedContraption.m_20223_(new CompoundTag());
            this.mountedContraption.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
        }
        this.running = false;
        if (this.f_58859_) {
            ((CannonMountBlock)((Object)CBCBlocks.CANNON_MOUNT.get())).m_5707_(this.f_58857_, this.f_58858_, this.m_58900_(), null);
        }
    }

    protected void resetContraptionToOffset() {
        if (this.mountedContraption == null) {
            return;
        }
        this.cannonPitch = 0.0f;
        this.cannonYaw = this.getContraptionDirection().m_122435_();
        this.prevPitch = this.cannonPitch;
        this.prevYaw = this.cannonYaw;
        this.mountedContraption.pitch = this.cannonPitch;
        this.mountedContraption.yaw = this.cannonYaw;
        this.mountedContraption.prevPitch = this.mountedContraption.pitch;
        this.mountedContraption.prevYaw = this.mountedContraption.yaw;
        this.mountedContraption.m_146926_(this.cannonPitch);
        this.mountedContraption.m_146922_(this.cannonYaw);
        this.mountedContraption.f_19860_ = this.mountedContraption.m_146909_();
        this.mountedContraption.f_19859_ = this.mountedContraption.m_146908_();
        Vec3 vec = Vec3.m_82539_((Vec3i)this.f_58858_.m_6630_(2));
        this.mountedContraption.m_146884_(vec);
    }

    public float calculateStressApplied() {
        if (this.running && this.mountedContraption != null) {
            AbstractMountedCannonContraption contraption = (AbstractMountedCannonContraption)this.mountedContraption.getContraption();
            return contraption.getWeightForStress();
        }
        return 0.0f;
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128379_("Running", this.running);
        tag.m_128350_("CannonYaw", this.cannonYaw);
        tag.m_128350_("CannonPitch", this.cannonPitch);
        tag.m_128350_("YawSpeed", this.yawSpeed);
        AssemblyException.write((CompoundTag)tag, (AssemblyException)this.lastException);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        boolean oldRunning = this.running;
        this.running = tag.m_128471_("Running");
        this.cannonYaw = tag.m_128457_("CannonYaw");
        this.cannonPitch = tag.m_128457_("CannonPitch");
        this.lastException = AssemblyException.read((CompoundTag)tag);
        this.yawSpeed = tag.m_128457_("YawSpeed");
        if (!clientPacket) {
            return;
        }
        if (!oldRunning) {
            boolean bl = false;
        }
        if (this.running) {
            if (oldRunning && (this.mountedContraption == null || !this.mountedContraption.isStalled())) {
                this.clientYawDiff = AngleHelper.getShortestAngleDiff((double)this.prevYaw, (double)this.cannonYaw);
                this.clientPitchDiff = AngleHelper.getShortestAngleDiff((double)this.prevPitch, (double)this.cannonPitch);
                this.prevYaw = this.cannonYaw;
                this.prevPitch = this.cannonPitch;
            }
        } else {
            this.mountedContraption = null;
        }
    }

    public void remove() {
        this.f_58859_ = true;
        if (!this.f_58857_.f_46443_) {
            this.disassemble();
        }
        super.remove();
    }

    @Override
    public boolean isAttachedTo(AbstractContraptionEntity entity) {
        return this.mountedContraption == entity;
    }

    @Override
    public void attach(PitchOrientedContraptionEntity contraption) {
        if (!(contraption.getContraption() instanceof AbstractMountedCannonContraption)) {
            return;
        }
        this.mountedContraption = contraption;
        if (!this.f_58857_.f_46443_) {
            this.running = true;
            this.sendData();
        }
    }

    @Override
    public void onStall() {
        if (!this.f_58857_.f_46443_) {
            this.sendData();
        }
    }

    @Override
    public BlockPos getControllerBlockPos() {
        return this.f_58858_;
    }

    @Override
    public BlockPos getDismountPositionForContraption(PitchOrientedContraptionEntity poce) {
        return this.f_58858_.m_121945_(this.mountedContraption.getInitialOrientation().m_122424_()).m_7494_();
    }

    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    public static AssemblyException cannonBlockOutsideOfWorld(BlockPos pos) {
        return new AssemblyException((Component)Component.m_237110_((String)"exception.createbigcannons.cannon_mount.cannonBlockOutsideOfWorld", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
    }

    public Vec3 getInteractionLocation() {
        Vec3 vec3;
        Contraption contraption;
        if (this.mountedContraption != null && (contraption = this.mountedContraption.getContraption()) instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
            vec3 = cannon.getInteractionVec(this.mountedContraption);
        } else {
            vec3 = Vec3.m_82512_((Vec3i)this.f_58858_);
        }
        return vec3;
    }

    @Nullable
    public PitchOrientedContraptionEntity getContraption() {
        return this.mountedContraption;
    }
}

