/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.teamabnormals.blueprint.client.ChestManager;
import com.teamabnormals.blueprint.core.api.IChestBlock;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Calendar;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public class BlueprintChestBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    public static Block itemBlock = null;
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private final ModelPart doubleLeftLid;
    private final ModelPart doubleLeftBottom;
    private final ModelPart doubleLeftLock;
    private final ModelPart doubleRightLid;
    private final ModelPart doubleRightBottom;
    private final ModelPart doubleRightLock;
    public boolean isChristmas;

    public BlueprintChestBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.isChristmas = true;
        }
        ModelPart modelpart = context.m_173582_(ModelLayers.f_171275_);
        this.bottom = modelpart.m_171324_("bottom");
        this.lid = modelpart.m_171324_("lid");
        this.lock = modelpart.m_171324_("lock");
        ModelPart modelpart1 = context.m_173582_(ModelLayers.f_171133_);
        this.doubleLeftBottom = modelpart1.m_171324_("bottom");
        this.doubleLeftLid = modelpart1.m_171324_("lid");
        this.doubleLeftLock = modelpart1.m_171324_("lock");
        ModelPart modelpart2 = context.m_173582_(ModelLayers.f_171134_);
        this.doubleRightBottom = modelpart2.m_171324_("bottom");
        this.doubleRightLid = modelpart2.m_171324_("lid");
        this.doubleRightLock = modelpart2.m_171324_("lock");
    }

    public void m_6922_(T tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Level world = tileEntityIn.m_58904_();
        boolean flag = world != null;
        BlockState blockstate = flag ? tileEntityIn.m_58900_() : (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)blockstate.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
        Block block = blockstate.m_60734_();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)block;
            boolean flag1 = chesttype != ChestType.SINGLE;
            matrixStackIn.m_85836_();
            float f = ((Direction)blockstate.m_61143_((Property)ChestBlock.f_51478_)).m_122435_();
            matrixStackIn.m_85837_(0.5, 0.5, 0.5);
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(-f));
            matrixStackIn.m_85837_(-0.5, -0.5, -0.5);
            DoubleBlockCombiner.NeighborCombineResult icallbackwrapper = flag ? abstractchestblock.m_5641_(blockstate, world, tileEntityIn.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
            float f1 = ((Float2FloatFunction)icallbackwrapper.m_5649_(ChestBlock.m_51517_((LidBlockEntity)((LidBlockEntity)tileEntityIn)))).get(partialTicks);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)icallbackwrapper.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(combinedLightIn);
            VertexConsumer ivertexbuilder = this.getChestMaterial(tileEntityIn, chesttype).m_119194_(bufferIn, RenderType::m_110452_);
            if (flag1) {
                if (chesttype == ChestType.LEFT) {
                    this.render(matrixStackIn, ivertexbuilder, this.doubleLeftLid, this.doubleLeftLock, this.doubleLeftBottom, f1, i, combinedOverlayIn);
                } else {
                    this.render(matrixStackIn, ivertexbuilder, this.doubleRightLid, this.doubleRightLock, this.doubleRightBottom, f1, i, combinedOverlayIn);
                }
            } else {
                this.render(matrixStackIn, ivertexbuilder, this.lid, this.lock, this.bottom, f1, i, combinedOverlayIn);
            }
            matrixStackIn.m_85849_();
        }
    }

    public Material getChestMaterial(T t, ChestType type) {
        if (this.isChristmas) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case ChestType.SINGLE -> Sheets.f_110748_;
                case ChestType.LEFT -> Sheets.f_110749_;
                case ChestType.RIGHT -> Sheets.f_110750_;
            };
        }
        Block inventoryBlock = itemBlock;
        if (inventoryBlock == null) {
            inventoryBlock = t.m_58900_().m_60734_();
        }
        ChestManager.ChestInfo chestInfo = ChestManager.getInfoForChest(((IChestBlock)inventoryBlock).getChestType());
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ChestType.SINGLE -> {
                if (chestInfo != null) {
                    yield chestInfo.getSingleMaterial();
                }
                yield Sheets.f_110751_;
            }
            case ChestType.LEFT -> {
                if (chestInfo != null) {
                    yield chestInfo.getLeftMaterial();
                }
                yield Sheets.f_110752_;
            }
            case ChestType.RIGHT -> chestInfo != null ? chestInfo.getRightMaterial() : Sheets.f_110753_;
        };
    }

    public void render(PoseStack matrixStack, VertexConsumer builder, ModelPart chestLid, ModelPart chestLatch, ModelPart chestBottom, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
        chestLatch.f_104203_ = chestLid.f_104203_ = -(lidAngle * 1.5707964f);
        chestLid.m_104301_(matrixStack, builder, combinedLightIn, combinedOverlayIn);
        chestLatch.m_104301_(matrixStack, builder, combinedLightIn, combinedOverlayIn);
        chestBottom.m_104301_(matrixStack, builder, combinedLightIn, combinedOverlayIn);
    }
}

