/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import com.mojang.math.Vector3f;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.misc.AircraftProperties;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.item.upgrade.AircraftStat;
import immersive_aircraft.util.Utils;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AircraftEntity
extends InventoryVehicleEntity {
    private double lastY;
    private static final List<Trail> TRAILS = Collections.emptyList();
    final List<List<Vec3>> PASSENGER_POSITIONS = List.of(List.of(new Vec3(0.0, 0.0, 0.0)));

    public AircraftEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world);
    }

    public List<Trail> getTrails() {
        return TRAILS;
    }

    public abstract AircraftProperties getProperties();

    @Override
    protected List<List<Vec3>> getPassengerPositions() {
        return this.PASSENGER_POSITIONS;
    }

    @Override
    public void m_8119_() {
        this.prevRoll = this.roll;
        this.roll = this.f_19861_ ? (float)((double)this.roll * 0.9) : -this.pressingInterpolatedX.getSmooth() * this.getProperties().getRollFactor();
        if (Double.isNaN(this.m_20184_().f_82479_) || Double.isNaN(this.m_20184_().f_82480_) || Double.isNaN(this.m_20184_().f_82481_)) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        super.m_8119_();
    }

    protected void convertPower(Vec3 direction) {
        Vec3 velocity = this.m_20184_();
        double drag = Math.abs(direction.m_82526_(velocity.m_82541_()));
        this.m_20256_(velocity.m_82541_().m_165921_(direction, (double)this.getProperties().getLift()).m_82490_(velocity.m_82553_() * (drag * (double)this.getProperties().getDriftDrag() + (1.0 - (double)this.getProperties().getDriftDrag()))));
    }

    protected float getHorizontalVelocityDelay() {
        return 0.98f;
    }

    protected float getVerticalVelocityDelay() {
        return 0.98f;
    }

    protected float falloffGroundVelocityDecay(float original) {
        float gravity = Math.min(1.0f, Math.max(0.0f, this.getGravity() / -0.04f));
        float upgrade = Math.min(1.0f, this.getTotalUpgrade(AircraftStat.ACCELERATION) * 0.5f);
        return (original * gravity + (1.0f - gravity)) * (1.0f - upgrade) + upgrade;
    }

    protected float getGroundVelocityDecay() {
        return 0.95f;
    }

    protected float getRotationDecay() {
        return 0.98f;
    }

    @Override
    protected void updateVelocity() {
        float decay = 1.0f - 0.015f * this.getTotalUpgrade(AircraftStat.FRICTION);
        float gravity = this.getGravity();
        if (this.f_19798_) {
            gravity *= 0.25f;
            decay = 0.9f;
        } else if (this.f_19861_) {
            decay = this.m_20160_() ? this.getGroundVelocityDecay() : 0.75f;
        }
        Vec3 direction = this.getDirection();
        double diff = this.lastY - this.m_20186_();
        if (this.lastY != 0.0 && this.getProperties().getGlideFactor() > 0.0f) {
            this.m_20256_(this.m_20184_().m_82549_(direction.m_82490_(diff * (double)this.getProperties().getGlideFactor() * (1.0 - Math.abs(direction.m_7098_())))));
        }
        this.lastY = this.m_20186_();
        this.convertPower(direction);
        Vec3 velocity = this.m_20184_();
        this.m_20334_(velocity.f_82479_ * (double)decay * (double)this.getHorizontalVelocityDelay(), velocity.f_82480_ * (double)decay * (double)this.getVerticalVelocityDelay() + (double)gravity, velocity.f_82481_ * (double)decay * (double)this.getHorizontalVelocityDelay());
        this.pressingInterpolatedX.decay(0.0f, 1.0f - decay * this.getRotationDecay());
        this.pressingInterpolatedZ.decay(0.0f, 1.0f - decay * this.getRotationDecay());
        if (!this.f_19861_) {
            Vector3f effect = this.getWindEffect();
            this.m_146926_(this.m_146909_() + effect.m_122239_());
            this.m_146922_(this.m_146908_() + effect.m_122269_());
            float offsetStrength = 0.005f;
            this.m_20256_(this.m_20184_().m_82520_((double)(effect.m_122239_() * offsetStrength), 0.0, (double)(effect.m_122269_() * offsetStrength)));
        }
    }

    @Override
    public void chill() {
        this.lastY = 0.0;
    }

    public float getWindStrength() {
        float sensitivity = this.getProperties().getWindSensitivity();
        float thundering = this.f_19853_.m_46722_(0.0f);
        float raining = this.f_19853_.m_46661_(0.0f);
        float weather = (float)((double)Config.getInstance().windClearWeather + this.m_20184_().m_82553_() + (double)(thundering * Config.getInstance().windThunderWeather) + (double)(raining * Config.getInstance().windRainWeather));
        return weather * sensitivity;
    }

    public Vector3f getWindEffect() {
        float wind = this.getWindStrength();
        float nx = (float)(Utils.cosNoise((double)this.f_19797_ / 20.0 / (double)this.getProperties().getMass()) * (double)wind);
        float nz = (float)(Utils.cosNoise((double)this.f_19797_ / 21.0 / (double)this.getProperties().getMass()) * (double)wind);
        return new Vector3f(nx, 0.0f, nz);
    }
}

