/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import xerca.xercapaint.common.PaletteUtil;
import xerca.xercapaint.common.SoundEvents;

public abstract class BasePalette
extends Screen {
    protected static final ResourceLocation paletteTextures = new ResourceLocation("xercapaint", "textures/gui/palette.png");
    static final int dyeSpriteX = 240;
    static final int dyeSpriteSize = 16;
    static final int brushSpriteX = 0;
    static final int brushSpriteY = 247;
    static final int brushSpriteSize = 9;
    static final int brushOpacitySpriteX = 196;
    static final int brushOpacitySpriteY = 197;
    static final int brushOpacitySpriteSize = 14;
    static final int dropSpriteWidth = 6;
    static final int paletteWidth = 157;
    static final int paletteHeight = 193;
    static final int colorPickerSpriteX = 25;
    static final int colorPickerSpriteY = 242;
    static final int colorPickerPosX = 98;
    static final int colorPickerPosY = 62;
    static final int colorPickerSize = 14;
    static final double[] paletteXs = new double[]{-1000.0, -1000.0, -1000.0, -1000.0, -1000.0};
    static final double[] paletteYs = new double[]{-1000.0, -1000.0, -1000.0, -1000.0, -1000.0};
    double paletteX;
    double paletteY;
    static final PaletteUtil.Color waterColor = new PaletteUtil.Color(53, 118, 191);
    static final PaletteUtil.Color[] basicColors = new PaletteUtil.Color[]{new PaletteUtil.Color(-14869215), new PaletteUtil.Color(-5231066), new PaletteUtil.Color(-10585066), new PaletteUtil.Color(-8170446), new PaletteUtil.Color(-12827478), new PaletteUtil.Color(-7785800), new PaletteUtil.Color(-15295332), new PaletteUtil.Color(-6447721), new PaletteUtil.Color(-12103854), new PaletteUtil.Color(-816214), new PaletteUtil.Color(-8337633), new PaletteUtil.Color(-75715), new PaletteUtil.Color(-12930086), new PaletteUtil.Color(-3715395), new PaletteUtil.Color(-425955), new PaletteUtil.Color(-393218)};
    static final Vec2[] basicColorCenters = new Vec2[]{new Vec2(23.5f, 172.5f), new Vec2(18.5f, 145.5f), new Vec2(16.5f, 117.5f), new Vec2(17.5f, 89.5f), new Vec2(23.5f, 62.5f), new Vec2(38.5f, 39.5f), new Vec2(61.5f, 24.5f), new Vec2(87.5f, 17.5f), new Vec2(114.5f, 15.5f), new Vec2(44.5f, 154.5f), new Vec2(41.5f, 127.5f), new Vec2(42.5f, 100.5f), new Vec2(48.5f, 74.5f), new Vec2(64.5f, 52.5f), new Vec2(90.5f, 44.5f), new Vec2(117.5f, 42.5f)};
    static final Vec2[] customColorCenters = new Vec2[]{new Vec2(101.5f, 132.0f), new Vec2(113.5f, 118.0f), new Vec2(120.5f, 102.0f), new Vec2(124.5f, 84.0f), new Vec2(126.5f, 66.0f), new Vec2(97.5f, 152.0f), new Vec2(114.5f, 146.0f), new Vec2(127.5f, 133.0f), new Vec2(134.5f, 116.0f), new Vec2(139.5f, 98.0f), new Vec2(142.5f, 80.0f), new Vec2(144.5f, 62.0f)};
    static final Vec2 waterCenter = new Vec2(140.5f, 28.0f);
    static final float basicColorRadius = 11.0f;
    static final float customColorRadius = 6.5f;
    boolean isPickingColor;
    boolean isCarryingColor;
    boolean isCarryingWater;
    boolean canvasDirty;
    boolean paletteDirty;
    PaletteUtil.Color carriedColor;
    int carriedCustomColorId;
    static PaletteUtil.Color currentColor = basicColors[0];
    final PaletteUtil.CustomColor[] customColors;
    final boolean[] basicColorFlags;
    boolean paletteComplete;
    boolean isCarryingPalette;

    BasePalette(Component titleIn, CompoundTag paletteTag) {
        block6: {
            block5: {
                super(titleIn);
                this.isPickingColor = false;
                this.isCarryingColor = false;
                this.isCarryingWater = false;
                this.canvasDirty = false;
                this.paletteDirty = false;
                this.carriedCustomColorId = -1;
                this.paletteComplete = false;
                this.isCarryingPalette = false;
                this.customColors = new PaletteUtil.CustomColor[12];
                this.basicColorFlags = new boolean[16];
                if (paletteTag == null || paletteTag.m_128456_()) break block5;
                if (paletteTag.m_128441_("r") && paletteTag.m_128441_("g") && paletteTag.m_128441_("b") && paletteTag.m_128441_("m") && paletteTag.m_128441_("n")) {
                    PaletteUtil.readCustomColorArrayFromNBT(paletteTag, this.customColors);
                } else {
                    for (int i = 0; i < this.customColors.length; ++i) {
                        this.customColors[i] = new PaletteUtil.CustomColor();
                    }
                }
                if (!paletteTag.m_128441_("basic")) break block6;
                this.paletteComplete = true;
                byte[] basics = paletteTag.m_128463_("basic");
                for (int i = 0; i < basics.length; ++i) {
                    this.basicColorFlags[i] = basics[i] > 0;
                    this.paletteComplete &= this.basicColorFlags[i];
                }
                break block6;
            }
            for (int i = 0; i < this.customColors.length; ++i) {
                this.customColors[i] = new PaletteUtil.CustomColor();
            }
        }
    }

    protected void superRender(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void m_6305_(@NotNull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int y;
        int x;
        int i;
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.m_157456_((int)0, (ResourceLocation)paletteTextures);
        for (i = 0; i < this.basicColorFlags.length; ++i) {
            x = (int)this.paletteX + (int)BasePalette.basicColorCenters[i].f_82470_;
            y = (int)this.paletteY + (int)BasePalette.basicColorCenters[i].f_82471_;
            int r = 11;
            if (this.basicColorFlags[i]) {
                BasePalette.m_93172_((PoseStack)matrixStack, (int)(x - r), (int)(y - r), (int)(x + r + 1), (int)(y + r + 1), (int)basicColors[i].rgbVal());
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.m_93228_(matrixStack, x - 8, y - 8, 240, i * 16, 16, 16);
                continue;
            }
            BasePalette.m_93172_((PoseStack)matrixStack, (int)(x - r), (int)(y - r), (int)(x + r + 1), (int)(y + r + 1), (int)PaletteUtil.emptinessColor.rgbVal());
        }
        for (i = 0; i < this.customColors.length; ++i) {
            x = (int)this.paletteX + (int)BasePalette.customColorCenters[i].f_82470_;
            y = (int)this.paletteY + (int)BasePalette.customColorCenters[i].f_82471_;
            BasePalette.m_93172_((PoseStack)matrixStack, (int)(x - 6), (int)(y - 7), (int)(x + 7), (int)(y + 6), (int)this.customColors[i].getColor().rgbVal());
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93228_(matrixStack, (int)this.paletteX, (int)this.paletteY, 0, 0, 157, 193);
        if (this.paletteComplete) {
            this.m_93228_(matrixStack, (int)this.paletteX + 98, (int)this.paletteY + 62, 25, 242, 14, 14);
        }
    }

    protected boolean superMouseClicked(double posX, double posY, int mouseButton) {
        return super.m_6375_(posX, posY, mouseButton);
    }

    protected boolean superMouseReleased(double posX, double posY, int mouseButton) {
        return super.m_6348_(posX, posY, mouseButton);
    }

    protected boolean superMouseDragged(double posX, double posY, int mouseButton, double deltaX, double deltaY) {
        return super.m_7979_(posX, posY, mouseButton, deltaX, deltaY);
    }

    public boolean m_6375_(double posX, double posY, int mouseButton) {
        int mouseY;
        int mouseX = (int)Math.round(posX);
        if (this.paletteClick(mouseX, mouseY = (int)Math.round(posY))) {
            int i;
            int x = mouseX - (int)this.paletteX;
            int y = mouseY - (int)this.paletteY;
            Vec2 clickVec = new Vec2((float)x, (float)y);
            float sqrBasicRadius = 121.0f;
            float sqrCustomRadius = 42.25f;
            boolean didSomething = false;
            for (i = 0; i < basicColorCenters.length; ++i) {
                if (!this.basicColorFlags[i] || !(this.sqrDist(clickVec, basicColorCenters[i]) <= sqrBasicRadius)) continue;
                if (mouseButton == 0) {
                    this.carriedColor = currentColor = basicColors[i];
                    this.setCarryingColor();
                    this.playSound((SoundEvent)SoundEvents.MIX.get(), 0.6f);
                }
                didSomething = true;
                break;
            }
            if (!didSomething) {
                for (i = 0; i < customColorCenters.length; ++i) {
                    if (!(this.sqrDist(clickVec, customColorCenters[i]) <= sqrCustomRadius)) continue;
                    if (mouseButton == 0 && this.customColors[i].getNumberOfColors() > 0) {
                        this.carriedColor = currentColor = this.customColors[i].getColor();
                        this.carriedCustomColorId = i;
                        this.setCarryingColor();
                        this.playSound((SoundEvent)SoundEvents.MIX.get(), 0.3f);
                    }
                    didSomething = true;
                    break;
                }
            }
            if (!didSomething && this.sqrDist(clickVec, waterCenter) <= sqrCustomRadius && mouseButton == 0) {
                this.setCarryingWater();
                this.playSound((SoundEvent)SoundEvents.WATER.get());
                didSomething = true;
            }
            if (!didSomething && this.paletteComplete && !this.isCarryingWater && !this.isCarryingColor && this.inColorPicker(x, y) && mouseButton == 0) {
                this.setPickingColor();
                this.playSound((SoundEvent)SoundEvents.COLOR_PICKER.get());
                didSomething = true;
            }
            if (!didSomething) {
                this.isCarryingPalette = true;
            }
        }
        return super.m_6375_((double)mouseX, (double)mouseY, mouseButton);
    }

    protected boolean inColorPicker(int x, int y) {
        return x >= 98 && x < 112 && y >= 62 && y < 76;
    }

    protected boolean inWater(int x, int y) {
        return this.sqrDist(new Vec2((float)x, (float)y), waterCenter) <= 42.25f;
    }

    public boolean m_7979_(double posX, double posY, int mouseButton, double deltaX, double deltaY) {
        return super.m_7979_(posX, posY, mouseButton, deltaX, deltaY);
    }

    protected void setCarryingWater() {
        this.isCarryingWater = true;
        this.isCarryingColor = false;
        this.isPickingColor = false;
    }

    protected void setCarryingColor() {
        this.isCarryingWater = false;
        this.isCarryingColor = true;
        this.isPickingColor = false;
    }

    protected void setPickingColor() {
        this.isCarryingWater = false;
        this.isCarryingColor = false;
        this.isPickingColor = true;
    }

    public boolean m_6348_(double posX, double posY, int mouseButton) {
        int mouseX = (int)Math.round(posX);
        int mouseY = (int)Math.round(posY);
        if (this.isCarryingColor || this.isCarryingWater) {
            if (this.paletteClick(mouseX, mouseY)) {
                float sqrCustomRadius = 42.25f;
                int x = mouseX - (int)this.paletteX;
                int y = mouseY - (int)this.paletteY;
                Vec2 clickVec = new Vec2((float)x, (float)y);
                for (int i = 0; i < customColorCenters.length; ++i) {
                    if (!(this.sqrDist(clickVec, customColorCenters[i]) <= sqrCustomRadius)) continue;
                    PaletteUtil.CustomColor customColor = this.customColors[i];
                    if (this.isCarryingWater) {
                        customColor.reset();
                        this.playSound((SoundEvent)SoundEvents.WATER_DROP.get());
                    } else if (this.carriedCustomColorId != i) {
                        customColor.mix(this.carriedColor);
                        currentColor = customColor.getColor();
                        this.playSound((SoundEvent)SoundEvents.MIX.get());
                    }
                    this.paletteDirty = true;
                    break;
                }
            }
            this.isCarryingColor = false;
            this.isCarryingWater = false;
            this.carriedCustomColorId = -1;
        }
        this.isCarryingPalette = false;
        return super.m_6348_(posX, posY, mouseButton);
    }

    protected void playSound(SoundInstance sound) {
        Minecraft.m_91087_().m_91106_().m_120367_(sound);
    }

    protected void playSound(SoundEvent soundEvent) {
        this.playSound(soundEvent, 1.0f);
    }

    protected void playSound(SoundEvent soundEvent, float volume) {
        Minecraft m = Minecraft.m_91087_();
        if (m.f_91073_ != null && m.f_91074_ != null) {
            m.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(soundEvent, SoundSource.MASTER, volume, 0.8f + m.f_91073_.f_46441_.m_188501_() * 0.4f, m.f_91074_.m_217043_(), m.f_91074_.m_20183_()));
        }
    }

    public boolean m_7043_() {
        return false;
    }

    boolean paletteClick(int x, int y) {
        return (double)x <= this.paletteX + 157.0 && (double)x >= this.paletteX && (double)y <= this.paletteY + 193.0 && (double)y >= this.paletteY;
    }

    float sqrDist(Vec2 a, Vec2 b) {
        return (a.f_82470_ - b.f_82470_) * (a.f_82470_ - b.f_82470_) + (a.f_82471_ - b.f_82471_) * (a.f_82471_ - b.f_82471_);
    }
}

