/*
 * Decompiled with CFR 0.152.
 */
package com.tynoxs.buildersdelight.content.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.tynoxs.buildersdelight.content.recipe.ChiselRecipe;
import com.tynoxs.buildersdelight.content.recipe.ChiselRecipeFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Unit;
import org.slf4j.Logger;

public class ClientChiselRecipeFactory {
    private static final CompletableFuture<Unit> RESOURCE_RELOAD_INITIAL_TASK = CompletableFuture.completedFuture(Unit.INSTANCE);
    private static final Logger LOGGER = LogUtils.getLogger();
    private Minecraft minecraft;
    private ChiselRecipeFactory recipeFactory;
    private Gson gson;

    public ClientChiselRecipeFactory(ChiselRecipeFactory recipeFactory) {
        this.recipeFactory = recipeFactory;
        this.minecraft = Minecraft.m_91087_();
        this.gson = new GsonBuilder().setPrettyPrinting().setPrettyPrinting().create();
    }

    public void loadClientRecipes() {
        ReloadableResourceManager resourceManager = new ReloadableResourceManager(PackType.SERVER_DATA);
        List list = this.minecraft.m_91099_().m_10525_();
        ReloadInstance reloadInstance = resourceManager.m_142463_((Executor)Util.m_183991_(), (Executor)this.minecraft, RESOURCE_RELOAD_INITIAL_TASK, list);
        while (!reloadInstance.m_7746_()) {
        }
        this.recipeFactory.clear();
        for (Map.Entry location : resourceManager.m_214159_("chisel", p_10774_ -> p_10774_.m_135815_().endsWith(".json")).entrySet()) {
            try {
                Optional resource = resourceManager.m_213713_((ResourceLocation)location.getKey());
                InputStream inputstream = ((Resource)resource.get()).m_215507_();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                    JsonElement jsonelement = (JsonElement)GsonHelper.m_13776_((Gson)this.gson, (Reader)reader, JsonElement.class);
                    try {
                        ChiselRecipe recipe = ChiselRecipeFactory.fromJson((ResourceLocation)location.getKey(), GsonHelper.m_13918_((JsonElement)jsonelement, (String)"top element"));
                        if (recipe == null) {
                            LOGGER.info("Skipping loading recipe {} as it's serializer returned null", location);
                            continue;
                        }
                        this.recipeFactory.getChiselRecipes().add(recipe);
                    }
                    catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                        LOGGER.error("Parsing error loading recipe {}", location, (Object)jsonparseexception);
                    }
                }
                catch (Throwable throwable4) {
                    if (inputstream != null) {
                        try {
                            inputstream.close();
                        }
                        catch (Throwable throwable1) {
                            throwable4.addSuppressed(throwable1);
                        }
                    }
                    throw throwable4;
                }
                if (inputstream == null) continue;
                inputstream.close();
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                LOGGER.error("Couldn't parse data file {}", location, (Object)jsonparseexception);
            }
        }
    }
}

