/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.brew;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.BrewItem;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class BaseBrewItem
extends Item
implements BrewItem {
    private static final String TAG_BREW_KEY = "brewKey";
    private static final String TAG_SWIGS_LEFT = "swigsLeft";
    private final int swigs;
    private final int drinkSpeed;
    private final Supplier<Item> baseItem;

    public BaseBrewItem(Item.Properties builder, int swigs, int drinkSpeed, Supplier<Item> baseItem) {
        super(builder);
        this.swigs = swigs;
        this.drinkSpeed = drinkSpeed;
        this.baseItem = baseItem;
    }

    public int m_8105_(ItemStack stack) {
        return this.drinkSpeed;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        return ItemUtils.m_150959_((Level)world, (Player)player, (InteractionHand)hand);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, Level world, LivingEntity living) {
        if (!world.f_46443_) {
            for (MobEffectInstance effect : this.getBrew(stack).getPotionEffects(stack)) {
                MobEffectInstance newEffect = new MobEffectInstance(effect.m_19544_(), effect.m_19557_(), effect.m_19564_(), true, true);
                if (effect.m_19544_().m_8093_()) {
                    effect.m_19544_().m_19461_((Entity)living, (Entity)living, living, newEffect.m_19564_(), 1.0);
                    continue;
                }
                living.m_7292_(newEffect);
            }
            if (world.f_46441_.m_188499_()) {
                world.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            int swigs = this.getSwigsLeft(stack);
            if (living instanceof Player) {
                Player player = (Player)living;
                if (!player.m_150110_().f_35937_) {
                    if (swigs == 1) {
                        ItemStack result = this.getBaseStack();
                        if (!player.m_150109_().m_36054_(result)) {
                            return result;
                        }
                        return ItemStack.f_41583_;
                    }
                    this.setSwigsLeft(stack, swigs - 1);
                }
            }
        }
        return stack;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> list) {
        if (this.m_220152_(tab)) {
            for (Brew brew : BotaniaAPI.instance().getBrewRegistry()) {
                if (brew == BotaniaBrews.fallbackBrew) continue;
                ItemStack stack = new ItemStack((ItemLike)this);
                BaseBrewItem.setBrew(stack, brew);
                list.add((Object)stack);
            }
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return Component.m_237110_((String)this.m_5524_(), (Object[])new Object[]{Component.m_237115_((String)this.getBrew(stack).getTranslationKey(stack)), Component.m_237113_((String)Integer.toString(this.getSwigsLeft(stack))).m_130940_(ChatFormatting.BOLD)});
    }

    public static void addPotionTooltip(List<MobEffectInstance> list, List<Component> lores, float durationFactor) {
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            lores.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        } else {
            for (MobEffectInstance effectinstance : list) {
                MutableComponent iformattabletextcomponent = Component.m_237115_((String)effectinstance.m_19576_());
                MobEffect effect = effectinstance.m_19544_();
                Map map = effect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), effect.m_7048_(effectinstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                        list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.m_19564_() > 0) {
                    iformattabletextcomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{iformattabletextcomponent, Component.m_237115_((String)("potion.potency." + effectinstance.m_19564_()))});
                }
                if (effectinstance.m_19557_() > 20) {
                    iformattabletextcomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{iformattabletextcomponent, MobEffectUtil.m_19581_((MobEffectInstance)effectinstance, (float)durationFactor)});
                }
                lores.add((Component)iformattabletextcomponent.m_130940_(effect.m_19483_().m_19497_()));
            }
        }
        if (!list1.isEmpty()) {
            lores.add((Component)Component.m_237119_());
            lores.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.m_22218_();
                double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    lores.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        BaseBrewItem.addPotionTooltip(this.getBrew(stack).getPotionEffects(stack), list, 1.0f);
    }

    @Override
    public Brew getBrew(ItemStack stack) {
        String key = ItemNBTHelper.getString(stack, TAG_BREW_KEY, "");
        return (Brew)BotaniaAPI.instance().getBrewRegistry().m_7745_(ResourceLocation.m_135820_((String)key));
    }

    public static void setBrew(ItemStack stack, @Nullable Brew brew) {
        ResourceLocation id = brew != null ? BotaniaAPI.instance().getBrewRegistry().m_7981_((Object)brew) : ResourceLocationHelper.prefix("fallback");
        BaseBrewItem.setBrew(stack, id);
    }

    public static void setBrew(ItemStack stack, ResourceLocation brew) {
        ItemNBTHelper.setString(stack, TAG_BREW_KEY, brew.toString());
    }

    @NotNull
    public static String getSubtype(ItemStack stack) {
        return stack.m_41782_() ? ItemNBTHelper.getString(stack, TAG_BREW_KEY, "none") : "none";
    }

    public int getSwigs() {
        return this.swigs;
    }

    public int getSwigsLeft(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_SWIGS_LEFT, this.swigs);
    }

    public void setSwigsLeft(ItemStack stack, int swigs) {
        ItemNBTHelper.setInt(stack, TAG_SWIGS_LEFT, swigs);
    }

    public ItemStack getBaseStack() {
        return new ItemStack((ItemLike)this.baseItem.get());
    }
}

