/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class EnderAirBottleEntity
extends ThrowableProjectile
implements ItemSupplier {
    public static final int PARTICLE_COLOR = 8;
    private static final ResourceLocation GHAST_LOOT_TABLE = ResourceLocationHelper.prefix("ghast_ender_air_crying");

    public EnderAirBottleEntity(EntityType<EnderAirBottleEntity> type, Level world) {
        super(type, world);
    }

    public EnderAirBottleEntity(LivingEntity entity, Level world) {
        super(BotaniaEntities.ENDER_AIR_BOTTLE, entity, world);
    }

    public EnderAirBottleEntity(double x, double y, double z, Level world) {
        super(BotaniaEntities.ENDER_AIR_BOTTLE, x, y, z, world);
    }

    private void convertBlock(@NotNull BlockPos pos) {
        List<BlockPos> coordsList = this.getCoordsToPut(pos);
        this.m_9236_().m_46796_(2002, this.m_20183_(), 8);
        for (BlockPos coords : coordsList) {
            this.m_9236_().m_46597_(coords, Blocks.f_50259_.m_49966_());
            if (!(Math.random() < 0.1)) continue;
            this.m_9236_().m_46796_(2001, coords, Block.m_49956_((BlockState)Blocks.f_50259_.m_49966_()));
        }
    }

    protected void m_8060_(@NotNull BlockHitResult result) {
        super.m_8060_(result);
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.convertBlock(result.m_82425_());
        this.m_146870_();
    }

    protected void m_5790_(@NotNull EntityHitResult result) {
        super.m_5790_(result);
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity entity = result.m_82443_();
        if (entity.m_6095_() == EntityType.f_20453_ && this.m_9236_().m_46472_() == Level.f_46428_) {
            this.m_9236_().m_46796_(2002, this.m_20183_(), 8);
            DamageSource source = DamageSource.m_19361_((Entity)this, (Entity)this.m_37282_());
            entity.m_6469_(source, 0.0f);
            Vec3 lookVec = entity.m_20154_();
            Vec3 vec = new Vec3(lookVec.m_7096_(), 0.0, lookVec.m_7094_()).m_82541_();
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42586_)), entity.m_20185_() + 2.3 * vec.f_82479_, entity.m_20186_() + vec.f_82480_ + 2.6, entity.m_20189_() + 2.3 * vec.f_82481_, 40, Math.abs(vec.f_82481_) + 0.15, 0.2, Math.abs(vec.f_82479_) + 0.15, 0.2);
            LootTable table = this.m_9236_().m_7654_().m_129898_().m_79217_(GHAST_LOOT_TABLE);
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.m_9236_());
            builder.m_78972_(LootContextParams.f_81455_, (Object)entity);
            builder.m_78972_(LootContextParams.f_81460_, (Object)entity.m_20182_());
            builder.m_78972_(LootContextParams.f_81457_, (Object)source);
            LootContext context = builder.m_78975_(LootContextParamSets.f_81415_);
            for (ItemStack stack : table.m_230922_(context)) {
                ItemEntity item = entity.m_5552_(stack, 2.0f);
                item.m_20256_(item.m_20184_().m_82549_(vec.m_82490_(0.4)));
            }
        } else {
            this.convertBlock(new BlockPos(result.m_82450_()));
        }
        this.m_146870_();
    }

    private List<BlockPos> getCoordsToPut(BlockPos pos) {
        ArrayList<BlockPos> possibleCoords = new ArrayList<BlockPos>();
        int range = 4;
        int rangeY = 4;
        for (BlockPos bPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-range, -rangeY, -range), (BlockPos)pos.m_7918_(range, rangeY, range))) {
            BlockState state = this.m_9236_().m_8055_(bPos);
            if (!state.m_204336_(BotaniaTags.Blocks.ENDER_AIR_CONVERTABLE)) continue;
            possibleCoords.add(bPos.m_7949_());
        }
        Collections.shuffle(possibleCoords);
        if (possibleCoords.size() > 64) {
            return possibleCoords.subList(0, 64);
        }
        return possibleCoords;
    }

    protected void m_8097_() {
    }

    @NotNull
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)BotaniaItems.enderAirBottle);
    }
}

