/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.crafting.recipe.RecipeUtils;
import vazkii.botania.common.item.BotaniaItems;

public class SpellbindingClothRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<SpellbindingClothRecipe> SERIALIZER = new SimpleRecipeSerializer(SpellbindingClothRecipe::new);

    public SpellbindingClothRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        boolean foundCloth = false;
        boolean foundEnchanted = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41793_() && !foundEnchanted) {
                foundEnchanted = true;
                continue;
            }
            if (stack.m_150930_(BotaniaItems.spellCloth) && !foundCloth) {
                foundCloth = true;
                continue;
            }
            return false;
        }
        return foundCloth && foundEnchanted;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv) {
        ItemStack stackToDisenchant = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !stack.m_41793_() || stack.m_150930_(BotaniaItems.spellCloth)) continue;
            stackToDisenchant = stack.m_41777_();
            stackToDisenchant.m_41764_(1);
            break;
        }
        if (stackToDisenchant.m_41619_()) {
            return ItemStack.f_41583_;
        }
        stackToDisenchant.m_41749_("Enchantments");
        stackToDisenchant.m_41749_("RepairCost");
        return stackToDisenchant;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer inv) {
        return RecipeUtils.getRemainingItemsSub((Container)inv, s -> {
            if (s.m_150930_(BotaniaItems.spellCloth)) {
                ItemStack copy = s.m_41777_();
                copy.m_41764_(1);
                copy.m_41721_(copy.m_41773_() + 1);
                return copy;
            }
            return null;
        });
    }
}

