/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.flower.functional.SpectranthemumBlockEntity;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.internal_caps.ItemFlagsComponent;
import vazkii.botania.xplat.XplatAbstractions;

public class HopperhockBlockEntity
extends FunctionalFlowerBlockEntity
implements Wandable {
    private static final String TAG_FILTER_TYPE = "filterType";
    private static final int RANGE_MANA = 10;
    private static final int RANGE = 6;
    private static final int RANGE_MANA_MINI = 2;
    private static final int RANGE_MINI = 1;
    private int filterType = 0;

    protected HopperhockBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public HopperhockBlockEntity(BlockPos pos, BlockState state) {
        this(BotaniaFlowerBlocks.HOPPERHOCK, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().f_46443_ || this.redstoneSignal > 0) {
            return;
        }
        boolean pulledAny = false;
        int range = this.getRange();
        BlockPos inPos = this.m_58899_();
        BlockPos outPos = this.getEffectivePos();
        Predicate<ItemEntity> shouldPickup = item -> {
            if (XplatAbstractions.INSTANCE.preventsRemoteMovement((ItemEntity)item)) {
                return false;
            }
            ItemFlagsComponent flags = XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item);
            int runicAltarCooldown = flags.getRunicAltarCooldown();
            if (runicAltarCooldown > 0) {
                return runicAltarCooldown <= 20;
            }
            int manaInfusionCooldown = flags.getManaInfusionCooldown();
            if (manaInfusionCooldown > 0) {
                return manaInfusionCooldown <= 20;
            }
            return DelayHelper.canInteractWith(this, item);
        };
        List items = this.m_58904_().m_6443_(ItemEntity.class, new AABB(inPos.m_7918_(-range, -range, -range), inPos.m_7918_(range + 1, range + 1, range + 1)), shouldPickup);
        for (ItemEntity item2 : items) {
            ItemStack stack = item2.m_32055_();
            boolean priorityInv = false;
            int amountToPutIn = 0;
            Direction direction = null;
            for (Direction dir : Direction.values()) {
                boolean priority;
                Direction sideOfInventory;
                BlockPos inventoryPos = outPos.m_121945_(dir);
                if (!XplatAbstractions.INSTANCE.hasInventory(this.f_58857_, inventoryPos, sideOfInventory = dir.m_122424_())) continue;
                List<ItemStack> filter = HopperhockBlockEntity.getFilterForInventory(this.m_58904_(), inventoryPos, true);
                boolean canAccept = HopperhockBlockEntity.canAcceptItem(stack, filter, this.filterType);
                ItemStack simulate = XplatAbstractions.INSTANCE.insertToInventory(this.f_58857_, inventoryPos, sideOfInventory, stack, true);
                int inserted = stack.m_41613_() - simulate.m_41613_();
                boolean bl = canAccept = canAccept && inserted > 0;
                if (!canAccept) continue;
                boolean bl2 = priority = !filter.isEmpty();
                if (priorityInv && !priority) continue;
                priorityInv = priority;
                amountToPutIn = inserted;
                direction = dir;
            }
            if (direction == null || !item2.m_6084_()) continue;
            SpectranthemumBlockEntity.spawnExplosionParticles((Entity)item2, 3);
            InventoryHelper.checkEmpty(XplatAbstractions.INSTANCE.insertToInventory(this.f_58857_, outPos.m_121945_(direction), direction.m_122424_(), stack.m_41620_(amountToPutIn), false));
            EntityHelper.syncItem(item2);
            pulledAny = true;
        }
        if (pulledAny && this.getMana() > 0) {
            this.addMana(-1);
        }
    }

    public static boolean canAcceptItem(ItemStack stack, List<ItemStack> filter, int filterType) {
        if (stack.m_41619_()) {
            return false;
        }
        if (filter.isEmpty()) {
            return true;
        }
        switch (filterType) {
            case 0: {
                boolean anyFilter = false;
                for (ItemStack filterEntry : filter) {
                    if (filterEntry == null || filterEntry.m_41619_()) continue;
                    anyFilter = true;
                    if (!ItemNBTHelper.matchTagAndManaFullness(stack, filterEntry)) continue;
                    return true;
                }
                return !anyFilter;
            }
            case 1: {
                return !HopperhockBlockEntity.canAcceptItem(stack, filter, 0);
            }
        }
        return true;
    }

    public static List<ItemStack> getFilterForInventory(Level level, BlockPos pos, boolean recursiveForDoubleChests) {
        BlockPos other;
        ChestType type;
        BlockState chest;
        ArrayList<ItemStack> filter = new ArrayList<ItemStack>();
        if (recursiveForDoubleChests && (chest = level.m_8055_(pos)).m_61138_((Property)ChestBlock.f_51479_) && (type = (ChestType)chest.m_61143_((Property)ChestBlock.f_51479_)) != ChestType.SINGLE && level.m_8055_(other = pos.m_121945_(ChestBlock.m_51584_((BlockState)chest))).m_60713_(chest.m_60734_())) {
            filter.addAll(HopperhockBlockEntity.getFilterForInventory(level, other, false));
        }
        for (Direction dir : Direction.values()) {
            AABB aabb = new AABB(pos.m_121945_(dir));
            List frames = level.m_45976_(ItemFrame.class, aabb);
            for (ItemFrame frame : frames) {
                if (frame.m_6350_() != dir) continue;
                filter.add(frame.m_31822_());
            }
        }
        return filter;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack wand, Direction side) {
        if (player == null || player.m_6144_()) {
            this.filterType = this.filterType == 2 ? 0 : this.filterType + 1;
            this.sync();
            return true;
        }
        return false;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), this.getRange());
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        return RadiusDescriptor.Rectangle.square(this.m_58899_(), 1);
    }

    public int getRange() {
        return this.getMana() > 0 ? 10 : 6;
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_FILTER_TYPE, this.filterType);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.filterType = cmp.m_128451_(TAG_FILTER_TYPE);
    }

    @Override
    public int getMaxMana() {
        return 20;
    }

    @Override
    public int getColor() {
        return 0x7F7F7F;
    }

    public static class Mini
    extends HopperhockBlockEntity {
        public Mini(BlockPos pos, BlockState state) {
            super(BotaniaFlowerBlocks.HOPPERHOCK_CHIBI, pos, state);
        }

        @Override
        public int getRange() {
            return this.getMana() > 0 ? 2 : 1;
        }
    }

    public static class WandHud
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<HopperhockBlockEntity> {
        public WandHud(HopperhockBlockEntity flower) {
            super(flower);
        }

        @Override
        public void renderHUD(PoseStack ms, Minecraft mc) {
            String filter = I18n.m_118938_((String)("botaniamisc.filter" + ((HopperhockBlockEntity)this.flower).filterType), (Object[])new Object[0]);
            int filterWidth = mc.f_91062_.m_92895_(filter);
            int filterTextStart = (mc.m_91268_().m_85445_() - filterWidth) / 2;
            int halfMinWidth = (filterWidth + 4) / 2;
            int centerY = mc.m_91268_().m_85446_() / 2;
            super.renderHUD(ms, mc, halfMinWidth, halfMinWidth, 40);
            mc.f_91062_.m_92750_(ms, filter, (float)filterTextStart, (float)(centerY + 30), ((HopperhockBlockEntity)this.flower).getColor());
        }
    }
}

