/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.init;

import com.blakebr0.cucumber.block.BaseBlock;
import com.blakebr0.cucumber.block.BaseGlassBlock;
import com.blakebr0.cucumber.block.BaseOreBlock;
import com.blakebr0.cucumber.block.BaseSlabBlock;
import com.blakebr0.cucumber.block.BaseStairsBlock;
import com.blakebr0.cucumber.block.BaseWallBlock;
import com.blakebr0.cucumber.item.BaseBlockItem;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.block.AwakeningAltarBlock;
import com.blakebr0.mysticalagriculture.block.AwakeningPedestalBlock;
import com.blakebr0.mysticalagriculture.block.EssenceFurnaceBlock;
import com.blakebr0.mysticalagriculture.block.EssenceVesselBlock;
import com.blakebr0.mysticalagriculture.block.GrowthAcceleratorBlock;
import com.blakebr0.mysticalagriculture.block.HarvesterBlock;
import com.blakebr0.mysticalagriculture.block.InferiumCropBlock;
import com.blakebr0.mysticalagriculture.block.InfusedFarmlandBlock;
import com.blakebr0.mysticalagriculture.block.InfusionAltarBlock;
import com.blakebr0.mysticalagriculture.block.InfusionPedestalBlock;
import com.blakebr0.mysticalagriculture.block.ReprocessorBlock;
import com.blakebr0.mysticalagriculture.block.SoulExtractorBlock;
import com.blakebr0.mysticalagriculture.block.TinkeringTableBlock;
import com.blakebr0.mysticalagriculture.block.WitherproofBlock;
import com.blakebr0.mysticalagriculture.block.WitherproofGlassBlock;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.lib.ModCrops;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import com.blakebr0.mysticalagriculture.util.ReprocessorTier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public final class ModBlocks {
    public static final Map<RegistryObject<Block>, Supplier<Block>> ENTRIES = new LinkedHashMap<RegistryObject<Block>, Supplier<Block>>();
    public static final RegistryObject<Block> PROSPERITY_BLOCK = ModBlocks.register("prosperity_block", () -> new BaseBlock(Material.f_76278_, SoundType.f_56742_, 4.0f, 6.0f, true));
    public static final RegistryObject<Block> INFERIUM_BLOCK = ModBlocks.register("inferium_block", () -> new BaseBlock(Material.f_76278_, SoundType.f_56742_, 4.0f, 6.0f, true));
    public static final RegistryObject<Block> PRUDENTIUM_BLOCK = ModBlocks.register("prudentium_block", () -> new BaseBlock(Material.f_76278_, SoundType.f_56742_, 4.0f, 6.0f, true));
    public static final RegistryObject<Block> TERTIUM_BLOCK = ModBlocks.register("tertium_block", () -> new BaseBlock(Material.f_76278_, SoundType.f_56742_, 4.0f, 6.0f, true));
    public static final RegistryObject<Block> IMPERIUM_BLOCK = ModBlocks.register("imperium_block", () -> new BaseBlock(Material.f_76278_, SoundType.f_56742_, 4.0f, 5.0f, true));
    public static final RegistryObject<Block> SUPREMIUM_BLOCK = ModBlocks.register("supremium_block", () -> new BaseBlock(Material.f_76278_, SoundType.f_56742_, 4.0f, 6.0f, true));
    public static final RegistryObject<Block> AWAKENED_SUPREMIUM_BLOCK = ModBlocks.register("awakened_supremium_block", () -> new BaseBlock(Material.f_76278_, SoundType.f_56742_, 4.0f, 6.0f, true));
    public static final RegistryObject<Block> SOULIUM_BLOCK = ModBlocks.register("soulium_block", () -> new BaseBlock(Material.f_76278_, SoundType.f_56742_, 4.0f, 6.0f, true));
    public static final RegistryObject<Block> PROSPERITY_INGOT_BLOCK = ModBlocks.register("prosperity_ingot_block", () -> new BaseBlock(Material.f_76279_, SoundType.f_56743_, 5.0f, 6.0f, true));
    public static final RegistryObject<Block> INFERIUM_INGOT_BLOCK = ModBlocks.register("inferium_ingot_block", () -> new BaseBlock(Material.f_76279_, SoundType.f_56743_, 5.0f, 6.0f, true));
    public static final RegistryObject<Block> PRUDENTIUM_INGOT_BLOCK = ModBlocks.register("prudentium_ingot_block", () -> new BaseBlock(Material.f_76279_, SoundType.f_56743_, 5.0f, 6.0f, true));
    public static final RegistryObject<Block> TERTIUM_INGOT_BLOCK = ModBlocks.register("tertium_ingot_block", () -> new BaseBlock(Material.f_76279_, SoundType.f_56743_, 5.0f, 6.0f, true));
    public static final RegistryObject<Block> IMPERIUM_INGOT_BLOCK = ModBlocks.register("imperium_ingot_block", () -> new BaseBlock(Material.f_76279_, SoundType.f_56743_, 5.0f, 6.0f, true));
    public static final RegistryObject<Block> SUPREMIUM_INGOT_BLOCK = ModBlocks.register("supremium_ingot_block", () -> new BaseBlock(Material.f_76279_, SoundType.f_56743_, 5.0f, 6.0f, true));
    public static final RegistryObject<Block> AWAKENED_SUPREMIUM_INGOT_BLOCK = ModBlocks.register("awakened_supremium_ingot_block", () -> new BaseBlock(Material.f_76279_, SoundType.f_56743_, 5.0f, 6.0f, true));
    public static final RegistryObject<Block> SOULIUM_INGOT_BLOCK = ModBlocks.register("soulium_ingot_block", () -> new BaseBlock(Material.f_76279_, SoundType.f_56743_, 5.0f, 6.0f, true));
    public static final RegistryObject<Block> PROSPERITY_GEMSTONE_BLOCK = ModBlocks.register("prosperity_gemstone_block", () -> new BaseBlock(Material.f_76279_, SoundType.f_56743_, 5.0f, 6.0f, true));
    public static final RegistryObject<Block> INFERIUM_GEMSTONE_BLOCK = ModBlocks.register("inferium_gemstone_block", () -> new BaseBlock(Material.f_76279_, SoundType.f_56743_, 5.0f, 6.0f, true));
    public static final RegistryObject<Block> PRUDENTIUM_GEMSTONE_BLOCK = ModBlocks.register("prudentium_gemstone_block", () -> new BaseBlock(Material.f_76279_, SoundType.f_56743_, 5.0f, 6.0f, true));
    public static final RegistryObject<Block> TERTIUM_GEMSTONE_BLOCK = ModBlocks.register("tertium_gemstone_block", () -> new BaseBlock(Material.f_76279_, SoundType.f_56743_, 5.0f, 6.0f, true));
    public static final RegistryObject<Block> IMPERIUM_GEMSTONE_BLOCK = ModBlocks.register("imperium_gemstone_block", () -> new BaseBlock(Material.f_76279_, SoundType.f_56743_, 5.0f, 6.0f, true));
    public static final RegistryObject<Block> SUPREMIUM_GEMSTONE_BLOCK = ModBlocks.register("supremium_gemstone_block", () -> new BaseBlock(Material.f_76279_, SoundType.f_56743_, 5.0f, 6.0f, true));
    public static final RegistryObject<Block> AWAKENED_SUPREMIUM_GEMSTONE_BLOCK = ModBlocks.register("awakened_supremium_gemstone_block", () -> new BaseBlock(Material.f_76279_, SoundType.f_56743_, 5.0f, 6.0f, true));
    public static final RegistryObject<Block> SOULIUM_GEMSTONE_BLOCK = ModBlocks.register("soulium_gemstone_block", () -> new BaseBlock(Material.f_76279_, SoundType.f_56743_, 5.0f, 6.0f, true));
    public static final RegistryObject<Block> INFERIUM_FARMLAND = ModBlocks.register("inferium_farmland", () -> new InfusedFarmlandBlock(CropTier.ONE));
    public static final RegistryObject<Block> PRUDENTIUM_FARMLAND = ModBlocks.register("prudentium_farmland", () -> new InfusedFarmlandBlock(CropTier.TWO));
    public static final RegistryObject<Block> TERTIUM_FARMLAND = ModBlocks.register("tertium_farmland", () -> new InfusedFarmlandBlock(CropTier.THREE));
    public static final RegistryObject<Block> IMPERIUM_FARMLAND = ModBlocks.register("imperium_farmland", () -> new InfusedFarmlandBlock(CropTier.FOUR));
    public static final RegistryObject<Block> SUPREMIUM_FARMLAND = ModBlocks.register("supremium_farmland", () -> new InfusedFarmlandBlock(CropTier.FIVE));
    public static final RegistryObject<Block> INFERIUM_GROWTH_ACCELERATOR = ModBlocks.register("inferium_growth_accelerator", () -> new GrowthAcceleratorBlock(12, CropTier.ONE.getTextColor()));
    public static final RegistryObject<Block> PRUDENTIUM_GROWTH_ACCELERATOR = ModBlocks.register("prudentium_growth_accelerator", () -> new GrowthAcceleratorBlock(24, CropTier.TWO.getTextColor()));
    public static final RegistryObject<Block> TERTIUM_GROWTH_ACCELERATOR = ModBlocks.register("tertium_growth_accelerator", () -> new GrowthAcceleratorBlock(36, CropTier.THREE.getTextColor()));
    public static final RegistryObject<Block> IMPERIUM_GROWTH_ACCELERATOR = ModBlocks.register("imperium_growth_accelerator", () -> new GrowthAcceleratorBlock(48, CropTier.FOUR.getTextColor()));
    public static final RegistryObject<Block> SUPREMIUM_GROWTH_ACCELERATOR = ModBlocks.register("supremium_growth_accelerator", () -> new GrowthAcceleratorBlock(60, CropTier.FIVE.getTextColor()));
    public static final RegistryObject<Block> INFERIUM_FURNACE = ModBlocks.register("inferium_furnace", EssenceFurnaceBlock.Inferium::new);
    public static final RegistryObject<Block> PRUDENTIUM_FURNACE = ModBlocks.register("prudentium_furnace", EssenceFurnaceBlock.Prudentium::new);
    public static final RegistryObject<Block> TERTIUM_FURNACE = ModBlocks.register("tertium_furnace", EssenceFurnaceBlock.Tertium::new);
    public static final RegistryObject<Block> IMPERIUM_FURNACE = ModBlocks.register("imperium_furnace", EssenceFurnaceBlock.Imperium::new);
    public static final RegistryObject<Block> SUPREMIUM_FURNACE = ModBlocks.register("supremium_furnace", EssenceFurnaceBlock.Supremium::new);
    public static final RegistryObject<Block> AWAKENED_SUPREMIUM_FURNACE = ModBlocks.register("awakened_supremium_furnace", EssenceFurnaceBlock.AwakenedSupremium::new);
    public static final RegistryObject<Block> PROSPERITY_ORE = ModBlocks.register("prosperity_ore", () -> new BaseOreBlock(Material.f_76278_, SoundType.f_56742_, 3.0f, 3.0f, 2, 5));
    public static final RegistryObject<Block> DEEPSLATE_PROSPERITY_ORE = ModBlocks.register("deepslate_prosperity_ore", () -> new BaseOreBlock(Material.f_76278_, SoundType.f_154677_, 4.5f, 3.0f, 2, 5));
    public static final RegistryObject<Block> INFERIUM_ORE = ModBlocks.register("inferium_ore", () -> new BaseOreBlock(Material.f_76278_, SoundType.f_56742_, 3.0f, 3.0f, 2, 5));
    public static final RegistryObject<Block> DEEPSLATE_INFERIUM_ORE = ModBlocks.register("deepslate_inferium_ore", () -> new BaseOreBlock(Material.f_76278_, SoundType.f_154677_, 4.5f, 3.0f, 2, 5));
    public static final RegistryObject<Block> SOULIUM_ORE = ModBlocks.register("soulium_ore", () -> new BaseOreBlock(Material.f_76278_, SoundType.f_56742_, 3.0f, 3.0f, 3, 7));
    public static final RegistryObject<Block> SOULSTONE = ModBlocks.register("soulstone", () -> new BaseBlock(Material.f_76278_, SoundType.f_56742_, 1.5f, 6.0f, true));
    public static final RegistryObject<Block> SOULSTONE_COBBLE = ModBlocks.register("soulstone_cobble", () -> new BaseBlock(Material.f_76278_, SoundType.f_56742_, 2.0f, 6.0f, true));
    public static final RegistryObject<Block> SOULSTONE_BRICKS = ModBlocks.register("soulstone_bricks", () -> new BaseBlock(Material.f_76278_, SoundType.f_56742_, 1.5f, 6.0f, true));
    public static final RegistryObject<Block> SOULSTONE_CRACKED_BRICKS = ModBlocks.register("soulstone_cracked_bricks", () -> new BaseBlock(Material.f_76278_, SoundType.f_56742_, 1.5f, 6.0f, true));
    public static final RegistryObject<Block> SOULSTONE_CHISELED_BRICKS = ModBlocks.register("soulstone_chiseled_bricks", () -> new BaseBlock(Material.f_76278_, SoundType.f_56742_, 1.5f, 6.0f, true));
    public static final RegistryObject<Block> SOULSTONE_SMOOTH = ModBlocks.register("soulstone_smooth", () -> new BaseBlock(Material.f_76278_, SoundType.f_56742_, 1.5f, 6.0f, true));
    public static final RegistryObject<Block> SOUL_GLASS = ModBlocks.register("soul_glass", () -> new BaseGlassBlock(Material.f_76275_, SoundType.f_56744_, 0.3f, 0.3f));
    public static final RegistryObject<Block> SOULSTONE_SLAB = ModBlocks.register("soulstone_slab", () -> new BaseSlabBlock(Material.f_76278_, SoundType.f_56742_, 1.5f, 6.0f, true));
    public static final RegistryObject<Block> SOULSTONE_COBBLE_SLAB = ModBlocks.register("soulstone_cobble_slab", () -> new BaseSlabBlock(Material.f_76278_, SoundType.f_56742_, 2.0f, 6.0f, true));
    public static final RegistryObject<Block> SOULSTONE_BRICKS_SLAB = ModBlocks.register("soulstone_bricks_slab", () -> new BaseSlabBlock(Material.f_76278_, SoundType.f_56742_, 1.5f, 6.0f, true));
    public static final RegistryObject<Block> SOULSTONE_SMOOTH_SLAB = ModBlocks.register("soulstone_smooth_slab", () -> new BaseSlabBlock(Material.f_76278_, SoundType.f_56742_, 1.5f, 6.0f, true));
    public static final RegistryObject<Block> SOULSTONE_STAIRS = ModBlocks.register("soulstone_stairs", () -> new BaseStairsBlock(SOULSTONE.lazyMap(Block::m_49966_), Material.f_76278_, SoundType.f_56742_, 1.5f, 6.0f, true));
    public static final RegistryObject<Block> SOULSTONE_COBBLE_STAIRS = ModBlocks.register("soulstone_cobble_stairs", () -> new BaseStairsBlock(SOULSTONE_COBBLE.lazyMap(Block::m_49966_), Material.f_76278_, SoundType.f_56742_, 2.0f, 6.0f, true));
    public static final RegistryObject<Block> SOULSTONE_BRICKS_STAIRS = ModBlocks.register("soulstone_bricks_stairs", () -> new BaseStairsBlock(SOULSTONE_BRICKS.lazyMap(Block::m_49966_), Material.f_76278_, SoundType.f_56742_, 1.5f, 6.0f, true));
    public static final RegistryObject<Block> SOULSTONE_COBBLE_WALL = ModBlocks.register("soulstone_cobble_wall", () -> new BaseWallBlock(Material.f_76278_, SoundType.f_56742_, 2.0f, 6.0f, true));
    public static final RegistryObject<Block> SOULSTONE_BRICKS_WALL = ModBlocks.register("soulstone_bricks_wall", () -> new BaseWallBlock(Material.f_76278_, SoundType.f_56742_, 1.5f, 6.0f, true));
    public static final RegistryObject<Block> WITHERPROOF_BLOCK = ModBlocks.register("witherproof_block", WitherproofBlock::new);
    public static final RegistryObject<Block> WITHERPROOF_BRICKS = ModBlocks.register("witherproof_bricks", WitherproofBlock::new);
    public static final RegistryObject<Block> WITHERPROOF_GLASS = ModBlocks.register("witherproof_glass", WitherproofGlassBlock::new);
    public static final RegistryObject<Block> INFUSION_PEDESTAL = ModBlocks.register("infusion_pedestal", InfusionPedestalBlock::new);
    public static final RegistryObject<Block> INFUSION_ALTAR = ModBlocks.register("infusion_altar", InfusionAltarBlock::new);
    public static final RegistryObject<Block> AWAKENING_PEDESTAL = ModBlocks.register("awakening_pedestal", AwakeningPedestalBlock::new);
    public static final RegistryObject<Block> AWAKENING_ALTAR = ModBlocks.register("awakening_altar", AwakeningAltarBlock::new);
    public static final RegistryObject<Block> ESSENCE_VESSEL = ModBlocks.register("essence_vessel", EssenceVesselBlock::new);
    public static final RegistryObject<Block> TINKERING_TABLE = ModBlocks.register("tinkering_table", TinkeringTableBlock::new);
    public static final RegistryObject<Block> MACHINE_FRAME = ModBlocks.register("machine_frame", () -> new BaseBlock(Material.f_76278_, SoundType.f_56742_, 1.5f, 6.0f, true));
    public static final RegistryObject<Block> BASIC_REPROCESSOR = ModBlocks.register("basic_reprocessor", () -> new ReprocessorBlock(ReprocessorTier.BASIC));
    public static final RegistryObject<Block> INFERIUM_REPROCESSOR = ModBlocks.register("inferium_reprocessor", () -> new ReprocessorBlock(ReprocessorTier.INFERIUM));
    public static final RegistryObject<Block> PRUDENTIUM_REPROCESSOR = ModBlocks.register("prudentium_reprocessor", () -> new ReprocessorBlock(ReprocessorTier.PRUDENTIUM));
    public static final RegistryObject<Block> TERTIUM_REPROCESSOR = ModBlocks.register("tertium_reprocessor", () -> new ReprocessorBlock(ReprocessorTier.TERTIUM));
    public static final RegistryObject<Block> IMPERIUM_REPROCESSOR = ModBlocks.register("imperium_reprocessor", () -> new ReprocessorBlock(ReprocessorTier.IMPERIUM));
    public static final RegistryObject<Block> SUPREMIUM_REPROCESSOR = ModBlocks.register("supremium_reprocessor", () -> new ReprocessorBlock(ReprocessorTier.SUPREMIUM));
    public static final RegistryObject<Block> AWAKENED_SUPREMIUM_REPROCESSOR = ModBlocks.register("awakened_supremium_reprocessor", () -> new ReprocessorBlock(ReprocessorTier.AWAKENED_SUPREMIUM));
    public static final RegistryObject<Block> SOUL_EXTRACTOR = ModBlocks.register("soul_extractor", SoulExtractorBlock::new);
    public static final RegistryObject<Block> HARVESTER = ModBlocks.register("harvester", HarvesterBlock::new);
    public static final RegistryObject<Block> INFERIUM_CROP = ModBlocks.registerNoItem("inferium_crop", () -> new InferiumCropBlock(ModCrops.INFERIUM));

    @SubscribeEvent
    public void onRegisterBlocks(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.BLOCKS, (T registry) -> {
            ENTRIES.forEach((reg, block) -> registry.register(reg.getId(), (Object)((Block)block.get())));
            CropRegistry.getInstance().setAllowRegistration(true);
            CropRegistry.getInstance().onRegisterBlocks((IForgeRegistry<Block>)event.getForgeRegistry());
            CropRegistry.getInstance().setAllowRegistration(false);
        });
    }

    private static RegistryObject<Block> register(String name, Supplier<Block> block) {
        return ModBlocks.register(name, block, b -> () -> new BaseBlockItem((Block)b.get(), p -> p.m_41491_(MysticalAgriculture.CREATIVE_TAB)));
    }

    private static RegistryObject<Block> register(String name, Supplier<Block> block, Function<RegistryObject<Block>, Supplier<? extends BlockItem>> item) {
        ResourceLocation loc = new ResourceLocation("mysticalagriculture", name);
        RegistryObject reg = RegistryObject.create((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.BLOCKS);
        ENTRIES.put((RegistryObject<Block>)reg, block);
        ModItems.BLOCK_ENTRIES.add(() -> (BlockItem)((Supplier)item.apply(reg)).get());
        return reg;
    }

    public static RegistryObject<Block> registerNoItem(String name, Supplier<Block> block) {
        ResourceLocation loc = new ResourceLocation("mysticalagriculture", name);
        RegistryObject reg = RegistryObject.create((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.BLOCKS);
        ENTRIES.put((RegistryObject<Block>)reg, block);
        return reg;
    }
}

