/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.lib;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.registries.ForgeRegistries;

public class LazyIngredient {
    public static final LazyIngredient EMPTY = new LazyIngredient(null, null, null){

        @Override
        public Ingredient getIngredient() {
            return Ingredient.f_43901_;
        }
    };
    private final String name;
    private final CompoundTag nbt;
    private final Type type;
    private Ingredient ingredient;

    private LazyIngredient(String name, Type type, CompoundTag nbt) {
        this.name = name;
        this.type = type;
        this.nbt = nbt;
    }

    public static LazyIngredient item(String name) {
        return LazyIngredient.item(name, null);
    }

    public static LazyIngredient item(String name, CompoundTag nbt) {
        return new LazyIngredient(name, Type.ITEM, nbt);
    }

    public static LazyIngredient tag(String name) {
        return new LazyIngredient(name, Type.TAG, null);
    }

    public boolean isItem() {
        return this.type == Type.ITEM;
    }

    public boolean isTag() {
        return this.type == Type.TAG;
    }

    public Ingredient.Value createValue() {
        Item item;
        if (this.isTag()) {
            TagKey tag = ItemTags.create((ResourceLocation)new ResourceLocation(this.name));
            return new Ingredient.TagValue(tag);
        }
        if (this.isItem() && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.name))) != null) {
            ItemStack stack = new ItemStack((ItemLike)item);
            if (this.nbt != null && !this.nbt.m_128456_()) {
                stack.m_41751_(this.nbt);
            }
            return new Ingredient.ItemValue(stack);
        }
        return null;
    }

    public Ingredient getIngredient() {
        if (this.ingredient == null) {
            Item item;
            if (this.isTag()) {
                TagKey tag = ItemTags.create((ResourceLocation)new ResourceLocation(this.name));
                this.ingredient = Ingredient.m_204132_((TagKey)tag);
            } else if (this.isItem() && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.name))) != null) {
                if (this.nbt == null || this.nbt.m_128456_()) {
                    this.ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
                } else {
                    ItemStack stack = new ItemStack((ItemLike)item);
                    stack.m_41751_(this.nbt);
                    this.ingredient = StrictNBTIngredient.of((ItemStack)stack);
                }
            }
        }
        return this.ingredient == null ? Ingredient.f_43901_ : this.ingredient;
    }

    private static enum Type {
        ITEM,
        TAG;

    }
}

