/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.commands.args;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class EnumArgument<T extends Enum<T>>
implements ArgumentType<T> {
    private static final DynamicCommandExceptionType ERROR_UNKNOWN = new DynamicCommandExceptionType(obj -> Component.m_237110_((String)"argument.bookshelf.unknown_value", (Object[])new Object[]{obj}));
    private final CachedSupplier<Map<String, T>> values = CachedSupplier.cache(() -> {
        HashMap<String, Enum> valueMap = new HashMap<String, Enum>();
        for (Enum enumConst : (Enum[])enumClass.getEnumConstants()) {
            valueMap.put(enumConst.name(), enumConst);
        }
        return valueMap;
    });

    public EnumArgument(Class<T> enumClass) {
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        String inputEnumName = reader.readUnquotedString();
        if (this.values.get().containsKey(inputEnumName)) {
            return (T)((Enum)this.values.get().get(inputEnumName));
        }
        throw ERROR_UNKNOWN.createWithContext((ImmutableStringReader)reader, (Object)inputEnumName);
    }

    public Collection<String> getExamples() {
        return this.values.get().keySet();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_(this.values.get().keySet(), (SuggestionsBuilder)builder);
    }
}

