/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data.materials;

import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StoneVariant
extends VariantBase<StoneVariant> {
    public static StoneVariant QUARTZ = new StoneVariant(Blocks.f_50333_, Blocks.f_50333_, "quartz");
    public static StoneVariant NETHERITE = new StoneVariant(Blocks.f_50721_, Blocks.f_50722_, "netherite");
    public static StoneVariant LIGHT_WOOD = new StoneVariant(Blocks.f_50333_, Blocks.f_50010_, "light_wood");
    public static StoneVariant DARK_WOOD = new StoneVariant(Blocks.f_50333_, Blocks.f_50009_, "dark_wood");
    public static StoneVariant GRANITE = new StoneVariant(Blocks.f_50175_, Blocks.f_50122_, "granite");
    public static StoneVariant CALCITE = new StoneVariant(Blocks.f_152497_, Blocks.f_50687_, "calcite");
    public static StoneVariant ANDESITE = new StoneVariant(Blocks.f_50387_, Blocks.f_50334_, "andesite");
    public static StoneVariant DIORITE = new StoneVariant(Blocks.f_50281_, Blocks.f_50228_, "diorite");
    public static StoneVariant DEEPSLATE = new StoneVariant(Blocks.f_152555_, Blocks.f_152550_, "deepslate");
    public static StoneVariant BLACKSTONE = new StoneVariant(Blocks.f_50734_, Blocks.f_50730_, "blackstone");
    public static StoneVariant STONE = new StoneVariant(Blocks.f_50069_, Blocks.f_50652_, "stone");
    static final List<StoneVariant> DEFAULT_VARIANTS = new ArrayList<StoneVariant>();
    private final String name;
    private final Block baseBlock;
    private final Block secondaryBlock;

    public static List<StoneVariant> values() {
        return DEFAULT_VARIANTS;
    }

    StoneVariant(ResourceLocation identifier, Block baseBlock, Block secondaryBlock) {
        super(identifier);
        this.name = identifier.m_135815_();
        this.baseBlock = baseBlock;
        this.secondaryBlock = secondaryBlock;
    }

    StoneVariant(Block baseBlock, Block secondaryBlock, String name) {
        this(new ResourceLocation("", name), baseBlock, secondaryBlock);
    }

    public String m_7912_() {
        return this.name;
    }

    @Override
    public Block getBaseBlock() {
        return this.baseBlock;
    }

    @Override
    public Block getSecondaryBlock() {
        return this.secondaryBlock;
    }

    @Override
    public boolean isNetherWood() {
        return false;
    }

    @Override
    public Material getVanillaMaterial() {
        return this.baseBlock.m_49966_().m_60767_();
    }

    @Override
    public StoneVariant getVariantType() {
        return this;
    }

    @Override
    public boolean isVanilla() {
        return this.identifier.m_135827_().equals("") || this.identifier.m_135827_().equals("minecraft");
    }

    @Override
    public void initializeChildrenBlocks() {
    }

    @Override
    public void initializeChildrenItems() {
    }

    @Override
    public Block mainChild() {
        return StoneVariant.STONE.baseBlock;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture(BlockType type) {
        if (type == BlockType.SECONDARY) {
            return ModelHelper.getTextureId(this.secondaryBlock);
        }
        return ModelHelper.getTextureId(this.baseBlock);
    }

    @Override
    public String getPath() {
        return this.identifier.m_135815_();
    }

    static {
        DEFAULT_VARIANTS.add(QUARTZ);
        DEFAULT_VARIANTS.add(NETHERITE);
        DEFAULT_VARIANTS.add(LIGHT_WOOD);
        DEFAULT_VARIANTS.add(DARK_WOOD);
        DEFAULT_VARIANTS.add(GRANITE);
        DEFAULT_VARIANTS.add(CALCITE);
        DEFAULT_VARIANTS.add(ANDESITE);
        DEFAULT_VARIANTS.add(DIORITE);
        DEFAULT_VARIANTS.add(DEEPSLATE);
        DEFAULT_VARIANTS.add(BLACKSTONE);
        DEFAULT_VARIANTS.add(STONE);
    }
}

