/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.logTable;

import com.mojang.datafixers.util.Pair;
import com.unlikepaladin.pfm.blocks.models.logTable.forge.UnbakedLogTableModelImpl;
import com.unlikepaladin.pfm.data.materials.StoneVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class UnbakedLogTableModel
implements UnbakedModel {
    public static final ResourceLocation[] LOG_MODEL_PARTS_BASE = new ResourceLocation[]{new ResourceLocation("pfm", "block/log_table/log_table_middle"), new ResourceLocation("pfm", "block/log_table/log_table_right"), new ResourceLocation("pfm", "block/log_table/log_table_left"), new ResourceLocation("pfm", "block/log_table/log_table_legs")};
    private static final ResourceLocation PARENT = new ResourceLocation("block/block");
    public static final ResourceLocation TABLE_MODEL_ID = new ResourceLocation("pfm", "block/log_table");
    public static final List<ResourceLocation> TABLE_MODEL_IDS = new ArrayList<ResourceLocation>(){
        {
            for (WoodVariant woodVariant : WoodVariantRegistry.getVariants()) {
                String logType = woodVariant.isNetherWood() ? "stem" : "log";
                this.add(new ResourceLocation("pfm", "item/" + woodVariant.m_7912_() + "_table_" + logType));
                this.add(new ResourceLocation("pfm", "item/" + woodVariant.m_7912_() + "_raw_table_" + logType));
                if (!woodVariant.hasStripped()) continue;
                this.add(new ResourceLocation("pfm", "item/stripped_" + woodVariant.m_7912_() + "_table_" + logType));
                this.add(new ResourceLocation("pfm", "item/stripped_" + woodVariant.m_7912_() + "_raw_table_" + logType));
            }
            for (StoneVariant stoneVariant : StoneVariant.values()) {
                this.add(new ResourceLocation("pfm", "item/" + stoneVariant.m_7912_() + "_table_natural"));
            }
            this.add(TABLE_MODEL_ID);
        }
    };
    public static final Map<ModelState, List<BakedModel>> CACHED_MODELS = new ConcurrentHashMap<ModelState, List<BakedModel>>();

    public Collection<ResourceLocation> m_7970_() {
        return List.of(PARENT);
    }

    public Collection<Material> m_5500_(Function<ResourceLocation, UnbakedModel> unbakedModelGetter, Set<Pair<String, String>> unresolvedTextureReferences) {
        return Collections.emptyList();
    }

    @Nullable
    public BakedModel m_7611_(ModelBakery loader, Function<Material, TextureAtlasSprite> textureGetter, ModelState rotationContainer, ResourceLocation modelId) {
        if (CACHED_MODELS.containsKey(rotationContainer)) {
            return UnbakedLogTableModel.getBakedModel(rotationContainer, CACHED_MODELS.get(rotationContainer));
        }
        ArrayList<BakedModel> bakedModelList = new ArrayList<BakedModel>();
        for (ResourceLocation modelPart : LOG_MODEL_PARTS_BASE) {
            bakedModelList.add(loader.m_119349_(modelPart, rotationContainer));
        }
        CACHED_MODELS.put(rotationContainer, bakedModelList);
        return UnbakedLogTableModel.getBakedModel(rotationContainer, bakedModelList);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BakedModel getBakedModel(ModelState settings, List<BakedModel> modelParts) {
        void var1_1;
        return UnbakedLogTableModelImpl.getBakedModel(settings, (List<BakedModel>)var1_1);
    }
}

