/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.forge;

import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.datafixers.util.Pair;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.models.AbstractBakedModel;
import com.unlikepaladin.pfm.client.forge.PFMBakedModelGetQuadsExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PFMForgeBakedModel
extends AbstractBakedModel
implements PFMBakedModelGetQuadsExtension {
    public static ModelProperty<BlockState> STATE = new ModelProperty();
    Map<ResourceLocation, List<BakedQuad>> separatedQuads = new ConcurrentHashMap<ResourceLocation, List<BakedQuad>>();
    Map<Pair<ResourceLocation, BakedQuad>, BakedQuad> quadToTransformedQuad = new ConcurrentHashMap<Pair<ResourceLocation, BakedQuad>, BakedQuad>();
    private static final Map<Pair<VertexFormatElement.Usage, Integer>, Integer> ELEMENT_INTEGER_MAP = new ConcurrentHashMap<Pair<VertexFormatElement.Usage, Integer>, Integer>();

    @Override
    public List<BakedQuad> getQuads(ItemStack stack, @Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        return this.m_213637_(state, face, random);
    }

    public PFMForgeBakedModel(ModelState settings, List<BakedModel> templateBakedModels) {
        super(settings, templateBakedModels);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData tileData) {
        return tileData.derive().with(STATE, (Object)state).build();
    }

    public List<BakedQuad> getQuadsWithTexture(List<BakedQuad> quads, List<TextureAtlasSprite> toReplace, List<TextureAtlasSprite> replacements) {
        if (quads == null) {
            return Collections.emptyList();
        }
        if (replacements == null || toReplace == null) {
            PaladinFurnitureMod.GENERAL_LOGGER.warn("Replacement list was null, skipping transformation");
            return quads;
        }
        if (toReplace.size() != replacements.size()) {
            PaladinFurnitureMod.GENERAL_LOGGER.warn("Replacement list was not the same size, skipping transformation, expected {} sprites, got {}", (Object)toReplace.size(), (Object)replacements.size());
            PaladinFurnitureMod.GENERAL_LOGGER.debug(toReplace);
            PaladinFurnitureMod.GENERAL_LOGGER.debug(replacements);
            return quads;
        }
        if (toReplace.equals(replacements)) {
            return quads;
        }
        for (BakedQuad quad : quads) {
            ResourceLocation sprite = quad.m_173410_().m_118413_();
            if (this.separatedQuads.containsKey(sprite)) {
                if (this.separatedQuads.get(sprite).contains(quad)) continue;
                ArrayList<BakedQuad> newQuadList = new ArrayList<BakedQuad>((Collection)this.separatedQuads.get(sprite));
                newQuadList.add(quad);
                this.separatedQuads.put(sprite, newQuadList);
                continue;
            }
            ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
            list.add(quad);
            this.separatedQuads.put(sprite, list);
        }
        ArrayList<BakedQuad> transformedQuads = new ArrayList<BakedQuad>(quads.size());
        for (Map.Entry<ResourceLocation, List<BakedQuad>> entry : this.separatedQuads.entrySet()) {
            ResourceLocation keyId = entry.getKey();
            int index = IntStream.range(0, toReplace.size()).filter(i -> keyId.equals((Object)((TextureAtlasSprite)toReplace.get(i)).m_118413_())).findFirst().orElse(-1);
            if (index != -1) {
                TextureAtlasSprite replacement = (TextureAtlasSprite)Iterables.get(replacements, (int)index, (Object)toReplace.get(index));
                transformedQuads.addAll(this.getQuadsWithTexture(entry.getValue().stream().filter(quads::contains).toList(), replacement));
                continue;
            }
            transformedQuads.addAll(entry.getValue().stream().filter(quads::contains).toList());
        }
        return transformedQuads;
    }

    public List<BakedQuad> getQuadsWithTexture(List<BakedQuad> quads, TextureAtlasSprite sprite) {
        ArrayList<BakedQuad> transformedQuads = new ArrayList<BakedQuad>(quads.size());
        quads.forEach(quad -> {
            Pair quadKey = new Pair((Object)sprite.m_118413_(), quad);
            if (quad.m_173410_().m_118413_() == sprite.m_118413_() && !this.quadToTransformedQuad.containsKey(quadKey) && !PaladinFurnitureMod.isOptifineLoaded()) {
                this.quadToTransformedQuad.put((Pair<ResourceLocation, BakedQuad>)quadKey, (BakedQuad)quad);
                transformedQuads.add((BakedQuad)quad);
            } else if (this.quadToTransformedQuad.containsKey(quadKey) && !PaladinFurnitureMod.isOptifineLoaded()) {
                transformedQuads.add(this.quadToTransformedQuad.get(quadKey));
            } else {
                int[] vertexData = new int[quad.m_111303_().length];
                System.arraycopy(quad.m_111303_(), 0, vertexData, 0, vertexData.length);
                float[][] uv = new float[4][2];
                for (int vertexIndx = 0; vertexIndx < 4; ++vertexIndx) {
                    PFMForgeBakedModel.unpackUV(vertexData, uv[vertexIndx], vertexIndx);
                    TextureAtlasSprite originalSprite = quad.m_173410_();
                    float frameU = originalSprite.m_174727_(uv[vertexIndx][0]);
                    float frameV = originalSprite.m_174741_(uv[vertexIndx][1]);
                    uv[vertexIndx][0] = sprite.m_118367_((double)frameU);
                    uv[vertexIndx][1] = sprite.m_118393_((double)frameV);
                    PFMForgeBakedModel.packUV(uv[vertexIndx], vertexData, vertexIndx);
                }
                BakedQuad transformedQuad = new BakedQuad(vertexData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
                this.quadToTransformedQuad.put((Pair<ResourceLocation, BakedQuad>)quadKey, transformedQuad);
                transformedQuads.add(transformedQuad);
            }
        });
        return transformedQuads;
    }

    public static void unpackUV(int[] vertexData, float[] uv, int vertexIndx) {
        int offset = vertexIndx * IQuadTransformer.STRIDE + IQuadTransformer.UV0;
        uv[0] = Float.intBitsToFloat(vertexData[offset]);
        uv[1] = Float.intBitsToFloat(vertexData[offset + 1]);
    }

    public static void packUV(float[] uv, int[] vertexData, int vertexIndx) {
        int offset = vertexIndx * IQuadTransformer.STRIDE + IQuadTransformer.UV0;
        vertexData[offset] = Float.floatToRawIntBits(uv[0]);
        vertexData[offset + 1] = Float.floatToRawIntBits(uv[1]);
    }

    public static int findVertexElement(VertexFormatElement.Usage type, int index) {
        VertexFormatElement element1;
        Pair pairToFind = new Pair((Object)type, (Object)index);
        if (ELEMENT_INTEGER_MAP.containsKey(pairToFind)) {
            return ELEMENT_INTEGER_MAP.get(pairToFind);
        }
        int id = 0;
        UnmodifiableIterator unmodifiableIterator = DefaultVertexFormat.f_85811_.m_86023_().iterator();
        while (unmodifiableIterator.hasNext() && ((element1 = (VertexFormatElement)unmodifiableIterator.next()).m_86048_() != type || element1.m_86049_() != index)) {
            ++id;
        }
        ELEMENT_INTEGER_MAP.put((Pair<VertexFormatElement.Usage, Integer>)pairToFind, id);
        return id;
    }

    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        if (data.has(STATE) && data.get(STATE) != null) {
            return this.getSpriteList((BlockState)data.get(STATE)).get(0);
        }
        return super.getParticleIcon(data);
    }

    public TextureAtlasSprite m_6160_() {
        return this.getTemplateBakedModels().get(0).m_6160_();
    }
}

