/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.basicTable.forge;

import com.unlikepaladin.pfm.blocks.BasicTableBlock;
import com.unlikepaladin.pfm.blocks.models.forge.ModelBitSetProperty;
import com.unlikepaladin.pfm.blocks.models.forge.PFMForgeBakedModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeBasicTableModel
extends PFMForgeBakedModel {
    public static ModelProperty<ModelBitSetProperty> CONNECTIONS = new ModelProperty();

    public ForgeBasicTableModel(ModelState settings, List<BakedModel> modelParts) {
        super(settings, modelParts);
    }

    @Override
    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData tileData) {
        if (state.m_60734_() instanceof BasicTableBlock) {
            ModelData.Builder builder = ModelData.builder();
            ModelData data = builder.build();
            data = super.getModelData(world, pos, state, data);
            BasicTableBlock block = (BasicTableBlock)state.m_60734_();
            boolean north = block.canConnect((BlockGetter)world, state, pos.m_122012_(), pos);
            boolean east = block.canConnect((BlockGetter)world, state, pos.m_122029_(), pos);
            boolean west = block.canConnect((BlockGetter)world, state, pos.m_122024_(), pos);
            boolean south = block.canConnect((BlockGetter)world, state, pos.m_122019_(), pos);
            boolean cornerNorthWest = north && west && !block.canConnect((BlockGetter)world, state, pos.m_122012_().m_122024_(), pos);
            boolean cornerNorthEast = north && east && !block.canConnect((BlockGetter)world, state, pos.m_122012_().m_122029_(), pos);
            boolean cornerSouthEast = south && east && !block.canConnect((BlockGetter)world, state, pos.m_122019_().m_122029_(), pos);
            boolean cornerSouthWest = south && west && !block.canConnect((BlockGetter)world, state, pos.m_122019_().m_122024_(), pos);
            BitSet set = new BitSet();
            set.set(0, north);
            set.set(1, east);
            set.set(2, west);
            set.set(3, south);
            set.set(4, cornerNorthWest);
            set.set(5, cornerNorthEast);
            set.set(6, cornerSouthEast);
            set.set(7, cornerSouthWest);
            data = data.derive().with(CONNECTIONS, (Object)new ModelBitSetProperty(set)).build();
            return data;
        }
        return tileData;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, RenderType renderType) {
        if (state != null && state.m_60734_() instanceof BasicTableBlock && extraData.get(CONNECTIONS) != null && ((ModelBitSetProperty)extraData.get(ForgeBasicTableModel.CONNECTIONS)).connections != null) {
            ArrayList<BakedQuad> baseQuads = new ArrayList<BakedQuad>();
            ArrayList<BakedQuad> secondaryQuads = new ArrayList<BakedQuad>();
            BitSet set = ((ModelBitSetProperty)extraData.get(ForgeBasicTableModel.CONNECTIONS)).connections;
            boolean north = set.get(0);
            boolean east = set.get(1);
            boolean west = set.get(2);
            boolean south = set.get(3);
            boolean cornerNorthWest = set.get(4);
            boolean cornerNorthEast = set.get(5);
            boolean cornerSouthEast = set.get(6);
            boolean cornerSouthWest = set.get(7);
            Direction.Axis dir = (Direction.Axis)state.m_61143_(BasicTableBlock.AXIS);
            baseQuads.addAll(this.getTemplateBakedModels().get(0).getQuads(state, side, rand, extraData, renderType));
            if (!(north || south || east || west)) {
                secondaryQuads.addAll(this.getTemplateBakedModels().get(8).getQuads(state, side, rand, extraData, renderType));
                secondaryQuads.addAll(this.getTemplateBakedModels().get(7).getQuads(state, side, rand, extraData, renderType));
            }
            if (dir == Direction.Axis.Z) {
                if (!north && !east) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(1).getQuads(state, side, rand, extraData, renderType));
                }
                if (!north && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, side, rand, extraData, renderType));
                }
                if (!south && !east) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, side, rand, extraData, renderType));
                }
                if (!south && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, side, rand, extraData, renderType));
                }
                if (!north && south && !east && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(7).getQuads(state, side, rand, extraData, renderType));
                }
                if (north && !south && !east && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(8).getQuads(state, side, rand, extraData, renderType));
                }
                if (!north && east && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(5).getQuads(state, side, rand, extraData, renderType));
                }
                if (!south && !east && west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(10).getQuads(state, side, rand, extraData, renderType));
                }
                if (!south && east && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(9).getQuads(state, side, rand, extraData, renderType));
                }
                if (!north && !east && west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(6).getQuads(state, side, rand, extraData, renderType));
                }
                if (!north && east && west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(12).getQuads(state, side, rand, extraData, renderType));
                }
                if (!south && east && west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(11).getQuads(state, side, rand, extraData, renderType));
                }
                if (cornerNorthEast) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(13).getQuads(state, side, rand, extraData, renderType));
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(1).getQuads(state, side, rand, extraData, renderType));
                }
                if (cornerNorthWest) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(14).getQuads(state, side, rand, extraData, renderType));
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, side, rand, extraData, renderType));
                }
                if (cornerSouthWest) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(16).getQuads(state, side, rand, extraData, renderType));
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, side, rand, extraData, renderType));
                }
                if (cornerSouthEast) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(15).getQuads(state, side, rand, extraData, renderType));
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, side, rand, extraData, renderType));
                }
            } else {
                if (!north && !east) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, side, rand, extraData, renderType));
                }
                if (!north && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, side, rand, extraData, renderType));
                }
                if (!south && !east) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(1).getQuads(state, side, rand, extraData, renderType));
                }
                if (!south && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, side, rand, extraData, renderType));
                }
                if (!north && south && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(9).getQuads(state, side, rand, extraData, renderType));
                }
                if (north && !south && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(10).getQuads(state, side, rand, extraData, renderType));
                }
                if (!north && south && !east) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(5).getQuads(state, side, rand, extraData, renderType));
                }
                if (north && !south && !east) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(6).getQuads(state, side, rand, extraData, renderType));
                }
                if (!(north || south || east)) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(7).getQuads(state, side, rand, extraData, renderType));
                }
                if (!(north || south || west)) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(8).getQuads(state, side, rand, extraData, renderType));
                }
                if (north && south && !east) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(12).getQuads(state, side, rand, extraData, renderType));
                }
                if (north && south && !west) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(11).getQuads(state, side, rand, extraData, renderType));
                }
                if (cornerNorthEast) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(14).getQuads(state, side, rand, extraData, renderType));
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, side, rand, extraData, renderType));
                }
                if (cornerSouthEast) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(13).getQuads(state, side, rand, extraData, renderType));
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(1).getQuads(state, side, rand, extraData, renderType));
                }
                if (cornerNorthWest) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(16).getQuads(state, side, rand, extraData, renderType));
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, side, rand, extraData, renderType));
                }
                if (cornerSouthWest) {
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(15).getQuads(state, side, rand, extraData, renderType));
                    secondaryQuads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, side, rand, extraData, renderType));
                }
            }
            List<TextureAtlasSprite> spriteList = this.getSpriteList(state);
            List<BakedQuad> quads = this.getQuadsWithTexture(baseQuads, spriteList.get(0));
            quads.addAll(this.getQuadsWithTexture(secondaryQuads, spriteList.get(1)));
            return quads;
        }
        return Collections.emptyList();
    }

    @Override
    public List<BakedQuad> getQuads(ItemStack stack, @Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        ArrayList<BakedQuad> baseQuads = new ArrayList<BakedQuad>(this.getTemplateBakedModels().get(0).m_213637_(state, face, random));
        ArrayList<BakedQuad> secondaryQuads = new ArrayList<BakedQuad>();
        secondaryQuads.addAll(this.getTemplateBakedModels().get(1).m_213637_(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(2).m_213637_(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(3).m_213637_(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(4).m_213637_(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(8).m_213637_(state, face, random));
        secondaryQuads.addAll(this.getTemplateBakedModels().get(7).m_213637_(state, face, random));
        List<TextureAtlasSprite> spriteList = this.getSpriteList(stack);
        List<BakedQuad> quads = this.getQuadsWithTexture(baseQuads, spriteList.get(0));
        quads.addAll(this.getQuadsWithTexture(secondaryQuads, spriteList.get(1)));
        return quads;
    }
}

