/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModernDinnerTableBlock
extends Block {
    private final Block baseBlock;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    private static final List<FurnitureBlock> WOOD_DINNER_MODERN_TABLES = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_DINNER_MODERN_TABLES = new ArrayList<FurnitureBlock>();
    private final BlockState baseBlockState;
    static final VoxelShape MODERN_DINNER_TABLE = Shapes.m_83124_((VoxelShape)ModernDinnerTableBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ModernDinnerTableBlock.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0), ModernDinnerTableBlock.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)4.0), ModernDinnerTableBlock.m_49796_((double)13.0, (double)2.0, (double)7.0, (double)15.0, (double)14.0, (double)9.0), ModernDinnerTableBlock.m_49796_((double)1.0, (double)2.0, (double)7.0, (double)3.0, (double)14.0, (double)9.0), ModernDinnerTableBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)14.0, (double)4.0), ModernDinnerTableBlock.m_49796_((double)2.0, (double)0.0, (double)4.0, (double)4.0, (double)2.0, (double)12.0), ModernDinnerTableBlock.m_49796_((double)3.0, (double)2.0, (double)7.0, (double)13.0, (double)4.0, (double)9.0), ModernDinnerTableBlock.m_49796_((double)12.0, (double)0.0, (double)4.0, (double)14.0, (double)2.0, (double)12.0), ModernDinnerTableBlock.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)14.0, (double)14.0)});
    static final VoxelShape MODERN_DINNER_TABLE_MIDDLE = Shapes.m_83110_((VoxelShape)ModernDinnerTableBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)ModernDinnerTableBlock.m_49796_((double)0.0, (double)2.0, (double)7.0, (double)16.0, (double)4.0, (double)9.0));
    static final VoxelShape MODERN_DINNER_TABLE_ONE = Shapes.m_83124_((VoxelShape)ModernDinnerTableBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ModernDinnerTableBlock.m_49796_((double)13.0, (double)2.0, (double)7.0, (double)15.0, (double)14.0, (double)9.0), ModernDinnerTableBlock.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0), ModernDinnerTableBlock.m_49796_((double)12.0, (double)0.0, (double)4.0, (double)14.0, (double)2.0, (double)12.0), ModernDinnerTableBlock.m_49796_((double)0.0, (double)2.0, (double)7.0, (double)13.0, (double)4.0, (double)9.0), ModernDinnerTableBlock.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)4.0)});
    static final VoxelShape MODERN_DINNER_TABLE_ONE_SOUTH = ModernDinnerTableBlock.rotateShape(Direction.NORTH, Direction.SOUTH, MODERN_DINNER_TABLE_ONE);
    static final VoxelShape MODERN_DINNER_TABLE_ONE_WEST = ModernDinnerTableBlock.rotateShape(Direction.NORTH, Direction.WEST, MODERN_DINNER_TABLE_ONE);
    static final VoxelShape MODERN_DINNER_TABLE_ONE_EAST = ModernDinnerTableBlock.rotateShape(Direction.NORTH, Direction.EAST, MODERN_DINNER_TABLE_ONE);
    static final VoxelShape MODERN_DINNER_TABLE_MIDDLE_EAST = ModernDinnerTableBlock.rotateShape(Direction.NORTH, Direction.EAST, MODERN_DINNER_TABLE_MIDDLE);
    static final VoxelShape MODERN_DINNER_TABLE_EAST = ModernDinnerTableBlock.rotateShape(Direction.NORTH, Direction.EAST, MODERN_DINNER_TABLE);

    public ModernDinnerTableBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
        this.baseBlockState = this.m_49966_();
        this.baseBlock = this.baseBlockState.m_60734_();
        if ((this.f_60442_.equals(Material.f_76320_) || this.f_60442_.equals(Material.f_76321_)) && ((Object)((Object)this)).getClass().isAssignableFrom(ModernDinnerTableBlock.class)) {
            WOOD_DINNER_MODERN_TABLES.add(new FurnitureBlock(this, "table_modern_dinner"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(ModernDinnerTableBlock.class)) {
            STONE_DINNER_MODERN_TABLES.add(new FurnitureBlock(this, "table_modern_dinner"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodModernDinnerTables() {
        return WOOD_DINNER_MODERN_TABLES.stream();
    }

    public static Stream<FurnitureBlock> streamStoneModernDinnerTables() {
        return STONE_DINNER_MODERN_TABLES.stream();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{AXIS});
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.m_60713_(state.m_60734_())) {
            this.baseBlockState.m_60690_(world, pos, Blocks.f_50016_, pos, false);
            this.baseBlock.m_6807_(this.baseBlockState, world, pos, oldState, false);
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)ctx.m_8125_().m_122427_().m_122434_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    boolean canConnect(BlockState blockState) {
        return PaladinFurnitureMod.getPFMConfig().doTablesOfDifferentMaterialsConnect() ? blockState.m_60734_() instanceof ModernDinnerTableBlock : blockState.m_60734_() == this;
    }

    public boolean isTable(BlockGetter world, BlockPos pos, Direction.Axis direction, int i) {
        BlockState state = world.m_8055_(pos.m_5487_(direction, i));
        if (this.canConnect(state)) {
            Direction.Axis sourceDirection = (Direction.Axis)state.m_61143_(AXIS);
            return sourceDirection.equals((Object)direction);
        }
        return false;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.m_60767_() == Material.f_76320_ || state.m_60767_() == Material.f_76272_) {
            return 20;
        }
        return 0;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction.Axis dir = (Direction.Axis)state.m_61143_(AXIS);
        boolean dirNorthOrSouth = dir.equals((Object)Direction.Axis.X);
        boolean dirWestOrEast = dir.equals((Object)Direction.Axis.Z);
        boolean left = this.isTable(view, pos, dir, -1);
        boolean right = this.isTable(view, pos, dir, 1);
        if (left && right) {
            if (dirNorthOrSouth) {
                return MODERN_DINNER_TABLE_MIDDLE;
            }
            return MODERN_DINNER_TABLE_MIDDLE_EAST;
        }
        if (right) {
            if (dirNorthOrSouth) {
                return MODERN_DINNER_TABLE_ONE_SOUTH;
            }
            return MODERN_DINNER_TABLE_ONE_WEST;
        }
        if (left) {
            if (dirNorthOrSouth) {
                return MODERN_DINNER_TABLE_ONE;
            }
            return MODERN_DINNER_TABLE_ONE_EAST;
        }
        if (dirWestOrEast) {
            return MODERN_DINNER_TABLE_EAST;
        }
        return MODERN_DINNER_TABLE;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

