/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClassicTableBlock
extends Block {
    private final Block baseBlock;
    private static final List<FurnitureBlock> WOOD_CLASSIC_TABLES = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_CLASSIC_TABLES = new ArrayList<FurnitureBlock>();
    private final BlockState baseBlockState;
    static final VoxelShape TABLE_CLASSIC_BASE = ClassicTableBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    static final VoxelShape TABLE_CLASSIC_NORTH_EAST_LEG = ClassicTableBlock.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)4.0);
    static final VoxelShape TABLE_CLASSIC_NORTH_WEST_LEG = ClassicTableBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)15.0, (double)4.0);
    static final VoxelShape TABLE_CLASSIC_SOUTH_WEST_LEG = ClassicTableBlock.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)15.0, (double)14.0);
    static final VoxelShape TABLE_CLASSIC_SOUTH_EAST_LEG = ClassicTableBlock.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)15.0, (double)14.0);
    static final Map<String, VoxelShape> VOXEL_SHAPES = new HashMap<String, VoxelShape>();

    public ClassicTableBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49965_().m_61090_());
        this.baseBlockState = this.m_49966_();
        this.baseBlock = this.baseBlockState.m_60734_();
        if ((this.f_60442_.equals(Material.f_76320_) || this.f_60442_.equals(Material.f_76321_)) && ((Object)((Object)this)).getClass().isAssignableFrom(ClassicTableBlock.class)) {
            WOOD_CLASSIC_TABLES.add(new FurnitureBlock(this, "table_classic"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(ClassicTableBlock.class)) {
            STONE_CLASSIC_TABLES.add(new FurnitureBlock(this, "table_classic"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodClassicTables() {
        return WOOD_CLASSIC_TABLES.stream();
    }

    public static Stream<FurnitureBlock> streamStoneClassicTables() {
        return STONE_CLASSIC_TABLES.stream();
    }

    public boolean m_180643_(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.m_60713_(state.m_60734_())) {
            this.baseBlockState.m_60690_(world, pos, Blocks.f_50016_, pos, false);
            this.baseBlock.m_6807_(this.baseBlockState, world, pos, oldState, false);
        }
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.m_60767_() == Material.f_76320_ || state.m_60767_() == Material.f_76272_) {
            return 20;
        }
        return 0;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.m_49966_();
    }

    public boolean canConnect(BlockState blockState) {
        return PaladinFurnitureMod.getPFMConfig().doTablesOfDifferentMaterialsConnect() ? blockState.m_60734_() instanceof ClassicTableBlock : blockState.m_60734_() == this;
    }

    public FluidState m_5888_(BlockState state) {
        return super.m_5888_(state);
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Boolean north = this.canConnect(world.m_8055_(pos.m_122012_()));
        boolean east = this.canConnect(world.m_8055_(pos.m_122029_()));
        boolean west = this.canConnect(world.m_8055_(pos.m_122024_()));
        boolean south = this.canConnect(world.m_8055_(pos.m_122019_()));
        String key = north.toString() + east + west + south;
        if (!VOXEL_SHAPES.containsKey(key)) {
            ClassicTableBlock.generateVoxelShape(key, north, east, west, south);
        }
        return VOXEL_SHAPES.get(key);
    }

    private static void generateVoxelShape(String key, Boolean north, Boolean east, Boolean west, Boolean south) {
        VoxelShape newVoxelShape = TABLE_CLASSIC_BASE;
        if (!(north.booleanValue() || south.booleanValue() || east.booleanValue() || west.booleanValue())) {
            newVoxelShape = Shapes.m_83124_((VoxelShape)newVoxelShape, (VoxelShape[])new VoxelShape[]{TABLE_CLASSIC_NORTH_EAST_LEG, TABLE_CLASSIC_SOUTH_WEST_LEG, TABLE_CLASSIC_SOUTH_EAST_LEG, TABLE_CLASSIC_NORTH_WEST_LEG});
        }
        if (!north.booleanValue() && !east.booleanValue()) {
            newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_CLASSIC_NORTH_EAST_LEG);
        }
        if (!north.booleanValue() && !west.booleanValue()) {
            newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_CLASSIC_NORTH_WEST_LEG);
        }
        if (!south.booleanValue() && !east.booleanValue()) {
            newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_CLASSIC_SOUTH_EAST_LEG);
        }
        if (!south.booleanValue() && !west.booleanValue()) {
            newVoxelShape = Shapes.m_83110_((VoxelShape)newVoxelShape, (VoxelShape)TABLE_CLASSIC_SOUTH_WEST_LEG);
        }
        VOXEL_SHAPES.put(key, newVoxelShape);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

