/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.BasicToiletBlock;
import com.unlikepaladin.pfm.blocks.blockentities.SinkBlockEntity;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.ParticleIDs;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSinkBlock
extends AbstractCauldronBlock
implements EntityBlock {
    public static final IntegerProperty LEVEL_4 = IntegerProperty.m_61631_((String)"level", (int)0, (int)3);
    final Map<Item, CauldronInteraction> behaviorMap;
    final Predicate<Biome.Precipitation> precipitationPredicate;

    public AbstractSinkBlock(BlockBehaviour.Properties settings, Predicate<Biome.Precipitation> precipitationPredicate, Map<Item, CauldronInteraction> behaviorMap) {
        super(settings, behaviorMap);
        this.behaviorMap = behaviorMap;
        this.precipitationPredicate = precipitationPredicate;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)LEVEL_4, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        stateManager.m_61104_(new Property[]{LEVEL_4});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)ctx.m_8125_());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockState sourceState;
        BlockPos sourcePos = pos.m_7495_().m_7495_();
        ItemStack itemStack = player.m_21120_(hand);
        CauldronInteraction sinkBehavior = this.behaviorMap.get(itemStack.m_41720_());
        if (sinkBehavior != null && itemStack.m_41720_() != Items.f_41852_) {
            return sinkBehavior.m_175710_(state, world, pos, player, hand, itemStack);
        }
        if ((Integer)state.m_61143_((Property)LEVEL_4) < 3 && (sourceState = world.m_8055_(sourcePos)).m_60819_().m_76152_() == Fluids.f_76193_ && !sourceState.m_60819_().m_76178_()) {
            if (sourceState.m_61147_().contains(BlockStateProperties.f_61362_)) {
                world.m_46597_(sourcePos, (BlockState)sourceState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
            } else {
                world.m_46597_(sourcePos, Blocks.f_50016_.m_49966_());
            }
            SinkBlockEntity blockEntity = (SinkBlockEntity)world.m_7702_(pos);
            if (blockEntity != null) {
                blockEntity.setFilling(true);
            }
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)LEVEL_4, (Comparable)Integer.valueOf(3)));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return (Integer)state.m_61143_((Property)LEVEL_4);
    }

    protected void m_142310_(BlockState state, Level world, BlockPos pos, Fluid fluid) {
        if (this.m_142596_(state)) {
            return;
        }
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)LEVEL_4, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)LEVEL_4) + 1)));
        world.m_46796_(1047, pos, 0);
    }

    protected static boolean canFillWithPrecipitation(Level world, Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.RAIN) {
            return world.m_213780_().m_188501_() < 0.05f;
        }
        if (precipitation == Biome.Precipitation.SNOW) {
            return world.m_213780_().m_188501_() < 0.1f;
        }
        return false;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BasicToiletBlock.checkType(type, BlockEntities.SINK_BLOCK_ENTITY, SinkBlockEntity::tick);
    }

    public void m_141997_(BlockState state, Level world, BlockPos pos, Biome.Precipitation precipitation) {
        if (!AbstractSinkBlock.canFillWithPrecipitation(world, precipitation) || (Integer)state.m_61143_((Property)LEVEL_4) == 3 || !this.precipitationPredicate.test(precipitation)) {
            return;
        }
        world.m_46597_(pos, (BlockState)state.m_61122_((Property)LEVEL_4));
    }

    public static void spawnParticles(Direction facing, Level world, BlockPos pos) {
        if (world.f_46443_) {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            if (facing == Direction.EAST) {
                world.m_7106_((ParticleOptions)ParticleIDs.WATER_DROP, (double)x + 0.76, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleIDs.WATER_DROP, (double)x + 0.76, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleIDs.WATER_DROP, (double)x + 0.76, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
            } else if (facing == Direction.SOUTH) {
                world.m_7106_((ParticleOptions)ParticleIDs.WATER_DROP, (double)x + 0.5, (double)y + 1.19, (double)z + 0.76, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleIDs.WATER_DROP, (double)x + 0.5, (double)y + 1.19, (double)z + 0.76, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleIDs.WATER_DROP, (double)x + 0.5, (double)y + 1.19, (double)z + 0.76, 0.0, 0.0, 0.0);
            } else if (facing == Direction.NORTH) {
                world.m_7106_((ParticleOptions)ParticleIDs.WATER_DROP, (double)x + 0.5, (double)y + 1.19, (double)z + 0.24, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleIDs.WATER_DROP, (double)x + 0.5, (double)y + 1.19, (double)z + 0.24, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleIDs.WATER_DROP, (double)x + 0.5, (double)y + 1.19, (double)z + 0.24, 0.0, 0.0, 0.0);
            } else {
                world.m_7106_((ParticleOptions)ParticleIDs.WATER_DROP, (double)x + 0.24, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleIDs.WATER_DROP, (double)x + 0.24, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleIDs.WATER_DROP, (double)x + 0.24, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SinkBlockEntity(pos, state);
    }

    protected double m_142446_(BlockState state) {
        return (6.0 + (double)((Integer)state.m_61143_((Property)LEVEL_4)).intValue() * 3.0) / 16.0;
    }

    protected boolean m_142087_(Fluid fluid) {
        return fluid == Fluids.f_76193_ && this.precipitationPredicate == LayeredCauldronBlock.f_153515_;
    }

    public boolean m_142596_(BlockState state) {
        return (Integer)state.m_61143_((Property)LEVEL_4) == 3;
    }

    public static void decrementFluidLevel(BlockState state, Level world, BlockPos pos) {
        int i = (Integer)state.m_61143_((Property)LEVEL_4) - 1;
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)LEVEL_4, (Comparable)Integer.valueOf(i)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void onFireCollision(BlockState state, Level world, BlockPos pos) {
        if ((Integer)state.m_61143_((Property)LEVEL_4) > 0) {
            AbstractSinkBlock.decrementFluidLevel(state, world, pos);
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!world.f_46443_ && entity.m_6060_() && this.m_151979_(state, pos, entity)) {
            entity.m_20095_();
            if (entity.m_142265_(world, pos)) {
                this.onFireCollision(state, world, pos);
            }
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

