/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core;

import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TextComponents {
    public static TextComponentBuilder empty() {
        return TextComponents.string("");
    }

    public static TextComponentBuilder string(String text) {
        return new TextComponentBuilder(Component.m_237113_((String)text));
    }

    public static TextComponentBuilder number(int number) {
        return new TextComponentBuilder(Component.m_237113_((String)Integer.toString(number)));
    }

    public static TextComponentBuilder number(double number, int decimals) {
        return new TextComponentBuilder(Component.m_237113_((String)String.format("%." + decimals + "f", number)));
    }

    public static TextComponentBuilder number(double number) {
        return new TextComponentBuilder(Component.m_237113_((String)Double.toString(number)));
    }

    public static TextComponentBuilder translation(String translationKey, Object ... arguments) {
        return new TextComponentBuilder(Component.m_237110_((String)translationKey, (Object[])arguments));
    }

    public static TextComponentBuilder translation(String translationKey) {
        return new TextComponentBuilder(Component.m_237115_((String)translationKey));
    }

    public static TextComponentBuilder fromTextComponent(MutableComponent textComponent) {
        return new TextComponentBuilder(textComponent);
    }

    public static TextComponentBuilder fromTextComponent(Component textComponent) {
        return TextComponents.fromTextComponent(textComponent.m_6879_());
    }

    public static String format(Component textComponent) {
        return textComponent.getString();
    }

    public static TextComponentBuilder block(Block block) {
        return TextComponents.translation(block.m_7705_());
    }

    public static TextComponentBuilder blockState(BlockState state) {
        return TextComponents.block(state.m_60734_());
    }

    public static TextComponentBuilder item(Item item) {
        return TextComponents.translation(item.m_5524_());
    }

    public static TextComponentBuilder itemStack(ItemStack stack) {
        return TextComponents.fromTextComponent(stack.m_41786_().m_6879_());
    }

    public static TextComponentBuilder fluid(Fluid fluid) {
        return TextComponents.translation(fluid.getFluidType().getDescriptionId());
    }

    public static TextComponentBuilder fluidStack(FluidStack stack) {
        return TextComponents.fromTextComponent(stack.getDisplayName());
    }

    public static TextComponentBuilder entity(Entity entity) {
        return TextComponents.fromTextComponent(entity.m_8077_() ? entity.m_7770_() : entity.m_5446_());
    }

    public static TextComponentBuilder dimension(ResourceKey<Level> dimension) {
        Object dimensionName = dimension.m_135782_().m_135815_();
        dimensionName = ((String)dimensionName).substring(Math.min(((String)dimensionName).length() - 1, Math.max(0, ((String)dimensionName).indexOf(47) + 1))).toLowerCase();
        dimensionName = ((String)dimensionName).substring(0, 1).toUpperCase() + ((String)dimensionName).substring(1);
        for (int i = 0; i < ((String)dimensionName).length() - 1; ++i) {
            if (((String)dimensionName).charAt(i) != '_' || !Character.isAlphabetic(((String)dimensionName).charAt(i + 1))) continue;
            dimensionName = ((String)dimensionName).substring(0, i) + " " + (String)(i + 2 < ((String)dimensionName).length() ? ((String)dimensionName).substring(i + 1, i + 2).toUpperCase() + ((String)dimensionName).substring(i + 2) : ((String)dimensionName).substring(i + 1).toUpperCase());
        }
        return TextComponents.string((String)dimensionName);
    }

    public static TextComponentBuilder dimension(Level world) {
        return TextComponents.dimension((ResourceKey<Level>)world.m_46472_());
    }

    public static class TextComponentBuilder {
        private final TextComponentBuilder parent;
        private final MutableComponent textComponent;

        private TextComponentBuilder(MutableComponent textComponent, TextComponentBuilder parent) {
            this.textComponent = textComponent;
            this.parent = parent;
        }

        private TextComponentBuilder(MutableComponent textComponent) {
            this(textComponent, null);
        }

        public TextComponentBuilder formatting(ChatFormatting color) {
            this.updateStyle(style -> style.m_131140_(color));
            return this;
        }

        public TextComponentBuilder color(ChatFormatting color) {
            return this.formatting(color);
        }

        public TextComponentBuilder bold() {
            this.updateStyle(style -> style.m_131136_(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder italic() {
            this.updateStyle(style -> style.m_131155_(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder underline() {
            this.updateStyle(style -> style.m_131162_(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder strikethrough() {
            this.updateStyle(style -> style.m_178522_(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder obfuscate() {
            this.updateStyle(style -> style.m_178524_(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder reset() {
            this.updateStyle(style -> Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131155_(Boolean.valueOf(false)).m_131162_(Boolean.valueOf(false)).m_178522_(Boolean.valueOf(false)).m_178524_(Boolean.valueOf(false)));
            return this;
        }

        private void updateStyle(Function<Style, Style> updater) {
            this.textComponent.m_6270_(updater.apply(this.textComponent.m_7383_()));
        }

        public TextComponentBuilder string(String text) {
            return this.append(Component.m_237113_((String)text));
        }

        public TextComponentBuilder translation(String translationKey, Object ... arguments) {
            return this.append(Component.m_237110_((String)translationKey, (Object[])arguments));
        }

        public TextComponentBuilder translation(String translationKey) {
            return this.append(Component.m_237115_((String)translationKey));
        }

        public TextComponentBuilder append(MutableComponent textComponent) {
            this.textComponent.m_7220_((Component)textComponent);
            return new TextComponentBuilder(textComponent, this);
        }

        public MutableComponent get() {
            return this.parent == null ? this.textComponent : this.parent.get();
        }

        public String format() {
            return TextComponents.format((Component)this.get());
        }
    }
}

