/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.grid;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationManager;
import com.refinedmods.refinedstorage.blockentity.grid.GridBlockEntity;
import com.refinedmods.refinedstorage.container.AlternativesContainerMenu;
import com.refinedmods.refinedstorage.render.FluidRenderer;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.screen.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.IReverseTag;

public class AlternativesScreen
extends BaseScreen<AlternativesContainerMenu> {
    private static final int VISIBLE_ROWS = 5;
    private final Screen parent;
    private final ScrollbarWidget scrollbar;
    private final List<Line> lines = new ArrayList<Line>();
    private int type;
    private int slot;
    private ItemStack item;
    private FluidStack fluid;

    private AlternativesScreen(Screen parent, Player player, Component title) {
        super(new AlternativesContainerMenu(player), 175, 143, player.m_150109_(), title);
        this.parent = parent;
        this.scrollbar = new ScrollbarWidget(this, 155, 20, 12, 89);
    }

    public AlternativesScreen(Screen parent, Player player, Component title, ItemStack item, int slot) {
        this(parent, player, title);
        this.type = 0;
        this.slot = slot;
        this.item = item;
        this.fluid = null;
    }

    public AlternativesScreen(Screen parent, Player player, Component title, FluidStack fluid, int slot) {
        this(parent, player, title);
        this.type = 1;
        this.slot = slot;
        this.item = null;
        this.fluid = fluid;
    }

    @Override
    public void onPostInit(int x, int y) {
        this.lines.clear();
        if (this.item != null) {
            this.lines.add(new ItemLine(this.item));
            Collection tagsOfItem = ForgeRegistries.ITEMS.tags().getReverseTag((Object)this.item.m_41720_()).stream().flatMap(IReverseTag::getTagKeys).collect(Collectors.toSet());
            for (TagKey owningTag : tagsOfItem) {
                this.lines.add(new TagLine(owningTag.f_203868_(), GridBlockEntity.ALLOWED_ITEM_TAGS.getValue().get(this.slot).contains(owningTag.f_203868_())));
                int itemCount = 0;
                line = new ItemListLine();
                for (Item itemInTag : ForgeRegistries.ITEMS.tags().getTag(owningTag)) {
                    if (itemCount > 0 && itemCount % 8 == 0) {
                        this.lines.add(line);
                        line = new ItemListLine();
                    }
                    ++itemCount;
                    ((ItemListLine)line).addItem(new ItemStack((ItemLike)itemInTag));
                }
                this.lines.add(line);
            }
        } else if (this.fluid != null) {
            this.lines.add(new FluidLine(this.fluid));
            Collection tagsOfFluid = ForgeRegistries.FLUIDS.tags().getReverseTag((Object)this.fluid.getFluid()).stream().flatMap(IReverseTag::getTagKeys).collect(Collectors.toSet());
            for (TagKey owningTag : tagsOfFluid) {
                this.lines.add(new TagLine(owningTag.f_203868_(), GridBlockEntity.ALLOWED_FLUID_TAGS.getValue().get(this.slot).contains(owningTag.f_203868_())));
                int fluidCount = 0;
                line = new FluidListLine();
                for (Fluid fluidInTag : ForgeRegistries.FLUIDS.tags().getTag(owningTag)) {
                    if (fluidCount > 0 && fluidCount % 8 == 0) {
                        this.lines.add(line);
                        line = new FluidListLine();
                    }
                    ++fluidCount;
                    ((FluidListLine)line).addFluid(new FluidStack(fluidInTag, 1000));
                }
                this.lines.add(line);
            }
        }
        int xx = 8;
        int yy = 20;
        for (int i = 0; i < this.lines.size(); ++i) {
            boolean visible;
            boolean bl = visible = i >= this.scrollbar.getOffset() && i < this.scrollbar.getOffset() + 5;
            if (!visible) continue;
            this.lines.get(i).layoutDependantControls(true, this.f_97735_ + xx + 3, this.f_97736_ + yy + 3);
            yy += 18;
        }
        Button apply = this.addButton(x + 7, y + 114, 50, 20, (Component)Component.m_237115_((String)"gui.refinedstorage.alternatives.apply"), this.lines.size() > 1, true, btn -> this.apply());
        this.addButton(x + apply.m_5711_() + 7 + 4, y + 114, 50, 20, (Component)Component.m_237115_((String)"gui.cancel"), true, true, btn -> this.close());
    }

    @Override
    public void tick(int x, int y) {
        this.scrollbar.setEnabled(this.getRows() > 5);
        this.scrollbar.setMaxOffset(this.getRows() - 5);
    }

    private int getRows() {
        return this.lines.size();
    }

    @Override
    public void renderBackground(PoseStack poseStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", "gui/alternatives.png");
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.scrollbar.render(poseStack);
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY) {
        boolean visible;
        int i;
        this.renderString(poseStack, 7, 7, this.f_96539_.getString());
        int x = 8;
        int y = 20;
        for (i = 0; i < this.lines.size(); ++i) {
            boolean bl = visible = i >= this.scrollbar.getOffset() && i < this.scrollbar.getOffset() + 5;
            if (visible) {
                this.lines.get(i).layoutDependantControls(true, this.f_97735_ + x + 3, this.f_97736_ + y + 3);
                this.lines.get(i).render(poseStack, x, y);
                y += 18;
                continue;
            }
            this.lines.get(i).layoutDependantControls(false, -100, -100);
        }
        x = 8;
        y = 20;
        for (i = 0; i < this.lines.size(); ++i) {
            boolean bl = visible = i >= this.scrollbar.getOffset() && i < this.scrollbar.getOffset() + 5;
            if (!visible) continue;
            this.lines.get(i).renderTooltip(poseStack, x, y, mouseX, mouseY);
            y += 18;
        }
    }

    public void m_94757_(double mx, double my) {
        this.scrollbar.m_94757_(mx, my);
        super.m_94757_(mx, my);
    }

    public boolean m_6375_(double mx, double my, int button) {
        return this.scrollbar.m_6375_(mx, my, button) || super.m_6375_(mx, my, button);
    }

    public boolean m_6348_(double mx, double my, int button) {
        return this.scrollbar.m_6348_(mx, my, button) || super.m_6348_(mx, my, button);
    }

    public boolean m_6050_(double x, double y, double delta) {
        return this.scrollbar.m_6050_(x, y, delta) || super.m_6050_(x, y, delta);
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.close();
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    private void close() {
        this.f_96541_.m_91152_(this.parent);
    }

    private void apply() {
        HashSet<ResourceLocation> allowed = new HashSet<ResourceLocation>();
        for (Line line : this.lines) {
            if (!(line instanceof TagLine)) continue;
            TagLine tagLine = (TagLine)line;
            if (!tagLine.widget.m_93840_()) continue;
            allowed.add(tagLine.tagName);
        }
        if (this.type == 0) {
            existing = GridBlockEntity.ALLOWED_ITEM_TAGS.getValue();
            existing.set(this.slot, allowed);
            BlockEntitySynchronizationManager.setParameter(GridBlockEntity.ALLOWED_ITEM_TAGS, existing);
        } else if (this.type == 1) {
            existing = GridBlockEntity.ALLOWED_FLUID_TAGS.getValue();
            existing.set(this.slot, allowed);
            BlockEntitySynchronizationManager.setParameter(GridBlockEntity.ALLOWED_FLUID_TAGS, existing);
        }
        this.close();
    }

    private class ItemLine
    implements Line {
        private final ItemStack item;

        public ItemLine(ItemStack item) {
            this.item = item;
        }

        @Override
        public void render(PoseStack poseStack, int x, int y) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            AlternativesScreen.this.renderItem(poseStack, x + 3, y + 2, this.item);
            AlternativesScreen.this.renderString(poseStack, x + 4 + 19, y + 7, this.item.m_41786_().getString());
        }
    }

    private class TagLine
    implements Line {
        private final ResourceLocation tagName;
        private final CheckboxWidget widget;

        public TagLine(ResourceLocation tagName, boolean checked) {
            this.tagName = tagName;
            this.widget = AlternativesScreen.this.addCheckBox(-100, -100, (Component)Component.m_237113_((String)RenderUtils.shorten(tagName.toString(), 22)), checked, btn -> {});
            this.widget.setFGColor(-13158601);
            this.widget.setShadow(false);
        }

        @Override
        public void layoutDependantControls(boolean visible, int x, int y) {
            this.widget.f_93624_ = visible;
            this.widget.f_93620_ = x;
            this.widget.f_93621_ = y;
        }
    }

    private class ItemListLine
    implements Line {
        private final List<ItemStack> items = new ArrayList<ItemStack>();

        private ItemListLine() {
        }

        public void addItem(ItemStack stack) {
            this.items.add(stack);
        }

        @Override
        public void render(PoseStack poseStack, int x, int y) {
            for (ItemStack itemInList : this.items) {
                AlternativesScreen.this.renderItem(poseStack, x + 3, y, itemInList);
                x += 17;
            }
        }

        @Override
        public void renderTooltip(PoseStack poseStack, int x, int y, int mx, int my) {
            for (ItemStack itemInList : this.items) {
                if (RenderUtils.inBounds(x + 3, y, 16, 16, mx, my)) {
                    AlternativesScreen.this.renderTooltip(poseStack, itemInList, mx, my, RenderUtils.getTooltipFromItem(itemInList));
                }
                x += 17;
            }
        }
    }

    private class FluidLine
    implements Line {
        private final FluidStack fluid;

        public FluidLine(FluidStack item) {
            this.fluid = item;
        }

        @Override
        public void render(PoseStack poseStack, int x, int y) {
            FluidRenderer.INSTANCE.render(poseStack, x + 3, y + 2, this.fluid);
            AlternativesScreen.this.renderString(poseStack, x + 4 + 19, y + 7, this.fluid.getDisplayName().getString());
        }
    }

    private class FluidListLine
    implements Line {
        private final List<FluidStack> fluids = new ArrayList<FluidStack>();

        private FluidListLine() {
        }

        public void addFluid(FluidStack stack) {
            this.fluids.add(stack);
        }

        @Override
        public void render(PoseStack poseStack, int x, int y) {
            for (FluidStack fluidInList : this.fluids) {
                FluidRenderer.INSTANCE.render(poseStack, x + 3, y, fluidInList);
                x += 17;
            }
        }

        @Override
        public void renderTooltip(PoseStack poseStack, int x, int y, int mx, int my) {
            for (FluidStack fluidInList : this.fluids) {
                if (RenderUtils.inBounds(x + 3, y, 16, 16, mx, my)) {
                    AlternativesScreen.this.renderTooltip(poseStack, mx, my, fluidInList.getDisplayName().getString());
                }
                x += 17;
            }
        }
    }

    private static interface Line {
        default public void render(PoseStack poseStack, int x, int y) {
        }

        default public void renderTooltip(PoseStack poseStack, int x, int y, int mx, int my) {
        }

        default public void layoutDependantControls(boolean visible, int x, int y) {
        }
    }
}

