/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity;

import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationManager;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationSpec;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BaseBlockEntity
extends BlockEntity {
    private final BlockEntitySynchronizationManager dataManager;
    private boolean unloaded;

    protected BaseBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, BlockEntitySynchronizationSpec syncSpec) {
        super(type, pos, state);
        this.dataManager = new BlockEntitySynchronizationManager(this, syncSpec);
    }

    public BlockEntitySynchronizationManager getDataManager() {
        return this.dataManager;
    }

    public CompoundTag writeUpdate(CompoundTag tag) {
        return tag;
    }

    public void readUpdate(CompoundTag tag) {
    }

    public final CompoundTag m_5995_() {
        return this.writeUpdate(super.m_5995_());
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public final void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.readUpdate(packet.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.readUpdate(tag);
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.unloaded) {
            this.onRemovedNotDueToChunkUnload();
        }
    }

    protected void onRemovedNotDueToChunkUnload() {
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.unloaded = true;
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_151543_(this.f_58858_);
        }
    }
}

