/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingManager;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraph;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraphEntry;
import com.refinedmods.refinedstorage.api.network.NetworkType;
import com.refinedmods.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemManager;
import com.refinedmods.refinedstorage.api.network.security.ISecurityManager;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.IStorage;
import com.refinedmods.refinedstorage.api.storage.StorageType;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorage;
import com.refinedmods.refinedstorage.api.storage.tracker.IStorageTracker;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingManager;
import com.refinedmods.refinedstorage.apiimpl.network.NetworkNodeGraph;
import com.refinedmods.refinedstorage.apiimpl.network.grid.handler.FluidGridHandler;
import com.refinedmods.refinedstorage.apiimpl.network.grid.handler.ItemGridHandler;
import com.refinedmods.refinedstorage.apiimpl.network.item.NetworkItemManager;
import com.refinedmods.refinedstorage.apiimpl.network.node.RootNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.security.SecurityManager;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.FluidStorageCache;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.ItemStorageCache;
import com.refinedmods.refinedstorage.apiimpl.storage.tracker.FluidStorageTracker;
import com.refinedmods.refinedstorage.apiimpl.storage.tracker.ItemStorageTracker;
import com.refinedmods.refinedstorage.block.ControllerBlock;
import com.refinedmods.refinedstorage.blockentity.ControllerBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IRedstoneConfigurable;
import com.refinedmods.refinedstorage.blockentity.config.RedstoneMode;
import com.refinedmods.refinedstorage.energy.BaseEnergyStorage;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Network
implements INetwork,
IRedstoneConfigurable {
    private static final int THROTTLE_INACTIVE_TO_ACTIVE = 20;
    private static final int THROTTLE_ACTIVE_TO_INACTIVE = 4;
    private static final int THROTTLE_ENERGY_TYPE_CHANGE = 20;
    private static final String NBT_ENERGY = "Energy";
    private static final String NBT_ITEM_STORAGE_TRACKER_ID = "ItemStorageTrackerId";
    private static final String NBT_FLUID_STORAGE_TRACKER_ID = "FluidStorageTrackerId";
    private static final Logger LOGGER = LogManager.getLogger(Network.class);
    private final IItemGridHandler itemGridHandler = new ItemGridHandler(this);
    private final IFluidGridHandler fluidGridHandler = new FluidGridHandler(this);
    private final INetworkItemManager networkItemManager = new NetworkItemManager(this);
    private final INetworkNodeGraph nodeGraph = new NetworkNodeGraph(this);
    private final ICraftingManager craftingManager = new CraftingManager(this);
    private final ISecurityManager securityManager = new SecurityManager(this);
    private final IStorageCache<ItemStack> itemStorage = new ItemStorageCache(this);
    private final IStorageCache<FluidStack> fluidStorage = new FluidStorageCache(this);
    private final BaseEnergyStorage energy = new BaseEnergyStorage(RS.SERVER_CONFIG.getController().getCapacity(), RS.SERVER_CONFIG.getController().getMaxTransfer(), 0);
    private final RootNetworkNode root;
    private final BlockPos pos;
    private final Level level;
    private final NetworkType type;
    private ItemStorageTracker itemStorageTracker;
    private UUID itemStorageTrackerId;
    private FluidStorageTracker fluidStorageTracker;
    private UUID fluidStorageTrackerId;
    private ControllerBlock.EnergyType lastEnergyType = ControllerBlock.EnergyType.OFF;
    private int lastEnergyUsage;
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    private boolean redstonePowered = false;
    private boolean amILoaded = false;
    private boolean throttlingDisabled = true;
    private boolean couldRun;
    private int ticksSinceUpdateChanged;
    private int ticksSinceEnergyTypeChanged;
    private int ticks;
    private long[] tickTimes = new long[100];
    private int tickCounter = 0;

    public Network(Level level, BlockPos pos, NetworkType type) {
        this.pos = pos;
        this.level = level;
        this.type = type;
        this.root = new RootNetworkNode(this, level, pos);
        this.nodeGraph.addListener(() -> {
            if (!level.m_46749_(pos)) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ControllerBlockEntity) {
                ((ControllerBlockEntity)blockEntity).getDataManager().sendParameterToWatchers(ControllerBlockEntity.NODES);
            }
        });
    }

    public static int getEnergyScaled(int stored, int capacity, int scale) {
        return (int)((float)stored / (float)capacity * (float)scale);
    }

    public static ControllerBlock.EnergyType getEnergyType(int stored, int capacity) {
        int energy = Network.getEnergyScaled(stored, capacity, 100);
        if (energy <= 0) {
            return ControllerBlock.EnergyType.OFF;
        }
        if (energy <= 10) {
            return ControllerBlock.EnergyType.NEARLY_OFF;
        }
        if (energy <= 20) {
            return ControllerBlock.EnergyType.NEARLY_ON;
        }
        return ControllerBlock.EnergyType.ON;
    }

    public RootNetworkNode getRoot() {
        return this.root;
    }

    @Override
    public BlockPos getPosition() {
        return this.pos;
    }

    @Override
    public boolean canRun() {
        return this.amILoaded && this.energy.getEnergyStored() >= this.getEnergyUsage() && this.redstoneMode.isEnabled(this.redstonePowered);
    }

    public void setRedstonePowered(boolean redstonePowered) {
        this.redstonePowered = redstonePowered;
    }

    @Override
    public INetworkNodeGraph getNodeGraph() {
        return this.nodeGraph;
    }

    @Override
    public ISecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public ICraftingManager getCraftingManager() {
        return this.craftingManager;
    }

    @Override
    public void update() {
        if (!this.level.f_46443_) {
            ControllerBlock.EnergyType energyType;
            long tickStart = Util.m_137569_();
            if (this.ticks == 0) {
                this.redstonePowered = this.level.m_46753_(this.pos);
            }
            ++this.ticks;
            this.amILoaded = this.level.m_46749_(this.pos);
            this.updateEnergyUsage();
            if (this.canRun()) {
                this.craftingManager.update();
                if (!this.craftingManager.getTasks().isEmpty()) {
                    this.markDirty();
                }
            }
            if (this.type == NetworkType.NORMAL) {
                if (!RS.SERVER_CONFIG.getController().getUseEnergy()) {
                    this.energy.setStored(this.energy.getMaxEnergyStored());
                } else {
                    this.energy.extractEnergyBypassCanExtract(this.getEnergyUsage(), false);
                }
            } else if (this.type == NetworkType.CREATIVE) {
                this.energy.setStored(this.energy.getMaxEnergyStored());
            }
            boolean canRun = this.canRun();
            if (this.couldRun != canRun) {
                ++this.ticksSinceUpdateChanged;
                if ((!canRun ? this.ticksSinceUpdateChanged > 4 : this.ticksSinceUpdateChanged > 20) || this.throttlingDisabled) {
                    this.ticksSinceUpdateChanged = 0;
                    this.couldRun = canRun;
                    this.throttlingDisabled = false;
                    LOGGER.debug("Network at position {} changed running state to {}, causing an invalidation of the node graph", (Object)this.pos, (Object)this.couldRun);
                    this.nodeGraph.invalidate(Action.PERFORM, this.level, this.pos);
                    this.securityManager.invalidate();
                }
            } else {
                this.ticksSinceUpdateChanged = 0;
            }
            if (this.lastEnergyType != (energyType = this.getEnergyType())) {
                ++this.ticksSinceEnergyTypeChanged;
                if (this.ticksSinceEnergyTypeChanged > 20) {
                    this.lastEnergyType = energyType;
                    BlockState state = this.level.m_8055_(this.pos);
                    if (state.m_60734_() instanceof ControllerBlock) {
                        this.level.m_46597_(this.pos, (BlockState)state.m_61124_(ControllerBlock.ENERGY_TYPE, (Comparable)((Object)energyType)));
                    }
                }
            } else {
                this.ticksSinceEnergyTypeChanged = 0;
            }
            this.tickTimes[this.tickCounter % this.tickTimes.length] = Util.m_137569_() - tickStart;
            ++this.tickCounter;
        }
    }

    @Override
    public IItemGridHandler getItemGridHandler() {
        return this.itemGridHandler;
    }

    @Override
    public IFluidGridHandler getFluidGridHandler() {
        return this.fluidGridHandler;
    }

    @Override
    public INetworkItemManager getNetworkItemManager() {
        return this.networkItemManager;
    }

    @Override
    public void onRemoved() {
        for (ICraftingTask task : this.craftingManager.getTasks()) {
            task.onCancelled();
        }
        this.nodeGraph.disconnectAll();
        API.instance().getStorageTrackerManager((ServerLevel)this.getLevel()).remove(this.itemStorageTrackerId);
        API.instance().getStorageTrackerManager((ServerLevel)this.getLevel()).remove(this.fluidStorageTrackerId);
    }

    @Override
    public IStorageCache<ItemStack> getItemStorageCache() {
        return this.itemStorage;
    }

    @Override
    public IStorageCache<FluidStack> getFluidStorageCache() {
        return this.fluidStorage;
    }

    @Override
    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack stack, int size, Action action) {
        if (stack.m_41619_()) {
            return stack;
        }
        if (this.itemStorage.getStorages().isEmpty()) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
        }
        ItemStack remainder = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
        int inserted = 0;
        int insertedExternally = 0;
        for (IStorage<ItemStack> storage : this.itemStorage.getStorages()) {
            if (storage.getAccessType() == AccessType.EXTRACT) continue;
            int storedPre = storage.getStored();
            remainder = storage.insert(remainder, size, action);
            if (action == Action.PERFORM) {
                inserted += storage.getCacheDelta(storedPre, size, remainder);
            }
            if (remainder.m_41619_()) {
                if (!(storage instanceof IExternalStorage) || action != Action.PERFORM) break;
                ((IExternalStorage)storage).update(this);
                insertedExternally += size;
                break;
            }
            if (size != remainder.m_41613_() && storage instanceof IExternalStorage && action == Action.PERFORM) {
                ((IExternalStorage)storage).update(this);
                insertedExternally += size - remainder.m_41613_();
            }
            size = remainder.m_41613_();
        }
        if (action == Action.PERFORM && inserted - insertedExternally > 0) {
            this.itemStorage.add(stack, inserted - insertedExternally, false, false);
        }
        return remainder;
    }

    @Override
    @Nonnull
    public ItemStack extractItem(@Nonnull ItemStack stack, int size, int flags, Action action, Predicate<IStorage<ItemStack>> filter) {
        if (stack.m_41619_()) {
            return stack;
        }
        int requested = size;
        int received = 0;
        int extractedExternally = 0;
        ItemStack newStack = ItemStack.f_41583_;
        for (IStorage<ItemStack> storage : this.itemStorage.getStorages()) {
            ItemStack took = ItemStack.f_41583_;
            if (filter.test(storage) && storage.getAccessType() != AccessType.INSERT) {
                took = storage.extract(stack, requested - received, flags, action);
            }
            if (!took.m_41619_()) {
                if (storage instanceof IExternalStorage && action == Action.PERFORM) {
                    ((IExternalStorage)storage).update(this);
                    extractedExternally += took.m_41613_();
                }
                if (newStack.m_41619_()) {
                    newStack = took;
                } else {
                    newStack.m_41769_(took.m_41613_());
                }
                received += took.m_41613_();
            }
            if (requested != received) continue;
            break;
        }
        if (newStack.m_41613_() - extractedExternally > 0 && action == Action.PERFORM) {
            this.itemStorage.remove(newStack, newStack.m_41613_() - extractedExternally, false);
        }
        return newStack;
    }

    @Override
    @Nonnull
    public FluidStack insertFluid(@Nonnull FluidStack stack, int size, Action action) {
        if (stack.isEmpty()) {
            return stack;
        }
        if (this.fluidStorage.getStorages().isEmpty()) {
            return StackUtils.copy(stack, size);
        }
        FluidStack remainder = StackUtils.copy(stack, size);
        int inserted = 0;
        int insertedExternally = 0;
        for (IStorage<FluidStack> storage : this.fluidStorage.getStorages()) {
            if (storage.getAccessType() == AccessType.EXTRACT) continue;
            int storedPre = storage.getStored();
            remainder = storage.insert(remainder, size, action);
            if (action == Action.PERFORM) {
                inserted += storage.getCacheDelta(storedPre, size, remainder);
            }
            if (remainder.isEmpty()) {
                if (!(storage instanceof IExternalStorage) || action != Action.PERFORM) break;
                ((IExternalStorage)storage).update(this);
                insertedExternally += size;
                break;
            }
            if (size != remainder.getAmount() && storage instanceof IExternalStorage && action == Action.PERFORM) {
                ((IExternalStorage)storage).update(this);
                insertedExternally += size - remainder.getAmount();
            }
            size = remainder.getAmount();
        }
        if (action == Action.PERFORM && inserted - insertedExternally > 0) {
            this.fluidStorage.add(stack, inserted - insertedExternally, false, false);
        }
        return remainder;
    }

    @Override
    @Nonnull
    public FluidStack extractFluid(@Nonnull FluidStack stack, int size, int flags, Action action, Predicate<IStorage<FluidStack>> filter) {
        if (stack.isEmpty()) {
            return stack;
        }
        int requested = size;
        int received = 0;
        int extractedExternally = 0;
        FluidStack newStack = FluidStack.EMPTY;
        for (IStorage<FluidStack> storage : this.fluidStorage.getStorages()) {
            FluidStack took = FluidStack.EMPTY;
            if (filter.test(storage) && storage.getAccessType() != AccessType.INSERT) {
                took = storage.extract(stack, requested - received, flags, action);
            }
            if (!took.isEmpty()) {
                if (storage instanceof IExternalStorage && action == Action.PERFORM) {
                    ((IExternalStorage)storage).update(this);
                    extractedExternally += took.getAmount();
                }
                if (newStack.isEmpty()) {
                    newStack = took;
                } else {
                    newStack.grow(took.getAmount());
                }
                received += took.getAmount();
            }
            if (requested != received) continue;
            break;
        }
        if (newStack.getAmount() - extractedExternally > 0 && action == Action.PERFORM) {
            this.fluidStorage.remove(newStack, newStack.getAmount() - extractedExternally, false);
        }
        return newStack;
    }

    @Override
    public IStorageTracker<ItemStack> getItemStorageTracker() {
        if (this.itemStorageTracker == null) {
            if (this.itemStorageTrackerId == null) {
                this.itemStorageTrackerId = UUID.randomUUID();
            }
            this.itemStorageTracker = (ItemStorageTracker)API.instance().getStorageTrackerManager((ServerLevel)this.level).getOrCreate(this.itemStorageTrackerId, StorageType.ITEM);
        }
        return this.itemStorageTracker;
    }

    @Override
    public IStorageTracker<FluidStack> getFluidStorageTracker() {
        if (this.fluidStorageTracker == null) {
            if (this.fluidStorageTrackerId == null) {
                this.fluidStorageTrackerId = UUID.randomUUID();
            }
            this.fluidStorageTracker = (FluidStorageTracker)API.instance().getStorageTrackerManager((ServerLevel)this.level).getOrCreate(this.fluidStorageTrackerId, StorageType.FLUID);
        }
        return this.fluidStorageTracker;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public INetwork readFromNbt(CompoundTag tag) {
        if (tag.m_128441_(NBT_ENERGY)) {
            this.energy.setStored(tag.m_128451_(NBT_ENERGY));
        }
        this.redstoneMode = RedstoneMode.read(tag);
        this.craftingManager.readFromNbt(tag);
        if (tag.m_128441_(NBT_ITEM_STORAGE_TRACKER_ID)) {
            this.itemStorageTrackerId = tag.m_128342_(NBT_ITEM_STORAGE_TRACKER_ID);
        }
        if (tag.m_128441_(NBT_FLUID_STORAGE_TRACKER_ID)) {
            this.fluidStorageTrackerId = tag.m_128342_(NBT_FLUID_STORAGE_TRACKER_ID);
        }
        return this;
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        tag.m_128405_(NBT_ENERGY, this.energy.getEnergyStored());
        this.redstoneMode.write(tag);
        this.craftingManager.writeToNbt(tag);
        if (this.itemStorageTrackerId != null) {
            tag.m_128362_(NBT_ITEM_STORAGE_TRACKER_ID, this.itemStorageTrackerId);
        }
        if (this.fluidStorageTrackerId != null) {
            tag.m_128362_(NBT_FLUID_STORAGE_TRACKER_ID, this.fluidStorageTrackerId);
        }
        return tag;
    }

    @Override
    public long[] getTickTimes() {
        return this.tickTimes;
    }

    @Override
    public void markDirty() {
        API.instance().getNetworkManager((ServerLevel)this.level).markForSaving();
    }

    public ControllerBlock.EnergyType getEnergyType() {
        if (!this.redstoneMode.isEnabled(this.redstonePowered)) {
            return ControllerBlock.EnergyType.OFF;
        }
        return Network.getEnergyType(this.energy.getEnergyStored(), this.energy.getMaxEnergyStored());
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        this.markDirty();
    }

    private void updateEnergyUsage() {
        if (!this.redstoneMode.isEnabled(this.redstonePowered)) {
            this.lastEnergyUsage = 0;
            return;
        }
        int usage = RS.SERVER_CONFIG.getController().getBaseUsage();
        for (INetworkNodeGraphEntry entry : this.nodeGraph.all()) {
            if (!entry.getNode().isActive()) continue;
            usage += entry.getNode().getEnergyUsage();
        }
        this.lastEnergyUsage = usage;
    }

    @Override
    public int getEnergyUsage() {
        return this.lastEnergyUsage;
    }

    @Override
    public IEnergyStorage getEnergyStorage() {
        return this.energy;
    }

    @Override
    public NetworkType getType() {
        return this.type;
    }
}

