/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.Type;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.placebo.util.StepFunction;

public class ChancedEffectInstance {
    public static Codec<ChancedEffectInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("chance").forGetter(a -> Float.valueOf(a.chance)), (App)ForgeRegistries.MOB_EFFECTS.getCodec().fieldOf("effect").forGetter(a -> a.effect), (App)StepFunction.CODEC.optionalFieldOf("amplifier", (Object)StepFunction.constant((float)0.0f)).forGetter(a -> a.amp), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)true).forGetter(a -> a.ambient), (App)Codec.BOOL.optionalFieldOf("visible", (Object)false).forGetter(a -> a.visible)).apply((Applicative)inst, ChancedEffectInstance::new));
    protected final float chance;
    protected final MobEffect effect;
    protected final StepFunction amp;
    protected final boolean ambient;
    protected final boolean visible;

    public ChancedEffectInstance(float chance, MobEffect effect, StepFunction amp, boolean ambient, boolean visible) {
        this.chance = chance;
        this.effect = effect;
        this.amp = amp;
        this.ambient = ambient;
        this.visible = visible;
    }

    public float getChance() {
        return this.chance;
    }

    public MobEffect getEffect() {
        return this.effect;
    }

    public MobEffectInstance createInstance(RandomSource rand, int duration) {
        return new MobEffectInstance(this.effect, duration, this.amp.getInt(rand.m_188501_()), this.ambient, this.visible);
    }

    public static class Deserializer
    implements JsonDeserializer<ChancedEffectInstance> {
        public ChancedEffectInstance deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            boolean visible;
            JsonObject obj = json.getAsJsonObject();
            float chance = obj.get("chance").getAsFloat();
            String _effect = obj.get("effect").getAsString();
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(_effect));
            if (effect == null) {
                throw new JsonParseException("Attempted to construct a ChancedEffectInstance with invalid effect: " + _effect);
            }
            boolean ambient = obj.has("ambient") ? obj.get("ambient").getAsBoolean() : true;
            boolean bl = visible = obj.has("visible") ? obj.get("visible").getAsBoolean() : false;
            if (obj.has("amplifier")) {
                int max;
                JsonObject range = obj.get("amplifier").getAsJsonObject();
                int min = range.get("min").getAsInt();
                StepFunction func = min == (max = range.get("max").getAsInt()) ? StepFunction.constant((float)min) : new StepFunction((float)min, max - min, 1.0f);
                return new ChancedEffectInstance(chance, effect, func, ambient, visible);
            }
            return new ChancedEffectInstance(chance, effect, StepFunction.constant((float)0.0f), ambient, visible);
        }
    }
}

