/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.compat;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.ench.enchantments.InertEnchantment;
import shadows.apotheosis.ench.table.EnchantingRecipe;
import shadows.apotheosis.ench.table.EnchantingStatManager;

public class EnchantingCategory
implements IRecipeCategory<EnchantingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("apotheosis", "enchanting");
    public static final RecipeType<EnchantingRecipe> TYPE = RecipeType.create((String)"apotheosis", (String)"enchanting", EnchantingRecipe.class);
    public static final ResourceLocation TEXTURES = new ResourceLocation("apotheosis", "textures/gui/enchanting_jei.png");
    private static final Map<Class<?>, Extension<?>> EXTENSIONS = new HashMap();
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public EnchantingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURES, 0, 0, 170, 56);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.f_50201_));
        this.localizedName = Component.m_237115_((String)"apotheosis.recipes.enchanting");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public RecipeType<EnchantingRecipe> getRecipeType() {
        return TYPE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EnchantingRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 6, 6);
        IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 37, 6);
        Extension<?> ext = EXTENSIONS.get(recipe.getClass());
        if (ext != null) {
            ext.setRecipe(builder, input, output, recipe, focuses);
        } else {
            input.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(recipe.getInput().m_43908_()));
            output.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.m_8043_());
        }
    }

    public void draw(EnchantingRecipe recipe, IRecipeSlotsView slots, PoseStack stack, double mouseX, double mouseY) {
        boolean hover = false;
        if (mouseX > 57.0 && mouseX <= 165.0 && mouseY > 4.0 && mouseY <= 23.0) {
            GuiComponent.m_93143_((PoseStack)stack, (int)57, (int)4, (int)0, (float)0.0f, (float)71.0f, (int)108, (int)19, (int)256, (int)256);
            hover = true;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        EnchantingStatManager.Stats stats = recipe.getRequirements();
        EnchantingStatManager.Stats maxStats = recipe.getMaxRequirements();
        font.m_92883_(stack, I18n.m_118938_((String)"gui.apotheosis.enchant.eterna", (Object[])new Object[0]), 16.0f, 26.0f, 4044093);
        font.m_92883_(stack, I18n.m_118938_((String)"gui.apotheosis.enchant.quanta", (Object[])new Object[0]), 16.0f, 36.0f, 16536660);
        font.m_92883_(stack, I18n.m_118938_((String)"gui.apotheosis.enchant.arcana", (Object[])new Object[0]), 16.0f, 46.0f, 0xA800A8);
        int level = (int)(stats.eterna() * 2.0f);
        String s = "" + level;
        int width = 86 - font.m_92895_(s);
        EnchantmentNames.m_98734_().m_98735_((long)recipe.m_6423_().hashCode());
        FormattedText itextproperties = EnchantmentNames.m_98734_().m_98737_(font, width);
        int color = hover ? 0xFFFF80 : 6839882;
        EnchantingCategory.drawWordWrap(font, itextproperties, 77, 6, width, color, stack);
        color = 8453920;
        font.m_92750_(stack, s, (float)(77 + width), 13.0f, color);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURES);
        int[] pos = new int[]{(int)(stats.eterna() / EnchantingStatManager.getAbsoluteMaxEterna() * 110.0f), (int)(stats.quanta() / 100.0f * 110.0f), (int)(stats.arcana() / 100.0f * 110.0f)};
        if (stats.eterna() > 0.0f) {
            GuiComponent.m_93133_((PoseStack)stack, (int)56, (int)27, (float)0.0f, (float)56.0f, (int)pos[0], (int)5, (int)256, (int)256);
        }
        if (stats.quanta() > 0.0f) {
            GuiComponent.m_93133_((PoseStack)stack, (int)56, (int)37, (float)0.0f, (float)61.0f, (int)pos[1], (int)5, (int)256, (int)256);
        }
        if (stats.arcana() > 0.0f) {
            GuiComponent.m_93133_((PoseStack)stack, (int)56, (int)47, (float)0.0f, (float)66.0f, (int)pos[2], (int)5, (int)256, (int)256);
        }
        RenderSystem.m_69478_();
        if (maxStats.eterna() > 0.0f) {
            GuiComponent.m_93133_((PoseStack)stack, (int)(56 + pos[0]), (int)27, (float)pos[0], (float)90.0f, (int)((int)((maxStats.eterna() - stats.eterna()) / EnchantingStatManager.getAbsoluteMaxEterna() * 110.0f)), (int)5, (int)256, (int)256);
        }
        if (maxStats.quanta() > 0.0f) {
            GuiComponent.m_93133_((PoseStack)stack, (int)(56 + pos[1]), (int)37, (float)pos[1], (float)95.0f, (int)((int)((maxStats.quanta() - stats.quanta()) / 100.0f * 110.0f)), (int)5, (int)256, (int)256);
        }
        if (maxStats.arcana() > 0.0f) {
            GuiComponent.m_93133_((PoseStack)stack, (int)(56 + pos[2]), (int)47, (float)pos[2], (float)100.0f, (int)((int)((maxStats.arcana() - stats.arcana()) / 100.0f * 110.0f)), (int)5, (int)256, (int)256);
        }
        RenderSystem.m_69461_();
        Screen scn = Minecraft.m_91087_().f_91080_;
        if (scn == null) {
            return;
        }
        if (hover) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237110_((String)"container.enchant.clue", (Object[])new Object[]{((InertEnchantment)((Object)Apoth.Enchantments.INFUSION.get())).m_44700_(1).getString()}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            scn.m_96597_(stack, list, (int)mouseX, (int)mouseY);
        } else if (mouseX > 56.0 && mouseX <= 166.0 && mouseY > 26.0 && mouseY <= 32.0) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)"gui.apotheosis.enchant.eterna").m_130940_(ChatFormatting.GREEN));
            if (maxStats.eterna() == stats.eterna()) {
                list.add(Component.m_237110_((String)"info.apotheosis.eterna_exact", (Object[])new Object[]{Float.valueOf(stats.eterna()), Float.valueOf(EnchantingStatManager.getAbsoluteMaxEterna())}).m_130940_(ChatFormatting.GRAY));
            } else {
                list.add(Component.m_237110_((String)"info.apotheosis.eterna_at_least", (Object[])new Object[]{Float.valueOf(stats.eterna()), Float.valueOf(EnchantingStatManager.getAbsoluteMaxEterna())}).m_130940_(ChatFormatting.GRAY));
                if (maxStats.eterna() > -1.0f) {
                    list.add(Component.m_237110_((String)"info.apotheosis.eterna_at_most", (Object[])new Object[]{Float.valueOf(maxStats.eterna()), Float.valueOf(EnchantingStatManager.getAbsoluteMaxEterna())}).m_130940_(ChatFormatting.GRAY));
                }
            }
            scn.m_96597_(stack, list, (int)mouseX, (int)mouseY);
        } else if (mouseX > 56.0 && mouseX <= 166.0 && mouseY > 36.0 && mouseY <= 42.0) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)"gui.apotheosis.enchant.quanta").m_130940_(ChatFormatting.RED));
            if (maxStats.quanta() == stats.quanta()) {
                list.add(Component.m_237110_((String)"info.apotheosis.percent_exact", (Object[])new Object[]{Float.valueOf(stats.quanta())}).m_130940_(ChatFormatting.GRAY));
            } else {
                list.add(Component.m_237110_((String)"info.apotheosis.percent_at_least", (Object[])new Object[]{Float.valueOf(stats.quanta())}).m_130940_(ChatFormatting.GRAY));
                if (maxStats.quanta() > -1.0f) {
                    list.add(Component.m_237110_((String)"info.apotheosis.percent_at_most", (Object[])new Object[]{Float.valueOf(maxStats.quanta())}).m_130940_(ChatFormatting.GRAY));
                }
            }
            scn.m_96597_(stack, list, (int)mouseX, (int)mouseY);
        } else if (mouseX > 56.0 && mouseX <= 166.0 && mouseY > 46.0 && mouseY <= 52.0) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)"gui.apotheosis.enchant.arcana").m_130940_(ChatFormatting.DARK_PURPLE));
            if (maxStats.arcana() == stats.arcana()) {
                list.add(Component.m_237110_((String)"info.apotheosis.percent_exact", (Object[])new Object[]{Float.valueOf(stats.arcana())}).m_130940_(ChatFormatting.GRAY));
            } else {
                list.add(Component.m_237110_((String)"info.apotheosis.percent_at_least", (Object[])new Object[]{Float.valueOf(stats.arcana())}).m_130940_(ChatFormatting.GRAY));
                if (maxStats.arcana() > -1.0f) {
                    list.add(Component.m_237110_((String)"info.apotheosis.percent_at_most", (Object[])new Object[]{Float.valueOf(maxStats.arcana())}).m_130940_(ChatFormatting.GRAY));
                }
            }
            scn.m_96597_(stack, list, (int)mouseX, (int)mouseY);
        }
    }

    public static void drawWordWrap(Font font, FormattedText pText, int pX, int pY, int pMaxWidth, int pColor, PoseStack stack) {
        for (FormattedCharSequence formattedcharsequence : font.m_92923_(pText, pMaxWidth)) {
            font.m_92877_(stack, formattedcharsequence, (float)pX, (float)pY, pColor);
            pY += 9;
        }
    }

    public static <T extends EnchantingRecipe> void registerExtension(Class<T> cls, Extension<T> ext) {
        EXTENSIONS.put(cls, ext);
    }

    public static interface Extension<T extends EnchantingRecipe> {
        public void setRecipe(IRecipeLayoutBuilder var1, IRecipeSlotBuilder var2, IRecipeSlotBuilder var3, EnchantingRecipe var4, IFocusGroup var5);
    }
}

