/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.loot;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixManager;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.json.DynamicRegistryObject;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.json.TypeKeyed;

public class LootRarityManager
extends PlaceboJsonReloadListener<LootRarity.RarityStub> {
    public static final LootRarityManager INSTANCE = new LootRarityManager();
    public static final DynamicRegistryObject<LootRarity.RarityStub> COMMON = INSTANCE.makeObj(Apotheosis.loc("common"));
    public static final DynamicRegistryObject<LootRarity.RarityStub> UNCOMMON = INSTANCE.makeObj(Apotheosis.loc("uncommon"));
    public static final DynamicRegistryObject<LootRarity.RarityStub> RARE = INSTANCE.makeObj(Apotheosis.loc("rare"));
    public static final DynamicRegistryObject<LootRarity.RarityStub> EPIC = INSTANCE.makeObj(Apotheosis.loc("epic"));
    public static final DynamicRegistryObject<LootRarity.RarityStub> MYTHIC = INSTANCE.makeObj(Apotheosis.loc("mythic"));
    public static final DynamicRegistryObject<LootRarity.RarityStub> ANCIENT = INSTANCE.makeObj(Apotheosis.loc("ancient"));
    protected Map<String, LootRarity> byId = new HashMap<String, LootRarity>();
    protected List<LootRarity> list = new ArrayList<LootRarity>(6);

    private LootRarityManager() {
        super(AdventureModule.LOGGER, "rarities", false, false);
    }

    protected void onReload() {
        super.onReload();
        Preconditions.checkArgument((COMMON.get() != null ? 1 : 0) != 0, (Object)"Common rarity not registered!");
        Preconditions.checkArgument((UNCOMMON.get() != null ? 1 : 0) != 0, (Object)"Uncommon rarity not registered!");
        Preconditions.checkArgument((RARE.get() != null ? 1 : 0) != 0, (Object)"Rare rarity not registered!");
        Preconditions.checkArgument((EPIC.get() != null ? 1 : 0) != 0, (Object)"Epic rarity not registered!");
        Preconditions.checkArgument((MYTHIC.get() != null ? 1 : 0) != 0, (Object)"Mythic rarity not registered!");
        Preconditions.checkArgument((ANCIENT.get() != null ? 1 : 0) != 0, (Object)"Ancient rarity not registered!");
        Preconditions.checkArgument((this.registry.size() == 6 ? 1 : 0) != 0, (Object)"Registration of additional rarity levels is not supported!");
        Preconditions.checkArgument((this.registry.values().stream().mapToInt(LootRarity.RarityStub::getWeight).sum() > 0 ? 1 : 0) != 0, (Object)"The total weight of all rarities must be above 0");
        LootRarity.COMMON.update((LootRarity.RarityStub)COMMON.get());
        LootRarity.UNCOMMON.update((LootRarity.RarityStub)UNCOMMON.get());
        LootRarity.RARE.update((LootRarity.RarityStub)RARE.get());
        LootRarity.EPIC.update((LootRarity.RarityStub)EPIC.get());
        LootRarity.MYTHIC.update((LootRarity.RarityStub)MYTHIC.get());
        for (LootRarity rarity : LootRarity.values()) {
            if (rarity == LootRarity.ANCIENT) continue;
            HashMap<AffixType, List> sorted = new HashMap<AffixType, List>();
            rarity.rules().stream().filter(r -> r.type().needsValidation()).forEach(rule -> {
                sorted.computeIfAbsent(rule.type(), r -> new ArrayList());
                ((List)sorted.get((Object)rule.type())).add(rule);
            });
            sorted.forEach((type, rules) -> {
                for (LootCategory cat : LootCategory.VALUES) {
                    List<Affix> affixes;
                    if (cat.isNone() || (affixes = AffixManager.INSTANCE.getValues().stream().filter(a -> a.canApplyTo(ItemStack.f_41583_, cat, rarity) && a.getType() == type).toList()).size() >= rules.size()) continue;
                    StringBuilder errMsg = new StringBuilder();
                    errMsg.append("Insufficient number of affixes to satisfy the loot rules (ignoring backup rules) of rarity " + rarity.id() + " for category " + cat.getName());
                    errMsg.append("Required: " + rules.size());
                    errMsg.append("; Provided: " + affixes.size());
                    AdventureModule.LOGGER.error(errMsg.toString());
                }
            });
        }
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(DEFAULT, LootRarity.RarityStub.SERIALIZER);
    }

    protected void validateItem(LootRarity.RarityStub item) {
        super.validateItem((TypeKeyed)item);
        Preconditions.checkArgument((item.getWeight() >= 0 ? 1 : 0) != 0, (Object)"A rarity may not have negative weight!");
        Preconditions.checkArgument((item.getQuality() >= 0.0f ? 1 : 0) != 0, (Object)"A rarity may not have negative quality!");
        Preconditions.checkArgument((!item.rules().isEmpty() ? 1 : 0) != 0, (Object)"A rarity may not have no rules!");
    }
}

