/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.compat;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.boss.BossItem;
import shadows.apotheosis.adventure.boss.BossItemManager;
import shadows.apotheosis.adventure.compat.GameStagesCompat;
import shadows.apotheosis.adventure.loot.AffixLootEntry;
import shadows.apotheosis.adventure.loot.AffixLootManager;
import shadows.apotheosis.adventure.loot.LootController;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.gate.Reward;
import shadows.gateways.gate.WaveEntity;
import shadows.placebo.json.WeightedJsonReloadListener;

public class GatewaysCompat {
    public static void register() {
        WaveEntity.CODECS.put((Object)Apotheosis.loc("boss"), BossWaveEntity.CODEC);
        Reward.CODECS.put((Object)Apotheosis.loc("affix"), RarityAffixItemReward.CODEC);
    }

    public static class BossWaveEntity
    implements WaveEntity {
        public static Codec<BossWaveEntity> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.f_135803_.optionalFieldOf("boss").forGetter(b -> b.bossId)).apply((Applicative)inst, BossWaveEntity::new));
        private final Optional<ResourceLocation> bossId;
        private final Supplier<BossItem> boss;

        public BossWaveEntity(Optional<ResourceLocation> bossId) {
            this.bossId = bossId;
            this.boss = Suppliers.memoize(() -> bossId.map(arg_0 -> ((BossItemManager)BossItemManager.INSTANCE).getValue(arg_0)).orElse(null));
        }

        public LivingEntity createEntity(Level level) {
            BossItem realBoss;
            BossItem bossItem = realBoss = this.bossId.isEmpty() ? (BossItem)BossItemManager.INSTANCE.getRandomItem(level.f_46441_) : this.boss.get();
            if (realBoss == null) {
                return null;
            }
            return realBoss.createBoss((ServerLevelAccessor)level, BlockPos.f_121853_, level.f_46441_, 0.0f);
        }

        public Component getDescription() {
            return Component.m_237110_((String)"misc.apotheosis.boss", (Object[])new Object[]{Component.m_237115_((String)(this.bossId.isEmpty() ? "misc.apotheosis.random" : this.boss.get().getEntity().m_20675_()))});
        }

        public AABB getAABB(double x, double y, double z) {
            return (this.bossId.isEmpty() ? new AABB(0.0, 0.0, 0.0, 2.0, 2.0, 2.0) : this.boss.get().getSize()).m_82386_(x, y, z);
        }

        public boolean shouldFinalizeSpawn() {
            return false;
        }

        public Codec<? extends WaveEntity> getCodec() {
            return CODEC;
        }
    }

    public record RarityAffixItemReward(LootRarity rarity) implements Reward
    {
        public static Codec<RarityAffixItemReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.CODEC.fieldOf("rarity").forGetter(RarityAffixItemReward::rarity)).apply((Applicative)inst, RarityAffixItemReward::new));

        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            list.accept(LootController.createLootItem(((AffixLootEntry)AffixLootManager.INSTANCE.getRandomItem(level.f_46441_, summoner.m_36336_(), new Predicate[]{WeightedJsonReloadListener.IDimensional.matches((Level)level), GameStagesCompat.IStaged.matches(summoner)})).getStack(), this.rarity, level.f_46441_));
        }

        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)Component.m_237110_((String)"reward.apotheosis.affix", (Object[])new Object[]{this.rarity.toComponent()}));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }
}

