/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket.gem.bonus.special;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.socket.gem.GemClass;
import shadows.apotheosis.adventure.affix.socket.gem.GemItem;
import shadows.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.codec.EnumCodec;
import shadows.placebo.util.StepFunction;

public class AllStatsBonus
extends GemBonus {
    public static Codec<AllStatsBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(AllStatsBonus.gemClass(), (App)new EnumCodec(AttributeModifier.Operation.class).fieldOf("operation").forGetter(a -> a.operation), (App)VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, AllStatsBonus::new));
    protected final AttributeModifier.Operation operation;
    protected final Map<LootRarity, StepFunction> values;
    protected final transient List<Attribute> attributes = new ArrayList<Attribute>();

    public AllStatsBonus(GemClass gemClass, AttributeModifier.Operation op, Map<LootRarity, StepFunction> values) {
        super(Apotheosis.loc("all_stats"), gemClass);
        this.operation = op;
        this.values = values;
        Registry.f_122866_.m_123024_().filter(arg_0 -> ((AttributeSupplier)((AttributeSupplier)ForgeHooks.getAttributesView().get(EntityType.f_20532_))).m_22258_(arg_0)).forEach(this.attributes::add);
    }

    @Override
    public void addModifiers(ItemStack gem, LootRarity rarity, BiConsumer<Attribute, AttributeModifier> map) {
        UUID id = GemItem.getUUIDs(gem).get(0);
        for (Attribute attr : this.attributes) {
            AttributeModifier modif = new AttributeModifier(id, "apoth.gem_modifier.all_stats_buff", (double)this.values.get(rarity).min(), this.operation);
            map.accept(attr, modif);
        }
    }

    @Override
    public Component getSocketBonusTooltip(ItemStack gem, LootRarity rarity) {
        StepFunction value = this.values.get(rarity);
        return Component.m_237110_((String)("bonus." + this.getId() + ".desc"), (Object[])new Object[]{Affix.fmt(value.get(0.0f) * 100.0f)}).m_130940_(ChatFormatting.YELLOW);
    }

    @Override
    public AllStatsBonus validate() {
        Preconditions.checkNotNull((Object)this.operation, (Object)"Invalid AllStatsBonus with null operation");
        Preconditions.checkNotNull(this.values, (Object)"Invalid AllStatsBonus with null values");
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 1;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }
}

