/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.reforging;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.affix.reforging.ReforgingRecipe;
import shadows.apotheosis.adventure.affix.reforging.ReforgingTableTile;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootController;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.cap.InternalItemHandler;
import shadows.placebo.container.BlockEntityContainer;
import shadows.placebo.container.ContainerUtil;
import shadows.placebo.container.PlaceboContainerMenu;

public class ReforgingMenu
extends BlockEntityContainer<ReforgingTableTile> {
    public static final String REFORGE_SEED = "apoth_reforge_seed";
    protected final Player player;
    protected InternalItemHandler itemInv = new InternalItemHandler(1);
    protected final RandomSource random = new XoroshiroRandomSource(0L);
    protected final int[] seed = new int[2];
    protected final int[] costs = new int[3];
    protected DataSlot needsReset = DataSlot.m_39401_();

    public ReforgingMenu(int id, Inventory inv, BlockPos pos) {
        super((MenuType)Apoth.Menus.REFORGING.get(), id, inv, pos);
        this.player = inv.f_35978_;
        this.m_38897_((Slot)new PlaceboContainerMenu.UpdatingSlot(this.itemInv, 0, 25, 24, stack -> !LootCategory.forItem(stack).isNone()){

            public int m_6641_() {
                return 1;
            }

            public int m_5866_(ItemStack pStack) {
                return 1;
            }
        });
        this.m_38897_((Slot)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, ((ReforgingTableTile)this.tile).inv, 0, 15, 45, ((ReforgingTableTile)this.tile)::isValidRarityMat));
        this.m_38897_((Slot)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, ((ReforgingTableTile)this.tile).inv, 1, 35, 45, stack -> stack.m_41720_() == Apoth.Items.GEM_DUST.get()));
        this.addPlayerSlots(inv, 8, 84);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && !LootCategory.forItem(stack).isNone(), 0, 1);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && ((ReforgingTableTile)this.tile).isValidRarityMat((ItemStack)stack), 1, 2);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && stack.m_41720_() == Apoth.Items.GEM_DUST.get(), 2, 3);
        this.mover.registerRule((stack, slot) -> slot < this.playerInvStart, this.playerInvStart, this.hotbarStart + 9);
        this.registerInvShuffleRules();
        this.updateSeed();
        this.m_38895_(this.needsReset);
        this.m_38895_(DataSlot.m_39406_((int[])this.seed, (int)0));
        this.m_38895_(DataSlot.m_39406_((int[])this.seed, (int)1));
        this.m_38895_(DataSlot.m_39406_((int[])this.costs, (int)0));
        this.m_38895_(DataSlot.m_39406_((int[])this.costs, (int)1));
        this.m_38895_(DataSlot.m_39406_((int[])this.costs, (int)2));
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.m_150411_(pPlayer, (Container)new RecipeWrapper((IItemHandlerModifiable)this.itemInv));
    }

    protected void updateSeed() {
        int seed = this.player.getPersistentData().m_128451_(REFORGE_SEED);
        if (seed == 0) {
            seed = this.player.f_19796_.m_188502_();
            this.player.getPersistentData().m_128405_(REFORGE_SEED, seed);
        }
        this.seed[0] = ContainerUtil.split((int)seed, (boolean)false);
        this.seed[1] = ContainerUtil.split((int)seed, (boolean)true);
    }

    public int getSeed() {
        return ContainerUtil.merge((int)this.seed[0], (int)this.seed[1], (boolean)true);
    }

    public boolean m_6366_(Player player, int slot) {
        if (slot >= 0 && slot < 3) {
            ItemStack input = this.m_38853_(0).m_7993_();
            LootRarity rarity = this.getRarity();
            ReforgingRecipe recipe = ((ReforgingTableTile)this.tile).getRecipeFor(rarity);
            if (recipe == null || input.m_41619_() || this.needsReset()) {
                return false;
            }
            int dust = this.getDustCount();
            int dustCost = this.getDustCost(slot);
            int mats = this.getMatCount();
            int matCost = this.getMatCost(slot);
            int levels = this.player.f_36078_;
            int levelCost = this.getLevelCost(slot);
            if (!(dust >= dustCost && mats >= matCost && levels >= levelCost || player.m_7500_())) {
                return false;
            }
            if (!player.f_19853_.f_46443_) {
                ItemStack[] choices = new ItemStack[3];
                RandomSource rand = this.random;
                for (int i = 0; i < 3; ++i) {
                    rand.m_188584_((long)(this.getSeed() ^ ForgeRegistries.ITEMS.getKey((Object)input.m_41720_()).hashCode() + i));
                    choices[i] = LootController.createLootItem(input.m_41777_(), rarity, rand);
                }
                ItemStack out = choices[slot];
                this.m_38853_(0).m_5852_(out);
                if (!player.m_7500_()) {
                    this.m_38853_(1).m_7993_().m_41774_(matCost);
                    this.m_38853_(2).m_7993_().m_41774_(dustCost);
                }
                player.m_6749_(-3 * ++slot);
                player.getPersistentData().m_128405_(REFORGE_SEED, player.f_19796_.m_188502_());
                this.updateSeed();
                this.needsReset.m_6422_(1);
            }
            player.m_5496_(SoundEvents.f_11862_, 0.99f, this.level.f_46441_.m_188501_() * 0.25f + 1.0f);
            player.m_5496_(SoundEvents.f_144054_, 0.34f, this.level.f_46441_.m_188501_() * 0.2f + 0.8f);
            player.m_5496_(SoundEvents.f_12471_, 0.45f, this.level.f_46441_.m_188501_() * 0.5f + 0.75f);
            return true;
        }
        return super.m_6366_(player, slot);
    }

    public int getMatCount() {
        return this.m_38853_(1).m_7993_().m_41613_();
    }

    public int getDustCount() {
        return this.m_38853_(2).m_7993_().m_41613_();
    }

    @Nullable
    public LootRarity getRarity() {
        ItemStack s = this.m_38853_(1).m_7993_();
        if (s.m_41619_()) {
            return null;
        }
        return LootRarity.getMaterialRarity(s);
    }

    public int getDustCost(int slot) {
        return this.costs[0] * ++slot;
    }

    public int getMatCost(int slot) {
        return this.costs[1] * ++slot;
    }

    public int getLevelCost(int slot) {
        return this.costs[2] * ++slot;
    }

    public boolean needsReset() {
        return this.needsReset.m_6501_() != 0;
    }

    public void m_6199_(Container pContainer) {
        ReforgingRecipe recipe;
        LootRarity rarity = this.getRarity();
        if (rarity != null && (recipe = ((ReforgingTableTile)this.tile).getRecipeFor(rarity)) != null) {
            this.costs[0] = recipe.dustCost();
            this.costs[1] = recipe.matCost();
            this.costs[2] = recipe.levelCost();
        }
        if (this.needsReset()) {
            this.needsReset.m_6422_(0);
        }
        super.m_6199_(pContainer);
    }
}

