/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.registry;

import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.generator.DataJsonGenerator;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;

public abstract class BuilderBase<T>
implements Supplier<T> {
    public final ResourceLocation id;
    protected T object;
    public String translationKey;
    public String displayName;
    public transient boolean dummyBuilder;
    public transient Set<ResourceLocation> defaultTags;

    public BuilderBase(ResourceLocation i) {
        this.id = i;
        this.object = null;
        this.translationKey = "";
        this.displayName = "";
        this.dummyBuilder = false;
        this.defaultTags = new HashSet<ResourceLocation>();
    }

    public abstract RegistryInfo getRegistryType();

    public abstract T createObject();

    public T transformObject(T obj) {
        return obj;
    }

    @Override
    public final T get() {
        try {
            return this.object;
        }
        catch (Exception ex) {
            if (this.dummyBuilder) {
                throw new RuntimeException("Object '" + this.id + "' of registry '" + this.getRegistryType().key.m_135782_() + "' is from a dummy builder and doesn't have a value!");
            }
            throw new RuntimeException("Object '" + this.id + "' of registry '" + this.getRegistryType().key.m_135782_() + "' hasn't been registered yet!", ex);
        }
    }

    public void createAdditionalObjects() {
    }

    public String getTranslationKeyGroup() {
        return this.getRegistryType().key.m_135782_().m_135815_();
    }

    @Info(value="Sets the translation key for this object, e.g. `block.minecraft.stone`.\n")
    public BuilderBase<T> translationKey(String key) {
        this.translationKey = key;
        return this;
    }

    @Info(value="Sets the display name for this object, e.g. `Stone`.\n\nThis will be overridden by a lang file if it exists.\n")
    public BuilderBase<T> displayName(String name) {
        this.displayName = name;
        return this;
    }

    @Info(value="Adds a tag to this object, e.g. `minecraft:stone`.\n")
    public BuilderBase<T> tag(ResourceLocation tag) {
        this.defaultTags.add(tag);
        this.getRegistryType().hasDefaultTags = true;
        return this;
    }

    public ResourceLocation newID(String pre, String post) {
        if (pre.isEmpty() && post.isEmpty()) {
            return this.id;
        }
        return new ResourceLocation(this.id.m_135827_() + ":" + pre + this.id.m_135815_() + post);
    }

    public void generateDataJsons(DataJsonGenerator generator) {
    }

    public void generateAssetJsons(AssetJsonGenerator generator) {
    }

    public void generateLang(Map<String, String> lang) {
        String dname;
        Object tkey = this.translationKey;
        if (((String)tkey).isEmpty()) {
            tkey = this.getTranslationKeyGroup() + "." + this.id.m_135827_() + "." + this.id.m_135815_();
        }
        if ((dname = this.displayName).isEmpty()) {
            dname = UtilsJS.snakeCaseToTitleCase(this.id.m_135815_());
        }
        lang.put((String)tkey, dname);
    }

    public void addResourcePackLocations(String path, List<ResourceLocation> list, PackType packType) {
    }

    protected T createTransformedObject() {
        this.object = this.transformObject(this.createObject());
        return this.object;
    }
}

