/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.forge;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.bindings.event.ClientEvents;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.client.AtlasSpriteRegistryEventJS;
import dev.latvian.mods.kubejs.fluid.FluidBucketItemBuilder;
import dev.latvian.mods.kubejs.fluid.FluidBuilder;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class KubeJSForgeClient {
    public KubeJSForgeClient() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.LOW, this::setupClient);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::blockColors);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::itemColors);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::textureStitch);
    }

    private void setupClient(FMLClientSetupEvent event) {
        BuilderBase b;
        KubeJS.PROXY.clientSetup();
        for (BuilderBase<?> builder : RegistryInfo.BLOCK) {
            if (!(builder instanceof BlockBuilder)) continue;
            b = (BlockBuilder)builder;
            switch (((BlockBuilder)b).renderType) {
                case "cutout": {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)b.get()), (RenderType)RenderType.m_110463_());
                    break;
                }
                case "cutout_mipped": {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)b.get()), (RenderType)RenderType.m_110457_());
                    break;
                }
                case "translucent": {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)b.get()), (RenderType)RenderType.m_110466_());
                }
            }
        }
        for (BuilderBase<?> builder : RegistryInfo.FLUID) {
            if (!(builder instanceof FluidBuilder)) continue;
            b = (FluidBuilder)builder;
            switch (((FluidBuilder)b).renderType) {
                case "cutout": {
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)b.get()), (RenderType)RenderType.m_110463_());
                    break;
                }
                case "cutout_mipped": {
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)b.get()), (RenderType)RenderType.m_110457_());
                    break;
                }
                case "translucent": {
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)b.get()), (RenderType)RenderType.m_110466_());
                }
            }
        }
    }

    private void blockColors(RegisterColorHandlersEvent.Block event) {
        for (BuilderBase<?> builder : RegistryInfo.BLOCK) {
            if (!(builder instanceof BlockBuilder)) continue;
            BlockBuilder b = (BlockBuilder)builder;
            if (b.color.isEmpty()) continue;
            event.register((state, level, pos, index) -> b.color.get(index), new Block[]{(Block)b.get()});
        }
    }

    private void itemColors(RegisterColorHandlersEvent.Item event) {
        for (BuilderBase<?> builder : RegistryInfo.ITEM) {
            ItemBuilder b;
            if (builder instanceof ItemBuilder) {
                b = (ItemBuilder)builder;
                if (b.colorCallback != null) {
                    event.register((stack, tintIndex) -> b.colorCallback.getColor(stack, tintIndex).getArgbJS(), new ItemLike[]{(ItemLike)b.get()});
                }
            }
            if (!(builder instanceof FluidBucketItemBuilder)) continue;
            b = (FluidBucketItemBuilder)builder;
            if (((FluidBucketItemBuilder)b).fluidBuilder.bucketColor == -1) continue;
            event.register((arg_0, arg_1) -> KubeJSForgeClient.lambda$itemColors$2((FluidBucketItemBuilder)b, arg_0, arg_1), new ItemLike[]{(ItemLike)b.get()});
        }
    }

    private void textureStitch(TextureStitchEvent.Pre event) {
        ClientEvents.ATLAS_SPRITE_REGISTRY.post(new AtlasSpriteRegistryEventJS(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0)), event.getAtlas().m_118330_());
    }

    private static /* synthetic */ int lambda$itemColors$2(FluidBucketItemBuilder b, ItemStack stack, int index) {
        return index == 1 ? b.fluidBuilder.bucketColor : -1;
    }
}

