/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import com.tom.storagemod.Content;
import com.tom.storagemod.util.BlockFace;
import com.tom.storagemod.util.ItemPredicate;
import com.tom.storagemod.util.StoredItemStack;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class PolyFilter
implements ItemPredicate {
    private BlockFace face;
    private Set<ItemStack> filter;
    private long lastCheck;

    public PolyFilter(BlockFace face) {
        this.face = face;
        this.filter = new HashSet<ItemStack>();
    }

    private void updateFilter() {
        long time = this.face.level().m_46467_();
        if (time - this.lastCheck >= 10L) {
            this.lastCheck = time;
            this.filter.clear();
            BlockEntity be = this.face.getBlockEntity();
            if (be != null) {
                be.getCapability(ForgeCapabilities.ITEM_HANDLER, this.face.from()).ifPresent(ih -> IntStream.range(0, ih.getSlots()).mapToObj(arg_0 -> ((IItemHandler)ih).getStackInSlot(arg_0)).filter(s -> !s.m_41619_()).map(StoredItemStack::new).distinct().map(StoredItemStack::getStack).forEach(this.filter::add));
            }
        }
    }

    @Override
    public boolean test(ItemStack stack) {
        this.updateFilter();
        for (ItemStack is : this.filter) {
            if (!ItemStack.m_41746_((ItemStack)stack, (ItemStack)is)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean configMatch(ItemStack stack) {
        return stack.m_41720_() == Content.polyItemFliter.get();
    }
}

