/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.client.screen.addon.BasicButtonAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.util.AssetUtil;
import com.hrznstudio.titanium.util.FacingUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.screens.Screen;

public class ArrowButtonScreenAddon
extends BasicButtonAddon {
    private ArrowButtonComponent button;
    private IAsset asset;

    public ArrowButtonScreenAddon(ArrowButtonComponent button) {
        super(button);
        this.button = button;
    }

    @Override
    public int getXSize() {
        return this.asset != null ? this.asset.getArea().width : 0;
    }

    @Override
    public int getYSize() {
        return this.asset != null ? this.asset.getArea().height : 0;
    }

    @Override
    public void drawBackgroundLayer(PoseStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.asset = provider.getAsset(this.getAssetFromSideness(this.button.getDirection()));
        AssetUtil.drawAsset(stack, screen, this.asset, guiX + this.getPosX(), guiY + this.getPosY());
    }

    @Override
    public void drawForegroundLayer(PoseStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
    }

    public IAssetType<IAsset> getAssetFromSideness(FacingUtil.Sideness sideness) {
        switch (sideness) {
            case LEFT: {
                return AssetTypes.BUTTON_ARROW_LEFT;
            }
            case RIGHT: {
                return AssetTypes.BUTTON_ARROW_RIGHT;
            }
            case BOTTOM: {
                return AssetTypes.BUTTON_ARROW_DOWN;
            }
        }
        return AssetTypes.BUTTON_ARROW_UP;
    }
}

