/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile;

import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.IScreenInfoProvider;
import com.hrznstudio.titanium.nbthandler.NBTManager;
import com.hrznstudio.titanium.network.messages.TileFieldNetworkMessage;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BasicTile<T extends BasicTile<T>>
extends BlockEntity
implements IScreenInfoProvider {
    private final BasicTileBlock<T> basicTileBlock;

    public BasicTile(BasicTileBlock<T> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.basicTileBlock = base;
    }

    @ParametersAreNonnullByDefault
    public InteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        return InteractionResult.PASS;
    }

    public void onNeighborChanged(Block blockIn, BlockPos fromPos) {
    }

    public void m_142339_(Level p_155231_) {
        super.m_142339_(p_155231_);
        if (this.isClient()) {
            this.initClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
    }

    public void m_142466_(CompoundTag compound) {
        NBTManager.getInstance().readTileEntity(this, compound);
        super.m_142466_(compound);
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        NBTManager.getInstance().writeTileEntity(this, compoundTag);
    }

    public void markForUpdate() {
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58904_().m_8055_(this.m_58899_()), this.m_58904_().m_8055_(this.m_58899_()), 3);
        this.m_6596_();
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, blockEntity -> tag);
    }

    public void updateNeigh() {
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
    }

    public void syncObject(Object object) {
        if (this.isServer()) {
            CompoundTag nbt = NBTManager.getInstance().writeTileEntityObject(this, object, new CompoundTag());
            Titanium.NETWORK.sendToNearby(this.f_58857_, this.f_58858_, 64, new TileFieldNetworkMessage(this.f_58858_, nbt));
        }
    }

    public void handleSyncObject(CompoundTag nbt) {
        NBTManager.getInstance().readTileEntity(this, nbt);
    }

    public boolean isClient() {
        return this.f_58857_.f_46443_;
    }

    public boolean isServer() {
        return !this.isClient();
    }

    public BasicTileBlock<T> getBasicTileBlock() {
        return this.basicTileBlock;
    }
}

