/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.effect;

import com.github.L_Ender.cataclysm.Cataclysm;
import com.github.L_Ender.cataclysm.client.particle.StormParticle;
import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.Ancient_Remnant_Entity;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModEntities;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Sandstorm_Entity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> CREATOR_ID = SynchedEntityData.m_135353_(Sandstorm_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.m_135353_(Sandstorm_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> OFFSET = SynchedEntityData.m_135353_(Sandstorm_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public Sandstorm_Entity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public Sandstorm_Entity(Level worldIn, double x, double y, double z, int lifespan, float offset, UUID casterIn) {
        this((EntityType)ModEntities.SANDSTORM.get(), worldIn);
        this.setCreatorEntityUUID(casterIn);
        this.setLifespan(lifespan);
        this.m_6034_(x, y, z);
        this.setOffset(offset);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        this.updateMotion();
        Entity owner = this.getCreatorEntity();
        if (owner != null && !owner.m_6084_()) {
            this.m_146870_();
        }
        if (this.f_19853_.f_46443_) {
            float ran = 0.04f;
            float r = 0.89f + this.f_19796_.m_188501_() * ran;
            float g = 0.85f + this.f_19796_.m_188501_() * ran;
            float b = 0.69f + this.f_19796_.m_188501_() * ran * 1.5f;
            this.f_19853_.m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 2.75f + this.f_19796_.m_188501_() * 0.6f, 3.75f + this.f_19796_.m_188501_() * 0.6f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 2.5f + this.f_19796_.m_188501_() * 0.45f, 3.0f + this.f_19796_.m_188501_() * 0.45f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 2.25f + this.f_19796_.m_188501_() * 0.45f, 2.25f + this.f_19796_.m_188501_() * 0.45f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 1.25f + this.f_19796_.m_188501_() * 0.45f, 1.25f + this.f_19796_.m_188501_() * 0.45f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (!this.m_20067_() && this.f_19853_.f_46443_) {
            Cataclysm.PROXY.playWorldSound((Object)this, (byte)2);
        }
        for (LivingEntity entity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2))) {
            if (entity instanceof Player && ((Player)entity).m_150110_().f_35934_ || entity == owner || !entity.m_6084_() || entity.m_20147_() || this.f_19797_ % 3 != 0) continue;
            if (owner == null) {
                boolean flag = entity.m_6469_(DamageSource.f_19319_, (float)CMConfig.Sandstormdamage);
                if (!flag) continue;
                MobEffectInstance effectinstance = new MobEffectInstance((MobEffect)ModEffect.EFFECTCURSE_OF_DESERT.get(), 200, 0);
                entity.m_7292_(effectinstance);
                continue;
            }
            if (owner.m_7307_((Entity)entity)) {
                return;
            }
            boolean flag = entity.m_6469_(DamageSource.m_19367_((Entity)this, (Entity)owner), (float)CMConfig.Sandstormdamage);
            if (!flag) continue;
            MobEffectInstance effectinstance = new MobEffectInstance((MobEffect)ModEffect.EFFECTCURSE_OF_DESERT.get(), 200, 0);
            entity.m_7292_(effectinstance);
        }
        this.setLifespan(this.getLifespan() - 1);
        if (this.getLifespan() <= 0) {
            Cataclysm.PROXY.clearSoundCacheFor(this);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public int getLifespan() {
        return (Integer)this.f_19804_.m_135370_(LIFESPAN);
    }

    public void setLifespan(int i) {
        this.f_19804_.m_135381_(LIFESPAN, (Object)i);
    }

    public float getOffset() {
        return ((Float)this.f_19804_.m_135370_(OFFSET)).floatValue();
    }

    public void setOffset(float i) {
        this.f_19804_.m_135381_(OFFSET, (Object)Float.valueOf(i));
    }

    public UUID getCreatorEntityUUID() {
        return ((Optional)this.f_19804_.m_135370_(CREATOR_ID)).orElse(null);
    }

    public void setCreatorEntityUUID(UUID id) {
        this.f_19804_.m_135381_(CREATOR_ID, Optional.ofNullable(id));
    }

    public Entity getCreatorEntity() {
        UUID uuid = this.getCreatorEntityUUID();
        if (uuid != null && !this.f_19853_.f_46443_) {
            return ((ServerLevel)this.f_19853_).m_8791_(uuid);
        }
        return null;
    }

    private void updateMotion() {
        Entity owner = this.getCreatorEntity();
        if (owner != null && owner instanceof Ancient_Remnant_Entity) {
            Vec3 center = owner.m_20182_().m_82520_(0.0, 0.0, 0.0);
            float radius = 8.0f;
            float speed = (float)this.f_19797_ * 0.04f;
            float offset = this.getOffset();
            Vec3 orbit = new Vec3(center.f_82479_ + Math.cos(speed + offset) * (double)radius, center.f_82480_, center.f_82481_ + Math.sin(speed + offset) * (double)radius);
            this.m_20219_(orbit);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CREATOR_ID, Optional.empty());
        this.f_19804_.m_135372_(LIFESPAN, (Object)300);
        this.f_19804_.m_135372_(OFFSET, (Object)Float.valueOf(0.0f));
    }

    protected void m_7378_(CompoundTag compound) {
        UUID uuid;
        this.setLifespan(compound.m_128451_("Lifespan"));
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setCreatorEntityUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Lifespan", this.getLifespan());
        if (this.getCreatorEntityUUID() != null) {
            compound.m_128362_("Owner", this.getCreatorEntityUUID());
        }
    }
}

